/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.tools.printscu;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.dcm4che.tools.printscu.PrintSCUFrame;

public class PropertiesPanel
extends JPanel
implements TableModelListener,
MouseListener {
    private final Logger log = Logger.getLogger(PrintSCUFrame.class);
    private Properties props;
    static final String[] KEYS = new String[]{"Host", "Port", "CalledAET", "CallingAET", "MaxPduSize", "Grouplens", "SOP.Verification", "SOP.BasicGrayscalePrintManagement", "SOP.BasicColorPrintManagement", "SOP.BasicAnnotationBox", "SOP.BasicPrintImageOverlayBox", "SOP.PresentationLUT", "SOP.PrintJob", "SOP.PrinterConfigurationRetrieval", "Session.NumberOfCopies", "Session.PrintPriority", "Session.MediumType", "Session.FilmDestination", "Session.FilmSessionLabel", "Session.MemoryAllocation", "Session.OwnerID", "FilmBox.ImageDisplayFormat", "FilmBox.FilmOrientation", "FilmBox.FilmSizeID", "FilmBox.RequestedResolutionID", "FilmBox.AnnotationDisplayFormatID", "FilmBox.MagnificationType", "FilmBox.SmoothingType", "FilmBox.BorderDensity", "FilmBox.EmptyImageDensity", "FilmBox.MinDensity", "FilmBox.MaxDensity", "FilmBox.Trim", "FilmBox.ConfigurationInformation", "FilmBox.Illumination", "FilmBox.ReflectedAmbientLight", "ImageBox.Polarity", "ImageBox.MagnificationType", "ImageBox.SmoothingType", "ImageBox.MinDensity", "ImageBox.MaxDensity", "ImageBox.ConfigurationInformation", "ImageBox.RequestedDecimateCropBehavior", "ImageBox.RequestedImageSize", "LUT.Shape", "LUT.Gamma", "User.BurnInOverlays", "User.AutoScale", "Verbose"};
    private static final Properties DEFAULTS = new Properties();
    private static final String[] PRINT_PRIORITY;
    private static final String[] MEDIUM_TYPE;
    private static final String[] FILM_DESTINATION;
    private static final String[] IMAGE_DISPLAY_FORMAT;
    private static final String[] FILM_ORIENTATION;
    private static final String[] FILM_SIZE_ID;
    private static final String[] MAGNIFICATION_TYPE;
    private static final String[] DENSITY;
    private static final String[] YES_NO;
    private static final String[] REQUESTED_RESOLUTION_ID;
    private static final String[] POLARITY;
    private static final String[] REQUESTED_DECIMATE_CROP_BEHAVIOR;
    private static final String[] SEND_ASPECTRATIO;
    private static final String[] BURNIN_INFO;
    static final int LUT_FILE = 0;
    static final int LUT_GAMMA = 1;
    static final int LUT_IDENTITY = 2;
    static final int LUT_LIN_OD = 3;
    static final int LUT_INVERSE = 4;
    private static final String[] LUT_SHAPE;
    private static final String[] LUT_LEVEL;
    private static final String[] INFLATE_BIT_DEPTH;
    private static final String[] VERBOSE;
    private static final Map PROP_ENUMS;
    private PrintSCUFrame printSCUFrame;
    private JTable table;
    private TableModel model;

    PropertiesPanel(PrintSCUFrame printSCUFrame, String fileName) {
        this.printSCUFrame = printSCUFrame;
        this.setLayout(new BoxLayout(this, 0));
        File file = new File(fileName);
        this.props = this.loadProperties(file);
        this.table = new JTable(KEYS.length, 2);
        for (int i = 0; i < KEYS.length; ++i) {
            this.table.setValueAt(KEYS[i], i, 0);
            this.table.setValueAt(this.props.getProperty(KEYS[i]), i, 1);
        }
        this.model = this.table.getModel();
        this.model.addTableModelListener(this);
        this.table.addMouseListener(this);
        this.add(this.table);
    }

    public void mouseClicked(MouseEvent e) {
        int column = this.table.getSelectedColumn();
        int row = this.table.getSelectedRow();
        if (column == 0) {
            String prop = (String)this.table.getValueAt(row, 0);
            String value = this.props.getProperty(prop);
            Object[] choices = (String[])PROP_ENUMS.get(prop);
            if (choices == null) {
                return;
            }
            value = (String)JOptionPane.showInputDialog(this.printSCUFrame, "Choose a value:", prop, 3, null, choices, choices[0]);
            if (value != null) {
                this.table.setValueAt(value, row, 1);
                if (value.equals("")) {
                    this.props.remove(prop);
                } else {
                    this.props.setProperty(prop, value);
                }
            }
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (column != 1) {
            return;
        }
        String prop = (String)this.model.getValueAt(row, 0);
        String data = (String)this.model.getValueAt(row, 1);
        this.props.put(prop, data);
        this.printSCUFrame.propertyChanged(prop);
    }

    private Properties loadProperties(File file) {
        Properties props = new Properties(DEFAULTS);
        try {
            props.load(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            this.log.warn("No properties file was found, using default settings");
        }
        catch (IOException e) {
            this.log.warn("Can not load properties file");
        }
        return props;
    }

    String getProperty(String key) {
        return this.props.getProperty(key);
    }

    static {
        DEFAULTS.put("Host", "localhost");
        DEFAULTS.put("CallingAET", "PrintSCU");
        DEFAULTS.put("CalledAET", "TIANI_PRINT");
        DEFAULTS.put("Port", "6104");
        DEFAULTS.put("FilmBox.ImageDisplayFormat", "STANDARD\\1,1");
        DEFAULTS.put("FilmBox.AnnotationDisplayFormatID", "TITLE");
        PRINT_PRIORITY = new String[]{"", "HIGH", "MED", "LOW"};
        MEDIUM_TYPE = new String[]{"", "PAPER", "CLEAR FILM", "BLUE FILM"};
        FILM_DESTINATION = new String[]{"", "MAGAZINE", "PROCESSOR", "BIN_1", "BIN_2", "BIN_3", "BIN_4", "BIN_5", "BIN_6", "BIN_7", "BIN_8"};
        IMAGE_DISPLAY_FORMAT = new String[]{"STANDARD\\1,1", "STANDARD\\2,3", "ROW\\2", "COL\\2", "SLIDE", "SUPERSLIDE", "CUSTOM\\1"};
        FILM_ORIENTATION = new String[]{"", "PORTRAIT", "LANDSCAPE"};
        FILM_SIZE_ID = new String[]{"", "8INX10IN", "10INX12IN", "10INX14IN", "11INX14IN", "14INX14IN", "14INX17IN", "24CMX24CM", "24CMX30CM"};
        MAGNIFICATION_TYPE = new String[]{"", "REPLICATE", "BILINEAR", "CUBIC", "NONE"};
        DENSITY = new String[]{"", "BLACK", "WHITE"};
        YES_NO = new String[]{"", "YES", "NO"};
        REQUESTED_RESOLUTION_ID = new String[]{"", "STANDARD", "HIGH"};
        POLARITY = new String[]{"", "NORMAL", "REVERSE"};
        REQUESTED_DECIMATE_CROP_BEHAVIOR = new String[]{"", "DECIMATE", "CROP", "FAIL"};
        SEND_ASPECTRATIO = new String[]{"Always", "IfNot1/1"};
        BURNIN_INFO = new String[]{"No", "IfNoOverlays", "Always"};
        LUT_SHAPE = new String[]{"<file>", "<gamma>", "IDENTITY", "LIN OD", "INVERSE"};
        LUT_LEVEL = new String[]{"FilmSession", "FilmBox", "ImageBox"};
        INFLATE_BIT_DEPTH = new String[]{"Always", "IfNonLinear", "No"};
        VERBOSE = new String[]{"0", "1", "2", "3", "4", "5", "6"};
        PROP_ENUMS = new HashMap();
        PROP_ENUMS.put("Session.FilmDestination", FILM_DESTINATION);
        PROP_ENUMS.put("Session.FilmOrientation", FILM_ORIENTATION);
        PROP_ENUMS.put("Session.MediumType", MEDIUM_TYPE);
        PROP_ENUMS.put("Session.PrintPriority", PRINT_PRIORITY);
        PROP_ENUMS.put("FilmBox.ImageDisplayFormat", IMAGE_DISPLAY_FORMAT);
        PROP_ENUMS.put("FilmBox.FilmSizeID", FILM_SIZE_ID);
        PROP_ENUMS.put("FilmBox.MagnificationType", MAGNIFICATION_TYPE);
        PROP_ENUMS.put("FilmBox.RequestedResolutionID", REQUESTED_RESOLUTION_ID);
        PROP_ENUMS.put("ImageBox.RequestedDecimateCropBehavior", REQUESTED_DECIMATE_CROP_BEHAVIOR);
        PROP_ENUMS.put("ImageBox.Polarity", POLARITY);
        PROP_ENUMS.put("User.SendAspectRatio", SEND_ASPECTRATIO);
        PROP_ENUMS.put("User.BurnInInfo", BURNIN_INFO);
        PROP_ENUMS.put("User.BurnInOverlays", YES_NO);
        PROP_ENUMS.put("User.AutoScale", YES_NO);
        PROP_ENUMS.put("Verbose", VERBOSE);
    }
}

