/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Rectangle;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class LocalStorage
extends AbstractBean {
    private static Logger logger = Logger.getLogger(LocalStorage.class.getName());
    private final ApplicationContext context;
    private long storageLimit = -1L;
    private LocalIO localIO = null;
    private final File unspecifiedFile;
    private File directory = this.unspecifiedFile = new File("unspecified");

    protected LocalStorage(ApplicationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = context;
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    private void checkFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
    }

    public InputStream openInputFile(String fileName) throws IOException {
        this.checkFileName(fileName);
        return this.getLocalIO().openInputFile(fileName);
    }

    public OutputStream openOutputFile(String fileName) throws IOException {
        this.checkFileName(fileName);
        return this.getLocalIO().openOutputFile(fileName);
    }

    public boolean deleteFile(String fileName) throws IOException {
        this.checkFileName(fileName);
        return this.getLocalIO().deleteFile(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object bean, String fileName) throws IOException {
        AbortExceptionListener el = new AbortExceptionListener();
        XMLEncoder e = null;
        ByteArrayOutputStream bst = new ByteArrayOutputStream();
        try {
            e = new XMLEncoder(bst);
            e.setExceptionListener(el);
            e.setPersistenceDelegate(Rectangle.class, new RectanglePD());
            e.writeObject(bean);
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        if (el.exception != null) {
            throw new LSException("save failed \"" + fileName + "\"", el.exception);
        }
        OutputStream ost = null;
        try {
            ost = this.openOutputFile(fileName);
            ost.write(bst.toByteArray());
        }
        finally {
            if (ost != null) {
                ost.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String fileName) throws IOException {
        InputStream ist = null;
        try {
            ist = this.openInputFile(fileName);
        }
        catch (IOException e) {
            return null;
        }
        AbortExceptionListener el = new AbortExceptionListener();
        XMLDecoder d = null;
        try {
            d = new XMLDecoder(ist);
            d.setExceptionListener(el);
            Object bean = d.readObject();
            if (el.exception != null) {
                throw new LSException("load failed \"" + fileName + "\"", el.exception);
            }
            Object object = bean;
            return object;
        }
        finally {
            if (d != null) {
                d.close();
            }
        }
    }

    private void closeStream(Closeable st, String fileName) throws IOException {
        if (st != null) {
            try {
                st.close();
            }
            catch (IOException e) {
                throw new LSException("close failed \"" + fileName + "\"", e);
            }
        }
    }

    public long getStorageLimit() {
        return this.storageLimit;
    }

    public void setStorageLimit(long storageLimit) {
        if (storageLimit < -1L) {
            throw new IllegalArgumentException("invalid storageLimit");
        }
        long oldValue = this.storageLimit;
        this.storageLimit = storageLimit;
        this.firePropertyChange("storageLimit", oldValue, this.storageLimit);
    }

    private String getId(String key, String def) {
        ResourceMap appResourceMap = this.getContext().getResourceMap();
        String id = appResourceMap.getString(key, new Object[0]);
        if (id == null) {
            logger.log(Level.WARNING, "unspecified resource " + key + " using " + def);
            id = def;
        } else if (id.trim().length() == 0) {
            logger.log(Level.WARNING, "empty resource " + key + " using " + def);
            id = def;
        }
        return id;
    }

    private String getApplicationId() {
        return this.getId("Application.id", this.getContext().getApplicationClass().getSimpleName());
    }

    private String getVendorId() {
        return this.getId("Application.vendorId", "UnknownApplicationVendor");
    }

    private OSId getOSId() {
        PrivilegedAction<String> doGetOSName = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        };
        OSId id = OSId.UNIX;
        String osName = AccessController.doPrivileged(doGetOSName);
        if (osName != null) {
            if (osName.toLowerCase().startsWith("mac os x")) {
                id = OSId.OSX;
            } else if (osName.contains("Windows")) {
                id = OSId.WINDOWS;
            }
        }
        return id;
    }

    public File getDirectory() {
        if (this.directory == this.unspecifiedFile) {
            this.directory = null;
            String userHome = null;
            try {
                userHome = System.getProperty("user.home");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (userHome != null) {
                String applicationId = this.getApplicationId();
                OSId osId = this.getOSId();
                if (osId == OSId.WINDOWS) {
                    File appDataDir = null;
                    try {
                        String appDataEV = System.getenv("APPDATA");
                        if (appDataEV != null && appDataEV.length() > 0) {
                            appDataDir = new File(appDataEV);
                        }
                    }
                    catch (SecurityException ignore) {
                        // empty catch block
                    }
                    String vendorId = this.getVendorId();
                    if (appDataDir != null && appDataDir.isDirectory()) {
                        String path = vendorId + "\\" + applicationId + "\\";
                        this.directory = new File(appDataDir, path);
                    } else {
                        String path = "Application Data\\" + vendorId + "\\" + applicationId + "\\";
                        this.directory = new File(userHome, path);
                    }
                } else if (osId == OSId.OSX) {
                    String path = "Library/Application Support/" + applicationId + "/";
                    this.directory = new File(userHome, path);
                } else {
                    String path = "." + applicationId + "/";
                    this.directory = new File(userHome, path);
                }
            }
        }
        return this.directory;
    }

    public void setDirectory(File directory) {
        File oldValue = this.directory;
        this.directory = directory;
        this.firePropertyChange("directory", oldValue, this.directory);
    }

    private synchronized LocalIO getLocalIO() {
        if (this.localIO == null) {
            this.localIO = this.getPersistenceServiceIO();
            if (this.localIO == null) {
                this.localIO = new LocalFileIO();
            }
        }
        return this.localIO;
    }

    private LocalIO getPersistenceServiceIO() {
        try {
            Class<?> smClass = Class.forName("javax.jnlp.ServiceManager");
            Method getServiceNamesMethod = smClass.getMethod("getServiceNames", new Class[0]);
            String[] serviceNames = (String[])getServiceNamesMethod.invoke(null, new Object[0]);
            boolean psFound = false;
            boolean bsFound = false;
            for (String serviceName : serviceNames) {
                if (serviceName.equals("javax.jnlp.BasicService")) {
                    bsFound = true;
                    continue;
                }
                if (!serviceName.equals("javax.jnlp.PersistenceService")) continue;
                psFound = true;
            }
            if (bsFound && psFound) {
                return new PersistenceServiceIO();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private class PersistenceServiceIO
    extends LocalIO {
        private BasicService bs;
        private PersistenceService ps;

        private String initFailedMessage(String s) {
            return this.getClass().getName() + " initialization failed: " + s;
        }

        PersistenceServiceIO() {
            try {
                this.bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                this.ps = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            }
            catch (UnavailableServiceException e) {
                logger.log(Level.SEVERE, this.initFailedMessage("ServiceManager.lookup"), e);
                this.bs = null;
                this.ps = null;
            }
        }

        private void checkBasics(String s) throws IOException {
            if (this.bs == null || this.ps == null) {
                throw new IOException(this.initFailedMessage(s));
            }
        }

        private URL fileNameToURL(String name) throws IOException {
            try {
                return new URL(this.bs.getCodeBase(), name);
            }
            catch (MalformedURLException e) {
                throw new LSException("invalid filename \"" + name + "\"", e);
            }
        }

        public InputStream openInputFile(String fileName) throws IOException {
            this.checkBasics("openInputFile");
            URL fileURL = this.fileNameToURL(fileName);
            try {
                return new BufferedInputStream(this.ps.get(fileURL).getInputStream());
            }
            catch (Exception e) {
                throw new LSException("openInputFile \"" + fileName + "\" failed", e);
            }
        }

        public OutputStream openOutputFile(String fileName) throws IOException {
            this.checkBasics("openOutputFile");
            URL fileURL = this.fileNameToURL(fileName);
            try {
                FileContents fc;
                block5: {
                    fc = null;
                    try {
                        fc = this.ps.get(fileURL);
                    }
                    catch (FileNotFoundException e) {
                        long maxSizeRequest = 131072L;
                        long maxSize = this.ps.create(fileURL, maxSizeRequest);
                        if (maxSize < maxSizeRequest) break block5;
                        fc = this.ps.get(fileURL);
                    }
                }
                if (fc != null && fc.canWrite()) {
                    return new BufferedOutputStream(fc.getOutputStream(true));
                }
                throw new IOException("unable to create FileContents object");
            }
            catch (Exception e) {
                throw new LSException("openOutputFile \"" + fileName + "\" failed", e);
            }
        }

        public boolean deleteFile(String fileName) throws IOException {
            this.checkBasics("deleteFile");
            URL fileURL = this.fileNameToURL(fileName);
            try {
                this.ps.delete(fileURL);
                return true;
            }
            catch (Exception e) {
                throw new LSException("openInputFile \"" + fileName + "\" failed", e);
            }
        }
    }

    private class LocalFileIO
    extends LocalIO {
        private LocalFileIO() {
        }

        public InputStream openInputFile(String fileName) throws IOException {
            File path = new File(LocalStorage.this.getDirectory(), fileName);
            try {
                return new BufferedInputStream(new FileInputStream(path));
            }
            catch (IOException e) {
                throw new LSException("couldn't open input file \"" + fileName + "\"", e);
            }
        }

        public OutputStream openOutputFile(String fileName) throws IOException {
            File dir = LocalStorage.this.getDirectory();
            if (!dir.isDirectory() && !dir.mkdirs()) {
                throw new LSException("couldn't create directory " + dir);
            }
            File path = new File(dir, fileName);
            try {
                return new BufferedOutputStream(new FileOutputStream(path));
            }
            catch (IOException e) {
                throw new LSException("couldn't open output file \"" + fileName + "\"", e);
            }
        }

        public boolean deleteFile(String fileName) throws IOException {
            File path = new File(LocalStorage.this.getDirectory(), fileName);
            return path.delete();
        }
    }

    private abstract class LocalIO {
        private LocalIO() {
        }

        public abstract InputStream openInputFile(String var1) throws IOException;

        public abstract OutputStream openOutputFile(String var1) throws IOException;

        public abstract boolean deleteFile(String var1) throws IOException;
    }

    private static class RectanglePD
    extends DefaultPersistenceDelegate {
        public RectanglePD() {
            super(new String[]{"x", "y", "width", "height"});
        }

        protected Expression instantiate(Object oldInstance, Encoder out) {
            Rectangle oldR = (Rectangle)oldInstance;
            Object[] constructorArgs = new Object[]{oldR.x, oldR.y, oldR.width, oldR.height};
            return new Expression(oldInstance, oldInstance.getClass(), "new", constructorArgs);
        }
    }

    private static class LSException
    extends IOException {
        public LSException(String s, Throwable e) {
            super(s);
            this.initCause(e);
        }

        public LSException(String s) {
            super(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OSId {
        WINDOWS,
        OSX,
        UNIX;

    }

    private static class AbortExceptionListener
    implements ExceptionListener {
        public Exception exception = null;

        private AbortExceptionListener() {
        }

        public void exceptionThrown(Exception e) {
            if (this.exception == null) {
                this.exception = e;
            }
        }
    }
}

