/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import open.dolphin.infomodel.AccessRightModel;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.queries.DolphinQuery;
import open.dolphin.utils.CombinedStringParser;

@Embeddable
public class DocInfoModel
extends InfoModel
implements Comparable {
    private static final long serialVersionUID = 5082783120126942636L;
    @Transient
    private long docPk;
    @Transient
    private long parentPk;
    @Column(nullable=false, length=32)
    private String docId;
    @Column(nullable=false)
    private String docType;
    @Column(nullable=false)
    private String title;
    @Column(nullable=false)
    private String purpose;
    @Transient
    private String purposeDesc;
    @Transient
    private String purposeCodeSys;
    @Transient
    private Date firstConfirmDate;
    @Transient
    private Date confirmDate;
    private String department;
    private String departmentDesc;
    @Transient
    private String departmentCodeSys;
    private String healthInsurance;
    private String healthInsuranceDesc;
    @Transient
    private String healthInsuranceCodeSys;
    private String healthInsuranceGUID;
    private boolean hasMark;
    private boolean hasImage;
    private boolean hasRp;
    private boolean hasTreatment;
    private boolean hasLaboTest;
    private String versionNumber;
    @Transient
    private String versionNotes;
    private String parentId;
    private String parentIdRelation;
    @Transient
    private String parentIdDesc;
    @Transient
    private String parentIdCodeSys;
    @Transient
    private Collection<AccessRightModel> accessRights;
    @Transient
    private String status;

    @Override
    public boolean search(DolphinQuery query) {
        if (this.title != null) {
            return this.title.indexOf(query.what("keyword")) != -1;
        }
        return false;
    }

    public long getDocPk() {
        return this.docPk;
    }

    public void setDocPk(long docPk) {
        this.docPk = docPk;
    }

    public long getParentPk() {
        return this.parentPk;
    }

    public void setParentPk(long parentPk) {
        this.parentPk = parentPk;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurposeDesc(String purposeDesc) {
        this.purposeDesc = purposeDesc;
    }

    public String getPurposeDesc() {
        return this.purposeDesc;
    }

    public void setPurposeCodeSys(String purposeCodeSys) {
        this.purposeCodeSys = purposeCodeSys;
    }

    public String getPurposeCodeSys() {
        return this.purposeCodeSys;
    }

    public void setFirstConfirmDate(Date firstConfirmDate) {
        this.firstConfirmDate = firstConfirmDate;
    }

    public Date getFirstConfirmDate() {
        return this.firstConfirmDate;
    }

    @Transient
    public String getFirstConfirmDateTrimTime() {
        return ModelUtils.getDateAsFormatString(this.getFirstConfirmDate(), "yyyy-MM-dd'('EEE')'HH:mm");
    }

    public void setConfirmDate(Date confirmDate) {
        this.confirmDate = confirmDate;
    }

    public Date getConfirmDate() {
        return this.confirmDate;
    }

    @Transient
    public String getConfirmDateTrimTime() {
        return ModelUtils.getDateAsFormatString(this.getConfirmDate(), "yyyy-MM-dd'('EEE')'HH:mm");
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartmentDesc(String departmentDesc) {
        this.departmentDesc = departmentDesc;
    }

    public String getDepartmentDesc() {
        return this.departmentDesc;
    }

    public String getDepartmentName() {
        String[] tokens = this.tokenizeDept(this.departmentDesc);
        return tokens[0];
    }

    public String getDepartmentCode() {
        String[] tokens = this.tokenizeDept(this.departmentDesc);
        if (tokens[1] != null) {
            return tokens[1];
        }
        return this.department;
    }

    public String getAssignedDoctorName() {
        String[] tokens = this.tokenizeDept(this.departmentDesc);
        return tokens[2];
    }

    public String getAssignedDoctorId() {
        String[] tokens = this.tokenizeDept(this.departmentDesc);
        return tokens[3];
    }

    public String getJMARICode() {
        String[] tokens = this.tokenizeDept(this.departmentDesc);
        return tokens[4];
    }

    private String[] tokenizeDept(String dept) {
        CombinedStringParser line = new CombinedStringParser(',', dept);
        String[] result = new String[line.size()];
        for (int index = 0; index < line.size(); ++index) {
            result[index] = line.get(index);
        }
        return result;
    }

    public void setDepartmentCodeSys(String departmentCodeSys) {
        this.departmentCodeSys = departmentCodeSys;
    }

    public String getDepartmentCodeSys() {
        return this.departmentCodeSys;
    }

    public void setHealthInsurance(String healthInsurance) {
        this.healthInsurance = healthInsurance;
    }

    public String getHealthInsurance() {
        return this.healthInsurance;
    }

    public void setHealthInsuranceDesc(String healthInsuranceDesc) {
        this.healthInsuranceDesc = healthInsuranceDesc;
    }

    public String getHealthInsuranceDesc() {
        return this.healthInsuranceDesc;
    }

    public void setHealthInsuranceCodeSys(String healthInsuranceCodeSys) {
        this.healthInsuranceCodeSys = healthInsuranceCodeSys;
    }

    public String getHealthInsuranceCodeSys() {
        return this.healthInsuranceCodeSys;
    }

    public void setHealthInsuranceGUID(String healthInsuranceGUID) {
        this.healthInsuranceGUID = healthInsuranceGUID;
    }

    public String getHealthInsuranceGUID() {
        return this.healthInsuranceGUID;
    }

    public void setHasMark(boolean hasMark) {
        this.hasMark = hasMark;
    }

    public boolean isHasMark() {
        return this.hasMark;
    }

    public void setHasImage(boolean hasImage) {
        this.hasImage = hasImage;
    }

    public boolean isHasImage() {
        return this.hasImage;
    }

    public Boolean isHasImageBoolean() {
        return new Boolean(this.hasImage);
    }

    public void setHasRp(boolean hasRp) {
        this.hasRp = hasRp;
    }

    public boolean isHasRp() {
        return this.hasRp;
    }

    public Boolean isHasRpBoolean() {
        return new Boolean(this.hasRp);
    }

    public void setHasTreatment(boolean hasTreatment) {
        this.hasTreatment = hasTreatment;
    }

    public boolean isHasTreatment() {
        return this.hasTreatment;
    }

    public Boolean isHasTreatmentBoolean() {
        return new Boolean(this.hasTreatment);
    }

    public void setHasLaboTest(boolean hasLaboTest) {
        this.hasLaboTest = hasLaboTest;
    }

    public boolean isHasLaboTest() {
        return this.hasLaboTest;
    }

    public Boolean isHasLaboTestBoolean() {
        return new Boolean(this.hasLaboTest);
    }

    public void setVersionNumber(String version) {
        this.versionNumber = version;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNotes(String versionNotes) {
        this.versionNotes = versionNotes;
    }

    public String getVersionNotes() {
        return this.versionNotes;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentIdRelation(String parentIdRelation) {
        this.parentIdRelation = parentIdRelation;
    }

    public String getParentIdRelation() {
        return this.parentIdRelation;
    }

    public void setParentIdDesc(String relationDesc) {
        this.parentIdDesc = relationDesc;
    }

    public String getParentIdDesc() {
        return this.parentIdDesc;
    }

    public void setParentIdCodeSys(String relationCodeSys) {
        this.parentIdCodeSys = relationCodeSys;
    }

    public String getParentIdCodeSys() {
        return this.parentIdCodeSys;
    }

    public Collection<AccessRightModel> getAccessRights() {
        return this.accessRights;
    }

    public void setAccessRights(Collection<AccessRightModel> accessRights) {
        this.accessRights = accessRights;
    }

    public void addAccessRight(AccessRightModel accessRight) {
        if (this.accessRights == null) {
            this.accessRights = new ArrayList<AccessRightModel>(3);
        }
        this.accessRights.add(accessRight);
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    @Transient
    public String getStatusByName() {
        if (this.status != null) {
            if (this.status.equals("F")) {
                return "\u9001\u4fe1\u6e08\u307f";
            }
            if (this.status.equals("T")) {
                return "\u4eee\u4fdd\u5b58";
            }
            if (this.status.equals("M")) {
                return "\u4fdd\u5b58";
            }
        }
        return "";
    }

    public int hashCode() {
        return this.docId.hashCode() + 11;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            return this.getDocId().equals(((DocInfoModel)other).getDocId());
        }
        return false;
    }

    public int compareTo(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            Date val2;
            Date val1 = this.getFirstConfirmDate();
            int result = val1.compareTo(val2 = ((DocInfoModel)other).getFirstConfirmDate());
            if (result == 0) {
                val1 = this.getConfirmDate();
                val2 = ((DocInfoModel)other).getConfirmDate();
                result = val1.compareTo(val2);
            }
            return result;
        }
        return -1;
    }

    private String nullToString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public void serialize(Writer result) throws IOException {
        result.append("<DocInfoModel docId='" + this.nullToString(this.docId) + "' docType='" + this.nullToString(this.docType) + "' title='" + this.nullToString(this.title) + "' purpose='" + this.nullToString(this.purpose) + "' />" + System.getProperty("line.separator"));
    }
}

