/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import open.dolphin.log.LogWriter;

public class ImageHelper {
    public static BufferedImage getFirstScaledInstance(BufferedImage inImage, int maxDim) {
        if (inImage.getWidth() <= maxDim && inImage.getHeight() <= maxDim) {
            return inImage;
        }
        BufferedImage outImage = null;
        try {
            double scale = (double)maxDim / (double)inImage.getHeight(null);
            if (inImage.getWidth(null) > inImage.getHeight(null)) {
                scale = (double)maxDim / (double)inImage.getWidth(null);
            }
            int scaledW = (int)(scale * (double)inImage.getWidth(null));
            int scaledH = (int)(scale * (double)inImage.getHeight(null));
            outImage = new BufferedImage(scaledW, scaledH, 4);
            AffineTransform tx = new AffineTransform();
            if (scale < 1.0) {
                tx.scale(scale, scale);
            }
            Graphics2D g2d = outImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawImage(inImage, tx, null);
            g2d.dispose();
        }
        catch (Exception e) {
            LogWriter.error(ImageHelper.class, e);
        }
        return outImage;
    }
}

