/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.component;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import open.dolphin.component.DnDTabbedPane;

public class GhostGlassPane
extends JPanel {
    private BufferedImage draggingGhost = null;
    private DnDTabbedPane tabbedPane;

    public GhostGlassPane(DnDTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        this.setOpaque(false);
    }

    public void setImage(BufferedImage draggingGhost) {
        this.draggingGhost = draggingGhost;
    }

    public void setTargetTabbedPane(DnDTabbedPane tab) {
        this.tabbedPane = tab;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        DnDTabbedPane.DropLocation dl = this.tabbedPane.getDropLocation();
        if (this.draggingGhost != null && dl != null) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            if (dl.isDropable()) {
                this.tabbedPane.paintDropLine(g2);
            }
            Point p = SwingUtilities.convertPoint(this.tabbedPane, dl.getDropPoint(), this);
            double xx = p.getX() - (double)this.draggingGhost.getWidth(this) / 2.0;
            double yy = p.getY() - (double)this.draggingGhost.getHeight(this) / 2.0;
            g2.drawImage((Image)this.draggingGhost, (int)xx, (int)yy, this);
        }
    }
}

