/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.Position;
import open.dolphin.client.AbstractComponentHolder;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.IChart;
import open.dolphin.client.IComponentHolder;
import open.dolphin.client.KartePane;
import open.dolphin.client.editor.stamp.StampEditorDialog;
import open.dolphin.client.editor.stamp.StampRenderingHints;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.BundleMed;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.DebugDump;
import open.dolphin.utils.StringTool;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public final class StampHolder
extends AbstractComponentHolder
implements IComponentHolder {
    private static final Color FOREGROUND = new Color(20, 20, 140);
    private static final Color BACKGROUND = Color.white;
    private static final Color SELECTED_BORDER = new Color(255, 0, 153);
    private ModuleModel stamp;
    private StampRenderingHints hints;
    private KartePane kartePane;
    private Position start;
    private Position end;
    private boolean selected;
    private Color foreGround = FOREGROUND;
    private Color background = BACKGROUND;
    private Color selectedBorder = SELECTED_BORDER;

    public StampHolder(KartePane kartePane, ModuleModel stamp) {
        this.kartePane = kartePane;
        this.setHints(new StampRenderingHints());
        this.setForeground(this.foreGround);
        this.setBackground(this.background);
        this.setBorder(BorderFactory.createLineBorder(kartePane.getTextPane().getBackground()));
        this.setStamp(stamp);
    }

    @Override
    public void enter(ActionMap map) {
        map.get("copy").setEnabled(false);
        map.get("cut").setEnabled(this.isEditable());
        map.get("paste").setEnabled(false);
        map.get("letterPasteFromKarte").setEnabled(this.canPasteToLetter());
        map.get("quickEdit").setEnabled(this.isFormulaStamp());
        this.setSelected(true);
    }

    private JPanel createQuickEditPane(ClaimItem[] targets, List<JTextField> textFields, ClaimBundle model) {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        GroupLayout.ParallelGroup nameLabelGroup = layout.createParallelGroup();
        GroupLayout.ParallelGroup textFieldGroup = layout.createParallelGroup();
        GroupLayout.ParallelGroup unitLabelGroup = layout.createParallelGroup();
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        for (ClaimItem target : targets) {
            if (StringTool.isEmptyString(target.getNumber())) continue;
            GroupLayout.ParallelGroup itemGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            JLabel nameLabel = new JLabel(target.getName());
            nameLabelGroup.addComponent(nameLabel);
            itemGroup.addComponent(nameLabel);
            JTextField itemField = new JTextField();
            itemField.setColumns(5);
            itemField.setText(target.getNumber());
            itemField.setHorizontalAlignment(4);
            this.addListenerToCountField(itemField);
            textFields.add(itemField);
            textFieldGroup.addComponent(itemField);
            itemGroup.addComponent(itemField);
            JLabel unitLabel = new JLabel(target.getUnit());
            unitLabelGroup.addComponent(unitLabel);
            itemGroup.addComponent(unitLabel);
            vGroup.addGroup(itemGroup);
        }
        vGroup.addGroup(layout.createParallelGroup().addGap(15).addGap(15).addGap(15));
        GroupLayout.ParallelGroup numberGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        JLabel nameLabel = null;
        try {
            nameLabel = new JLabel(((BundleMed)model).getDisplayString());
        }
        catch (ClassCastException ex) {
            nameLabel = new JLabel("\u56de\u6570");
        }
        nameLabelGroup.addComponent(nameLabel);
        numberGroup.addComponent(nameLabel);
        JTextField countField = new JTextField();
        countField.setColumns(5);
        countField.setText(model.getBundleNumber());
        countField.setHorizontalAlignment(4);
        this.addListenerToCountField(countField);
        textFields.add(countField);
        textFieldGroup.addComponent(countField);
        numberGroup.addComponent(countField);
        JLabel unitLabel = null;
        try {
            unitLabel = new JLabel(((BundleMed)model).getUnit());
        }
        catch (ClassCastException ex) {
            unitLabel = new JLabel("\u56de");
        }
        unitLabelGroup.addComponent(unitLabel);
        numberGroup.addComponent(unitLabel);
        vGroup.addGroup(numberGroup);
        layout.setVerticalGroup(vGroup);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        hGroup.addGroup(nameLabelGroup);
        hGroup.addGroup(textFieldGroup);
        hGroup.addGroup(unitLabelGroup);
        layout.setHorizontalGroup(hGroup);
        return panel;
    }

    private boolean isEditable() {
        return this.kartePane.getTextPane().isEditable();
    }

    private boolean canPasteToLetter() {
        IChart chart = this.kartePane.getMediator().getChart();
        return chart instanceof ChartWindow && ((ChartWindow)chart).existLetterPane() && !this.isEditable();
    }

    private boolean isFormulaStamp() {
        String entityName = this.getStamp().getModuleInfo().getEntity();
        if (entityName.equals("medOrder")) {
            return true;
        }
        if (entityName.equals("treatmentOrder")) {
            return true;
        }
        if (entityName.equals("injectionOrder")) {
            return true;
        }
        if (entityName.equals("radiologyOrder")) {
            return true;
        }
        if (entityName.equals("physiologyOrder")) {
            return true;
        }
        if (entityName.equals("surgeryOrder")) {
            return true;
        }
        BundleDolphin stampModel = (BundleDolphin)this.getStamp().getModel();
        return stampModel.getClassCode().equals("960");
    }

    @Override
    public void exit(ActionMap map) {
        this.setSelected(false);
    }

    @Override
    public void showPopup(MouseEvent e) {
        if (this.isSelected() && e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            ChartMediator mediator = this.kartePane.getMediator();
            if (this.isEditable() && this.isFormulaStamp()) {
                popup.add(mediator.getAction("quickEdit"));
            }
            if (this.isEditable()) {
                popup.add(mediator.getAction("copy"));
                popup.add(mediator.getAction("cut"));
                popup.add(mediator.getAction("paste"));
            }
            if (!this.isEditable()) {
                popup.add(mediator.getAction("letterPasteFromKarte"));
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public KartePane getKartePane() {
        return this.kartePane;
    }

    @Override
    public int getContentType() {
        return 0;
    }

    public ModuleModel getStamp() {
        return this.stamp;
    }

    public void setStamp(ModuleModel stamp) {
        this.stamp = stamp;
        this.renderStamp();
    }

    public StampRenderingHints getHints() {
        return this.hints;
    }

    public void setHints(StampRenderingHints hints) {
        this.hints = hints;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
            if (this.selected) {
                this.setBorder(BorderFactory.createLineBorder(this.selectedBorder));
            } else {
                this.setBorder(BorderFactory.createLineBorder(this.kartePane.getTextPane().getBackground()));
            }
        }
    }

    @Override
    public void edit() {
        if (!this.kartePane.getTextPane().isEditable()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        String category = this.stamp.getModuleInfo().getEntity();
        StampEditorDialog stampEditor = new StampEditorDialog(category, this.stamp);
        stampEditor.addPropertyChangeListener("value", this);
        stampEditor.start();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        ModuleModel newStamp = (ModuleModel)e.getNewValue();
        if (newStamp != null) {
            this.importStamp(newStamp);
        }
    }

    public void importStamp(ModuleModel newStamp) {
        this.setStamp(newStamp);
        this.kartePane.setDirty(true);
        this.kartePane.getTextPane().validate();
        this.kartePane.getTextPane().repaint();
    }

    @Override
    public void setEntry(Position start, Position end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public int getStartPos() {
        return this.start.getOffset();
    }

    @Override
    public int getEndPos() {
        return this.end.getOffset();
    }

    private boolean noResultFromQuickEditDialog(JOptionPane pane) {
        return pane.getValue() == null || (Integer)pane.getValue() == 2;
    }

    private void renderStamp() {
        try {
            IInfoModel model = this.getStamp().getModel();
            VelocityContext context = GlobalConstants.getVelocityContext();
            context.put("model", (Object)model);
            context.put("hints", (Object)this.getHints());
            context.put("stampName", (Object)this.getStamp().getModuleInfo().getStampName());
            context.put("bundleNumber", (Object)((ClaimBundle)model).getBundleNumber());
            context.put("stampStatus", (Object)this.getStamp().getModuleInfo().getStampStatus());
            String templateFile = this.getStamp().getModel().getClass().getName() + ".vm";
            if (this.getStamp().getModuleInfo().getEntity() != null && this.getStamp().getModuleInfo().getEntity().equals("testOrder") && GlobalVariables.getPreferences().getBoolean("laboFold", true)) {
                templateFile = "labo.vm";
            }
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            InputStream instream = GlobalConstants.getTemplateAsStream(templateFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream, "SHIFT_JIS"));
            Velocity.evaluate((Context)context, (Writer)bw, (String)"stmpHolder", (Reader)reader);
            bw.flush();
            bw.close();
            reader.close();
            String stampText = sw.toString();
            if (GlobalSettings.isStampDump()) {
                DebugDump.dumpToFile("stamp.log", stampText);
            }
            this.setText(StringTool.zenkakuNumToHankaku(stampText));
            this.setMaximumSize(this.getPreferredSize());
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    private void addListenerToCountField(JTextField field) {
        field.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JTextField countField = (JTextField)e.getSource();
                String oldString = countField.getText();
                if (oldString.contains(".")) {
                    countField.setText(this.getNewAsDecimal(oldString, -e.getWheelRotation()));
                } else {
                    countField.setText(this.getNewAsInteger(oldString, -e.getWheelRotation()));
                }
            }

            private String getNewAsDecimal(String oldString, int rotation) {
                double oldValue = 0.0;
                try {
                    oldValue = Double.parseDouble(oldString);
                }
                catch (NumberFormatException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                Double newValue = oldValue + (double)rotation * 0.1;
                if (newValue < 0.1) {
                    newValue = 0.1;
                }
                DecimalFormat formatter = new DecimalFormat("0");
                formatter.setMaximumFractionDigits(1);
                formatter.setMinimumFractionDigits(1);
                String result = formatter.format(newValue).toString();
                return result;
            }

            private String getNewAsInteger(String oldString, int rotation) {
                int oldValue = 0;
                try {
                    oldValue = Integer.parseInt(oldString);
                }
                catch (NumberFormatException ex) {
                    LogWriter.error(this.getClass(), ex);
                }
                Integer newValue = oldValue + rotation;
                if (newValue < 1) {
                    newValue = 1;
                }
                String result = newValue.toString();
                return result;
            }
        });
    }

    public final List<JTextField> showQuickEditDialog(JFrame parentFrame) {
        IInfoModel infoModel = this.getStamp().getModel();
        if (!(infoModel instanceof ClaimBundle)) {
            return null;
        }
        ClaimBundle model = (ClaimBundle)infoModel;
        ClaimItem[] targets = model.getClaimItem();
        ArrayList<JTextField> textFields = new ArrayList<JTextField>(targets.length);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.createQuickEditPane(targets, textFields, model));
        JOptionPane pane = new JOptionPane(mainPanel, 1, 2);
        JDialog dialog = pane.createDialog(parentFrame, "\u30af\u30a4\u30c3\u30af\u7de8\u96c6");
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        if (this.noResultFromQuickEditDialog(pane)) {
            return null;
        }
        return textFields;
    }
}

