/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.Association;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.Modality;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.ReceivedObject;
import fr.apteryx.imageio.dicom.ReceivedObjectListener;
import fr.apteryx.imageio.dicom.SCP;
import fr.apteryx.imageio.dicom.SecureTransport;
import fr.apteryx.imageio.dicom.Server;
import fr.apteryx.imageio.dicom.StorageSCPListener;
import fr.apteryx.imageio.dicom.TransferSyntax;
import java.io.IOException;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.Set;

public class StorageSCP
extends SCP {
    private static final int[] types = new int[]{1};
    private static final Set SUPPORTED_SYNTAXES = Modality.sop2mod.keySet();
    private final StorageSCPListener sListener;
    private final ReceivedObjectListener roListener;
    private final LinkedList objects;
    private RawValues rv = RawValues.NONE;
    private TransferSyntax[] preferredTS;

    public StorageSCP() throws DicomException {
        this(104, null, (SecureTransport)null);
    }

    public StorageSCP(SecureTransport secureTransport) throws DicomException {
        this(2762, null, secureTransport);
    }

    public StorageSCP(int n) throws DicomException {
        this(n, null, (SecureTransport)null);
    }

    public StorageSCP(int n, SecureTransport secureTransport) throws DicomException {
        this(n, null, secureTransport);
    }

    public StorageSCP(int n, InetAddress inetAddress, SecureTransport secureTransport) throws DicomException {
        super(Server.getInstance(n, inetAddress, secureTransport));
        this.sListener = null;
        this.roListener = null;
        this.objects = new LinkedList();
        this.rv = this.server.rv;
    }

    public StorageSCP(StorageSCPListener storageSCPListener) throws DicomException {
        this(104, null, null, storageSCPListener);
    }

    public StorageSCP(ReceivedObjectListener receivedObjectListener) throws DicomException {
        this(104, null, null, receivedObjectListener);
    }

    public StorageSCP(int n, StorageSCPListener storageSCPListener) throws DicomException {
        this(n, null, null, storageSCPListener);
    }

    public StorageSCP(int n, ReceivedObjectListener receivedObjectListener) throws DicomException {
        this(n, null, null, receivedObjectListener);
    }

    public StorageSCP(int n, SecureTransport secureTransport, StorageSCPListener storageSCPListener) throws DicomException {
        this(n, null, secureTransport, storageSCPListener);
    }

    public StorageSCP(int n, SecureTransport secureTransport, ReceivedObjectListener receivedObjectListener) throws DicomException {
        this(n, null, secureTransport, receivedObjectListener);
    }

    public StorageSCP(int n, InetAddress inetAddress, SecureTransport secureTransport, StorageSCPListener storageSCPListener) throws DicomException {
        super(Server.getInstance(n, inetAddress, secureTransport));
        this.sListener = storageSCPListener;
        this.roListener = null;
        this.objects = storageSCPListener == null ? new LinkedList() : null;
        this.rv = this.server.rv;
    }

    public StorageSCP(int n, InetAddress inetAddress, SecureTransport secureTransport, ReceivedObjectListener receivedObjectListener) throws DicomException {
        super(Server.getInstance(n, inetAddress, secureTransport));
        this.roListener = receivedObjectListener;
        this.sListener = null;
        this.objects = receivedObjectListener == null ? new LinkedList() : null;
        this.rv = this.server.rv;
    }

    public void start() throws IOException {
        this.server.registerSCP(this);
    }

    public void stop() throws IOException {
        this.server.deregisterSCP(this);
    }

    public void setRawValues(RawValues rawValues) {
        this.rv = rawValues;
    }

    public void setRawMode(boolean bl) {
        this.rv = bl ? RawValues.ALL : RawValues.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean messageReceived(Association association, ReceivedMessage receivedMessage) throws IOException {
        DataSet dataSet = receivedMessage.command;
        String string = dataSet.findString(2);
        String string2 = dataSet.findString(4096);
        ReceivedObject receivedObject = new ReceivedObject(receivedMessage, string, string2, this.rv, association.calledAE, association.callingAE, association.addr, association.port);
        DataSet dataSet2 = new DataSet();
        dataSet2.add(2304, receivedObject.warnings.hasSome() ? 45062 : 0);
        if (this.sListener != null) {
            this.sListener.objectReceived(receivedObject);
        } else if (this.roListener != null) {
            if (!this.roListener.objectReceived(receivedObject, dataSet2)) {
                association.abort();
                return true;
            }
        } else {
            LinkedList linkedList = this.objects;
            synchronized (linkedList) {
                this.objects.addLast(receivedObject);
                this.objects.notifyAll();
            }
        }
        dataSet2.add(2, string);
        dataSet2.add(256, 32769);
        dataSet2.add(288, dataSet.findInt(272));
        dataSet2.add(2048, 257);
        dataSet2.add(4096, string2);
        dataSet2.add(0, dataSet2.getLength());
        association.sendMessage(string, dataSet2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceivedObject receiveObject() throws InterruptedException {
        LinkedList linkedList = this.objects;
        synchronized (linkedList) {
            while (this.objects.isEmpty()) {
                this.objects.wait();
            }
            return (ReceivedObject)this.objects.removeFirst();
        }
    }

    int[] getServicedMessageTypes() {
        return types;
    }

    boolean supportsSyntaxAsSCP(String string) {
        return SUPPORTED_SYNTAXES.contains(string);
    }

    boolean supportsSyntaxAsSCU(String string) {
        return false;
    }

    TransferSyntax[] getPreferredTSAsSCP(String string) {
        return this.preferredTS == null ? super.getPreferredTSAsSCP(string) : this.preferredTS;
    }

    public void setPreferredTransferSyntaxes(String[] stringArray) throws DicomException {
        if (stringArray == null) {
            this.preferredTS = null;
        } else {
            this.preferredTS = new TransferSyntax[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.preferredTS[i] = TransferSyntax.getInstance(stringArray[i]);
            }
        }
    }
}

