/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomObject;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.Warnings;
import java.net.InetAddress;

public final class ReceivedObject {
    final DicomObject obj;
    final Warnings warnings = new Warnings();
    final String localAE;
    final String remoteAE;
    final InetAddress remoteAddr;
    final int remotePort;

    ReceivedObject(ReceivedMessage receivedMessage, String string, String string2, RawValues rawValues, String string3, String string4, InetAddress inetAddress, int n) throws DicomException {
        DataSet dataSet = receivedMessage.readDataSet(rawValues, false, this.warnings);
        this.obj = new DicomObject(dataSet, string, string2, rawValues != RawValues.NONE ? receivedMessage.transferSyntax : null);
        this.localAE = string3;
        this.remoteAE = string4;
        this.remoteAddr = inetAddress;
        this.remotePort = n;
    }

    public String toString() {
        return "Object received from application entity " + this.remoteAE + " (" + this.remoteAddr + "):\n" + this.obj.toString();
    }

    public String getLocalAE() {
        return this.localAE;
    }

    public String getRemoteAE() {
        return this.remoteAE;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }
}

