package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import open.dolphin.queries.DolphinQuery;

/**
 *
 * 使用者 MEMO:マッピング
 * UserModel
 *
 * 施設情報(FacilityModel)
 * 資格情報(LicenseModel)
 * 科情報(DepartmentModel)
 * 役割情報(Set<RoleModel>)
 * ユーザID
 * パスワード
 * 名前
 * 
 *  generated by hbm2java
 */
public class UserModel extends InfoModel {

    private long id;//ID MEMO:Refrection
    private FacilityModel facility;//施設モデル MEMO:Refrection
    private LicenseModel licenseModel;//資格モデル
    private DepartmentModel departmentModel;//科モデル
    private Set<RoleModel> roles;//権限 MEMO:Refrection
    private String userId;//ユーザID MEMO:Refrection
    private String password;//パスワード MEMO:Refrection
    private String sirName;//苗字 MEMO:Refrection
    private String givenName;//名前 MEMO:Refrection
    private String commonName;//名前 MEMO:Refrection
    private String memberType;//タイプ MEMO:Refrection
    private String memo;//メモ MEMO:Refrection
    private Date registeredDate;//登録日 MEMO:Refrection
    private String email;//メールアドレス MEMO:Refrection

    /**
     *　コンストラクタ
     */
    public UserModel() {
    }

    /**
     * 検索 MEMO:何もしない
     * @param query
     * @return false
     */
    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    /**
     * IDのGetter
     * MEMO:Refrection
     * @return
     */
    public long getId() {
        return id;
    }

    /**
     * IDのSetter
     * MEMO:Refrection
     * @param id
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * 初期化
     * @param facilityId 施設ID
     * @param userId ユーザID
     * @param SirName 苗字
     * @param GivenName 名前
     * @param password パスワード
     */
    public void initialize(String facilityId, String userId, String SirName, String GivenName, String password) {
        StringBuilder sb = new StringBuilder(facilityId);
        sb.append(IInfoModel.COMPOSITE_KEY_MAKER);
        sb.append(userId.trim());
        setUserId(sb.toString());
        setPassword(password);
        setSirName(SirName.trim());
        setGivenName(GivenName.trim());
        setCommonName(getSirName() + " " + getGivenName());
    }

    /**
     * userIdのSetter   userId  FacilityId + ":" + uid
     * MEMO:Reflection
     * @param userId ユーザID
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * userIdのGetter   userId  FacilityId + ":" + uid
     * MEMO:Refrection
     * @return userId ユーザID
     */
    public String getUserId() {
        return userId;
    }

    /**
     * UserIDに含まれるuidを返す
     * @return UID
     */
    public String idAsLocal() {
        int index = userId.indexOf(COMPOSITE_KEY_MAKER);
        return userId.substring(index + 1);
    }

    /**
     * パスワードのSetter
     * MEMO:Refrection
     * @param password パスワード
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * パスワードのGetter
     * MEMO:Refrection
     * @return パスワード
     */
    public String getPassword() {
        return password;
    }

    /**
     * 苗字のSetter
     * MEMO:Refrection
     * @param sirName 苗字
     */
    public void setSirName(String sirName) {
        this.sirName = sirName;
    }

    /**
     * 苗字のGetter
     * MEMO:Refrection
     * @return 苗字
     */
    public String getSirName() {
        return sirName;
    }

    /**
     * 名前のSetter
     * MEMO:Refrection
     * @param givenName 名前
     */
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /**
     * 名前のGetter
     * MEMO:Refrection
     * @return 名前
     */
    public String getGivenName() {
        return givenName;
    }

    /**
     * 名前のSetter
     * MEMO:Refrection
     * @param commonName 名前
     */
    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    /**
     * 名前のGetter
     * MEMO:Refrection
     * @return 名前
     */
    public String getCommonName() {
        return commonName;
    }

    /**
     * 資格情報のSetter
     * @param licenseValue 資格情報
     */
    public void setLicenseModel(LicenseModel licenseValue) {
        this.licenseModel = licenseValue;
    }

    /**
     * 資格情報のGetter
     * @return 資格情報
     */
    public LicenseModel getLicenseModel() {
        return licenseModel;
    }

    /**
     * 施設情報のSetter
     * MEMO:Refrection
     * @param facility 施設情報
     */
    public void setFacility(FacilityModel facility) {
        this.facility = facility;
    }

    /**
     * 施設情報のGetter
     * MEMO:Refrection
     * @return 施設情報
     */
    public FacilityModel getFacility() {
        return facility;
    }

    /**
     * 科情報のSetter
     * @param departmentValue 科情報
     */
    public void setDepartmentModel(DepartmentModel departmentValue) {
        this.departmentModel = departmentValue;
    }

    /**
     * 科情報のGetter
     * @return 科情報
     */
    public DepartmentModel getDepartmentModel() {
        return departmentModel;
    }

    /**
     * 権限集合のSetter
     * MEMO:Refrection
     * @param roles 権限集合
     */
    public void setRoles(Set<RoleModel> roles) {
        this.roles = roles;
    }

    /**
     * 権限集合のGetter
     * MEMO:Refrection
     * @return 権限集合
     */
    public Set<RoleModel> getRoles() {
        return roles;
    }

    /**
     * 権限追加
     * MEMO:Refrection
     * @param value 権限
     */
    public void addRole(RoleModel value) {

        if (roles == null) {
            roles = new LinkedHashSet<RoleModel>(1);
        }
        roles.add(value);
    }

    /**
     * UserLiteModelのGetter
     * 取り回し用のUserLiteModelを取り出す
     * @return UserLiteModel
     */
    public UserLiteModel getLiteModel() {

        UserLiteModel model = new UserLiteModel();
        model.setUserId(getUserId());
        model.setCommonName(getCommonName());
        LicenseModel lm = new LicenseModel();
        lm.setLicense(getLicenseModel().getLicense());
        lm.setLicenseDesc(getLicenseModel().getLicenseDesc());
        lm.setLicenseCodeSys(getLicenseModel().getLicenseCodeSys());
        model.setLicenseModel(lm);
        return model;
    }

    /**
     * メンバータイプのSetter
     * MEMO:Refrection
     * @param memberType メンバータイプ
     */
    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    /**
     * メンバータイプのGetter
     * MEMO:Refrection
     * @return メンバータイプ
     */
    public String getMemberType() {
        return memberType;
    }

    /**
     * メモのSetter
     * MEMO:Refrection
     * @param memo メモ
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * メモのGetter
     * MEMO:Refrection
     * @return メモ
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 登録日のSetter
     * MEMO:Refrection
     * @param registeredDate 登録日
     */
    public void setRegisteredDate(Date registeredDate) {
        this.registeredDate = registeredDate;
    }

    /**
     * 登録日のGetter
     * MEMO:Refrection
     * @return 登録日
     */
    public Date getRegisteredDate() {
        return registeredDate;
    }

    /**
     * メールアドレスのSetter
     * MEMO:Refrection
     * @param email メールアドレス
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * メールアドレスのGetter
     * MEMO:Refrection
     * @return メールアドレス
     */
    public String getEmail() {
        return email;
    }

    /**
     * ハッシュコード
     * @return ハッシュコード
     */
    @Override
    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + (int) (id ^ (id >>> 32));
        return result;
    }

    /**
     * 比較
     * @param obj オブジェクト
     * @return 同一なら真
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final UserModel other = (UserModel) obj;
        if (getId() != other.getId()) {
            return false;
        }
        return true;
    }
}
