/*
 * RunnerView.java
 */

package runner;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;

/**
 * The application's main frame.
 */
public class RunnerView extends FrameView {
	SetPath run;

    public RunnerView(SingleFrameApplication app) {
        super(app);

        initComponents();
		// utils
		try {
			run = new SetPath();
		}catch (Exception ex){
			ex.printStackTrace();
		}
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        dolphinImg = new javax.swing.JLabel();
        buildBtn = new javax.swing.JButton();
        serverBtn = new javax.swing.JButton();
        cancelBtn = new javax.swing.JButton();

        mainPanel.setMaximumSize(new java.awt.Dimension(359, 320));
        mainPanel.setMinimumSize(new java.awt.Dimension(359, 300));
        mainPanel.setName("mainPanel"); // NOI18N
        mainPanel.setPreferredSize(new java.awt.Dimension(359, 310));

        dolphinImg.setIcon(new javax.swing.ImageIcon(getClass().getResource("/runner/resources/splash.jpg"))); // NOI18N
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(runner.RunnerApp.class).getContext().getResourceMap(RunnerView.class);
        dolphinImg.setText(resourceMap.getString("dolphinImg.text")); // NOI18N
        dolphinImg.setName("dolphinImg"); // NOI18N

        buildBtn.setText(resourceMap.getString("buildBtn.text")); // NOI18N
        buildBtn.setName("buildBtn"); // NOI18N
        buildBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buildBtnMouseClicked(evt);
            }
        });

        serverBtn.setText(resourceMap.getString("serverBtn.text")); // NOI18N
        serverBtn.setName("serverBtn"); // NOI18N
        serverBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                serverBtnMouseReleased(evt);
            }
        });

        cancelBtn.setText(resourceMap.getString("cancelBtn.text")); // NOI18N
        cancelBtn.setName("cancelBtn"); // NOI18N
        cancelBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cancelBtnMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(dolphinImg, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(mainPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(buildBtn)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(serverBtn)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 149, Short.MAX_VALUE)
                        .addComponent(cancelBtn)))
                .addContainerGap())
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addComponent(dolphinImg)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(buildBtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(serverBtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(cancelBtn))
                .addGap(42, 42, 42))
        );

        setComponent(mainPanel);
    }// </editor-fold>//GEN-END:initComponents

	private void buildBtnMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_buildBtnMouseClicked
		//		buildBtn.setBackground(new Color(212,208,200));
		try {
			run.runBuild();
		} catch (IOException ex) {
			Logger.getLogger(RunnerView.class.getName()).log(Level.SEVERE, null, ex);
		} catch (InterruptedException ex) {
			Logger.getLogger(RunnerView.class.getName()).log(Level.SEVERE, null, ex);
		}
//		buildBtn.setBackground(new Color(212,208,200));
	}//GEN-LAST:event_buildBtnMouseClicked

	private void serverBtnMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_serverBtnMouseReleased
		run.run();
	}//GEN-LAST:event_serverBtnMouseReleased

	private void cancelBtnMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cancelBtnMouseClicked
		try {
			run.exitServer();
		} catch (IOException ex) {
			Logger.getLogger(RunnerView.class.getName()).log(Level.SEVERE, null, ex);
		} catch (InterruptedException ex) {
			Logger.getLogger(RunnerView.class.getName()).log(Level.SEVERE, null, ex);
		}
	}//GEN-LAST:event_cancelBtnMouseClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buildBtn;
    private javax.swing.JButton cancelBtn;
    private javax.swing.JLabel dolphinImg;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JButton serverBtn;
    // End of variables declaration//GEN-END:variables
	
	
}
