/*
 * OpenDolphinInitializerView.java
 */
package opendolphininitializer;

import java.io.File;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

/**
 * The application's main frame.
 */
public class OpenDolphinInitializerView extends FrameView {

    static String files[] = {"open.dolphin.client.ChartWindow.dividerLocation.xml",
        "open.dolphin.client.ChartWindow.layout.xml",
        "open.dolphin.client.ChartWindow.tabLocation.xml",
        "open.dolphin.client.karte.PatientInspector.layout.xml",
        "open.dolphin.client.karte.PatientInspector.tabLocation.xml"};

    public OpenDolphinInitializerView(SingleFrameApplication app) {
        super(app);
        initComponents();
        delete();
        System.exit(0);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();

        mainPanel.setName("mainPanel"); // NOI18N

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        setComponent(mainPanel);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel mainPanel;
    // End of variables declaration//GEN-END:variables

    private void delete() {
        ApplicationContext context = getContext();
        String settingPath = context.getLocalStorage().getDirectory().getAbsolutePath();
        for (String fileName : files) {
            String name = settingPath + File.separator + fileName;
            File file = new File(name);
            if (file.exists()) {
                file.delete();
            }
        }
    }
}
