/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.project;

import java.awt.Window;
import open.dolphin.client.AboutDialog;
import open.dolphin.client.SaveDialog;
import open.dolphin.client.SaveParams;
import open.dolphin.infomodel.ID;
import open.dolphin.project.AbstractProjectFactory;
import open.dolphin.project.GlobalConstants;

public class DolphinFactory
extends AbstractProjectFactory {
    protected String csgwPath;

    @Override
    public ID createMasterId(String pid, String facilityId) {
        return new ID(pid, "facility", facilityId);
    }

    @Override
    public String createCSGWPath(String uploaderAddress, String share, String facilityId) {
        if (this.csgwPath == null) {
            if (GlobalConstants.isWin()) {
                StringBuilder sb = new StringBuilder();
                sb.append("\\\\");
                sb.append(uploaderAddress);
                sb.append("\\");
                sb.append(share);
                sb.append("\\");
                sb.append(facilityId);
                this.csgwPath = sb.toString();
            } else if (GlobalConstants.isMac()) {
                StringBuilder sb = new StringBuilder();
                sb.append("smb://");
                sb.append(uploaderAddress);
                sb.append("/");
                sb.append(share);
                sb.append("/");
                sb.append(facilityId);
                this.csgwPath = sb.toString();
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("/");
                sb.append(uploaderAddress);
                sb.append("/");
                sb.append(share);
                sb.append("/");
                sb.append(facilityId);
                this.csgwPath = sb.toString();
            }
        }
        return this.csgwPath;
    }

    @Override
    public Object createAboutDialog() {
        return new AboutDialog();
    }

    @Override
    public Object createSaveDialog(Window parent, SaveParams params) {
        SaveDialog sd = new SaveDialog(parent, params);
        params.setAllowPatientRef(false);
        params.setAllowClinicRef(false);
        return sd;
    }
}

