/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestimporter;

import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.transaction.NotSupportedException;
import open.dolphin.client.labotestimporter.LaboTestInformation;
import open.dolphin.client.labotestimporter.LaboTestIsNotFinalReportException;
import open.dolphin.client.labotestimporter.MedisBuilder;
import open.dolphin.client.labotestimporter.MedisParser;
import open.dolphin.client.labotestimporter.MmlBuilder;
import open.dolphin.client.labotestimporter.MmlParser;
import open.dolphin.delegater.error.CantFindPatentExcepion;
import open.dolphin.delegater.remote.RemoteLaboDelegater;
import open.dolphin.infomodel.LaboImportSummary;
import open.dolphin.infomodel.LaboModuleValue;
import open.dolphin.infomodel.LaboSpecimenValue;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.log.LogWriter;
import org.jdom.JDOMException;

public class LaboModuleBuilder {
    private RemoteLaboDelegater laboDelegater;
    private static final String MML_EXTENSION = ".xml";
    private static final String MEDIS_EXTENSION = ".txt";

    public RemoteLaboDelegater getLaboDelegater() {
        return this.laboDelegater;
    }

    public void setLaboDelegater(RemoteLaboDelegater laboDelegater) {
        this.laboDelegater = laboDelegater;
    }

    public List<LaboImportSummary> build(List<File> files) {
        if (files == null || files.size() == 0) {
            return null;
        }
        if (this.laboDelegater == null) {
            return null;
        }
        ArrayList<LaboImportSummary> result = new ArrayList<LaboImportSummary>(files.size());
        for (File file : files) {
            ArrayList<LaboModuleValue> modules = new ArrayList<LaboModuleValue>(1);
            try {
                String name = file.getName();
                this.buildFromFile(modules, file);
            }
            catch (IOException ex) {
                String message = "\u4e0d\u6b63\u306a\u691c\u67fb\u30c7\u30fc\u30bf\u3067\u3042\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30fc\u30bf\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                JOptionPane.showMessageDialog(null, message, "\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", 2);
                continue;
            }
            catch (NotSupportedException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", 2);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", 2);
                if (ex.getCause() != null) {
                    LogWriter.error(LaboModuleBuilder.class, "\u539f\u56e0: " + ex.getCause());
                }
                if (ex.getMessage() == null) continue;
                LogWriter.error(LaboModuleBuilder.class, "\u5185\u5bb9: " + ex.getMessage());
                continue;
            }
            if (this.isDuplicatedLaboTest(modules)) {
                StringBuilder message = new StringBuilder();
                message.append("\u3059\u3067\u306b\u63a1\u53d6\u65e5\u3001\u5831\u544a\u65e5\u3001\u767b\u9332\u65e5\u304c\u540c\u3058\u691c\u67fb\u30c7\u30fc\u30bf\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059" + System.getProperty("line.separator"));
                message.append("\u91cd\u8907\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u304c\u672c\u5f53\u306b\u767b\u9332\u3057\u307e\u3059\u304b?" + System.getProperty("line.separator"));
                int selected = JOptionPane.showConfirmDialog(null, message.toString(), "\u78ba\u8a8d", 0);
                if (selected == 1) {
                    return result;
                }
            }
            this.finnalization(modules, result);
        }
        return result;
    }

    private void buildFromFile(List<LaboModuleValue> modules, File file) throws NotSupportedException, IOException {
        String fileName = file.getName();
        if (fileName.toLowerCase().endsWith(MML_EXTENSION)) {
            try {
                this.readMmlFile(modules, file);
            }
            catch (JDOMException ex) {
                throw new IOException(ex.getMessage(), ex.getCause());
            }
            return;
        }
        if (fileName.toLowerCase().endsWith(MEDIS_EXTENSION)) {
            this.readMedisFile(modules, file);
            return;
        }
        throw new NotSupportedException("\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u5f62\u5f0f\u3067\u3059");
    }

    private void readMedisFile(List<LaboModuleValue> modules, File file) throws IOException {
        MedisParser medisParser = new MedisParser();
        List<LaboTestInformation> result = medisParser.parse(new FileInputStream(file));
        MedisBuilder medisBuilder = new MedisBuilder(modules);
        medisBuilder.build(result);
    }

    private void readMmlFile(List<LaboModuleValue> modules, File file) throws IOException, JDOMException {
        MmlParser mmlParser = new MmlParser();
        List<LaboTestInformation> result = mmlParser.parse(new FileInputStream(file));
        MmlBuilder mmlBuilder = new MmlBuilder(modules);
        try {
            mmlBuilder.build(result);
        }
        catch (LaboTestIsNotFinalReportException ex) {
            String status = ex.getLaboTestInformation().getReportStatus();
            String message = "\u3053\u306e\u691c\u67fb\u30c7\u30fc\u30bf\u304c\u6700\u7d42\u5831\u544a\u3067\u306f\u3042\u308a\u307e\u305b\u3093\uff1a" + status + " (" + file.getName() + ")";
            JOptionPane.showMessageDialog(null, message, "\u53d6\u308a\u8fbc\u307f\u30a8\u30e9\u30fc", 2);
        }
    }

    private boolean isDuplicatedLaboTest(List<LaboModuleValue> modules) {
        boolean result = false;
        for (LaboModuleValue module : modules) {
            try {
                result = this.laboDelegater.isDuplicatedLaboTest(module);
            }
            catch (CantFindPatentExcepion ex) {
                JOptionPane.showMessageDialog(null, "\u60a3\u8005ID: " + module.getPatientId() + " \u306e\u60a3\u8005\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
        }
        return result;
    }

    private void finnalization(List<LaboModuleValue> modules, List<LaboImportSummary> result) {
        for (LaboModuleValue module : modules) {
            LaboImportSummary summary = new LaboImportSummary();
            summary.setPatientId(module.getPatientId());
            if (module.getSetName() == null) {
                for (LaboSpecimenValue specimen : module.getLaboSpecimens()) {
                    summary.setSetName(specimen.getSpecimenName());
                }
            } else {
                summary.setSetName(module.getSetName());
            }
            summary.setSampleTime(module.getSampleTime());
            summary.setReportTime(module.getReportTime());
            summary.setLaboratoryCenter(module.getLaboratoryCenter());
            summary.setReportStatus(module.getReportStatus());
            PatientModel reply = this.writeToDatabase(module, summary);
            if (!this.laboDelegater.isError()) {
                summary.setPatient(reply);
                summary.setResult("\u6210\u529f");
                result.add(summary);
                continue;
            }
            summary.setResult("\u30a8\u30e9\u30fc");
        }
    }

    private PatientModel writeToDatabase(LaboModuleValue module, LaboImportSummary summary) throws HeadlessException {
        PatientModel reply = null;
        try {
            reply = this.laboDelegater.putLaboModule(module);
        }
        catch (CantFindPatentExcepion ex) {
            JOptionPane.showMessageDialog(null, "\u60a3\u8005ID: " + module.getPatientId() + " \u306e\u60a3\u8005\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            summary.setResult("\u60a3\u8005\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return reply;
    }
}

