/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.List;
import open.dolphin.client.AbstractStampBox;
import open.dolphin.client.editor.stamp.DefaultStampTreeBuilder;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeDirector;
import open.dolphin.client.editor.stamp.StampTreePanel;
import open.dolphin.client.editor.stamp.StampTreePopupAdapter;
import open.dolphin.client.editor.stamp.StampTreeTransferHandler;
import open.dolphin.infomodel.IStampTreeModel;
import open.dolphin.log.LogWriter;

public class UserStampBox
extends AbstractStampBox {
    private static final String BOX_INFO = "\u500b\u4eba\u7528\u30b9\u30bf\u30f3\u30d7\u30dc\u30c3\u30af\u30b9";
    private int textIndex;
    private int pathIndex;
    private int orcaIndex;

    public UserStampBox(StampBoxFrame plugin, IStampTreeModel model) {
        super(plugin, model);
    }

    @Override
    protected void buildStampBox(String stampXml) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(stampXml));
            DefaultStampTreeBuilder builder = new DefaultStampTreeBuilder();
            StampTreeDirector director = new StampTreeDirector(builder);
            List<StampTree> userTrees = director.build(reader);
            reader.close();
            StampTreePopupAdapter popAdapter = new StampTreePopupAdapter();
            StampTreeTransferHandler transferHandler = new StampTreeTransferHandler();
            int index = 0;
            for (StampTree stampTree : userTrees) {
                stampTree.setUserTree(true);
                stampTree.setTransferHandler(transferHandler);
                stampTree.setStampBox(this.getContext());
                StampTreePanel treePanel = new StampTreePanel(stampTree);
                String treeName = stampTree.getTreeName();
                if (!(stampTree.getEntity() + "").equals("bacteriaOrder")) {
                    this.addTab(treeName, treePanel);
                }
                if (stampTree.getEntity().equals("text")) {
                    this.textIndex = index;
                    stampTree.addMouseListener(popAdapter);
                } else if (stampTree.getEntity().equals("path")) {
                    this.pathIndex = index;
                    stampTree.addMouseListener(popAdapter);
                } else if (stampTree.getEntity().equals("orcaSet")) {
                    this.orcaIndex = index;
                } else {
                    stampTree.addMouseListener(popAdapter);
                }
                ++index;
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), "", (Throwable)e);
        }
    }

    @Override
    protected void buildStampBox() {
        this.buildStampBox(this.getStampTreeModel().getTreeXml());
    }

    @Override
    public boolean isHasEditor(int index) {
        return index != this.textIndex && index != this.pathIndex && index != this.orcaIndex;
    }

    @Override
    public void setHasNoEditorEnabled(boolean enabled) {
        this.setEnabledAt(this.textIndex, enabled);
        this.setEnabledAt(this.pathIndex, enabled);
        this.setEnabledAt(this.orcaIndex, enabled);
    }

    @Override
    public String getInfo() {
        return BOX_INFO;
    }
}

