/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import open.dolphin.client.LocalStampTreeNodeTransferable;
import open.dolphin.client.TransferAction;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.project.GlobalConstants;
import open.dolphin.utils.CombinedStringParser;

public class StampTreePopupBuilder {
    private static final Icon icon = GlobalConstants.getImageIcon("foldr_16.gif");
    private Map<Object, JMenu> parents;
    private JPopupMenu popup;
    private DefaultMutableTreeNode rootNode;

    public void build(StampTree stampTree, JPopupMenu popup, JComponent cmp, TransferHandler handler) {
        if (this.parents == null) {
            this.parents = new HashMap<Object, JMenu>(10, 0.75f);
        } else {
            this.parents.clear();
        }
        this.popup = popup;
        this.rootNode = (DefaultMutableTreeNode)stampTree.getModel().getRoot();
        Enumeration<TreeNode> e = this.rootNode.preorderEnumeration();
        e.nextElement();
        while (e.hasMoreElements()) {
            this.parseChildren((StampTreeNode)e.nextElement(), cmp, handler);
        }
    }

    private void parseChildren(StampTreeNode node, JComponent comp, TransferHandler handler) {
        if (!node.isLeaf()) {
            JMenu subMenu = new JMenu(node.getUserObject().toString());
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            if (parentNode == this.rootNode) {
                this.popup.add(subMenu);
            } else {
                JMenu parent = this.parents.get(node.getParent());
                parent.add(subMenu);
            }
            this.parents.put(node, subMenu);
            JMenuItem item = new JMenuItem(node.getUserObject().toString());
            item.setIcon(icon);
            subMenu.add(item);
            if (comp != null && handler != null) {
                item.addActionListener(new TransferAction(comp, handler, new LocalStampTreeNodeTransferable(node)));
            } else {
                item.setEnabled(false);
            }
        } else {
            ModuleInfoBean info = (ModuleInfoBean)node.getUserObject();
            CombinedStringParser conbinedStampName = new CombinedStringParser(info.getStampName());
            JMenuItem item = new JMenuItem(conbinedStampName.toPlainString());
            if (comp != null && handler != null) {
                item.addActionListener(new TransferAction(comp, handler, new LocalStampTreeNodeTransferable(node)));
            } else {
                item.setEnabled(false);
            }
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            if (parentNode == this.rootNode) {
                this.popup.add(item);
            } else {
                JMenu parent = this.parents.get(node.getParent());
                parent.add(item);
            }
        }
    }
}

