/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.apache.log4j.Logger;
import org.dcm4che.srom.CodeContent;
import org.dcm4che.srom.CompositeContent;
import org.dcm4che.srom.ContainerContent;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.ImageContent;
import org.dcm4che.srom.NumContent;
import org.dcm4che.srom.PNameContent;
import org.dcm4che.srom.ReferencedContent;
import org.dcm4che.srom.RelationConstraints;
import org.dcm4che.srom.SCoordContent;
import org.dcm4che.srom.TCoordContent;
import org.dcm4che.srom.TextContent;
import org.dcm4che.srom.UIDRefContent;
import org.dcm4che.srom.WaveformContent;

abstract class RelationConstraintsImpl
implements RelationConstraints {
    static Logger log = Logger.getLogger(RelationConstraintsImpl.class);
    public static final RelationConstraints KEY_OBJECT = new RelationConstraints(){

        public void check(Content source, Content.RelationType relation, Content target) {
            if (!(source instanceof ContainerContent)) {
                log.warn("Violation of Rel Constraints for Key Objects - source:" + source);
            }
            if (relation == Content.RelationType.CONTAINS) {
                if (!(target instanceof TextContent) && !(target instanceof CompositeContent)) {
                    log.warn("Violation of Rel Constraints for Key Objects - target:" + target);
                }
            } else if (relation == Content.RelationType.HAS_OBS_CONTEXT) {
                if (!(target instanceof TextContent || target instanceof CodeContent || target instanceof UIDRefContent || target instanceof PNameContent)) {
                    log.warn("Violation of Rel Constraints for Key Objects - target:" + target);
                }
            } else if (relation == Content.RelationType.HAS_CONCEPT_MOD) {
                if (!(target instanceof CodeContent)) {
                    log.warn("Violation of Rel Constraints for Key Objects - target:" + target);
                }
            } else {
                log.warn("Violation of Rel Constraints for Key Objects - rel:" + relation);
            }
        }
    };
    public static final RelationConstraints BASIC_TEXT_SR = new RelationConstraintsImpl(){

        void checkTarget(Content target) {
            if (target instanceof ReferencedContent || target instanceof NumContent || target instanceof SCoordContent || target instanceof TCoordContent) {
                log.warn("Violation of Rel Constraints for Basic Text SR - target:" + target);
            }
        }

        void checkSelectedFrom(Content source, Content target) {
            log.warn("Violation of Rel Constraints for Basic Text SR - rel:" + Content.RelationType.SELECTED_FROM);
        }
    };
    public static final RelationConstraints ENHANCED_SR = new RelationConstraintsImpl(){

        void checkTarget(Content target) {
            if (target instanceof ReferencedContent) {
                log.warn("Violation of Rel Constraints for Enhanced SR - target:" + target);
            }
        }
    };

    RelationConstraintsImpl() {
    }

    public static RelationConstraints valueOf(String sopClassUID) {
        if ("1.2.840.10008.5.1.4.1.1.88.11".equals(sopClassUID)) {
            return BASIC_TEXT_SR;
        }
        if ("1.2.840.10008.5.1.4.1.1.88.22".equals(sopClassUID)) {
            return ENHANCED_SR;
        }
        if ("1.2.840.10008.5.1.4.1.1.88.33".equals(sopClassUID)) {
            return null;
        }
        if ("1.2.840.10008.5.1.4.1.1.88.59".equals(sopClassUID)) {
            return KEY_OBJECT;
        }
        return null;
    }

    static boolean isContainerOrComposite(Content content) {
        return content instanceof ContainerContent || content instanceof CompositeContent;
    }

    void checkTarget(Content target) {
    }

    void checkContains(Content source, Content target) {
        if (!(source instanceof ContainerContent)) {
            log.warn("Violation of CONTAINS Rel Constraints - source:" + source);
        }
    }

    void checkHasObsContext(Content source, Content target) {
        if (!(source instanceof ContainerContent)) {
            log.warn("Violation of HAS OBS CONTEXT Rel Constraints - source:" + source);
        }
        if (RelationConstraintsImpl.isContainerOrComposite(target)) {
            log.warn("Violation of HAS OBS CONTEXT Rel Constraints - target:" + target);
        }
    }

    void checkHasAcqContext(Content source, Content target) {
        if (!RelationConstraintsImpl.isContainerOrComposite(source)) {
            log.warn("Violation of HAS ACQ CONTEXT Rel Constraints - source:" + source);
        }
        if (RelationConstraintsImpl.isContainerOrComposite(target)) {
            log.warn("Violation of HAS ACQ CONTEXT Rel Constraints - source:" + target);
        }
    }

    void checkHasConceptMod(Content source, Content target) {
        if (!(target instanceof TextContent) && !(target instanceof CodeContent)) {
            log.warn("Violation of HAS CONCEPT MOD Rel Constraints - target:" + target);
        }
    }

    void checkHasProperties(Content source, Content target) {
        if (!(source instanceof TextContent || source instanceof CodeContent || source instanceof NumContent)) {
            log.warn("Violation of HAS PROPERTIES Rel Constraints - source:" + source);
        }
        if (target instanceof ContainerContent) {
            log.warn("Violation of HAS PROPERTIES Rel Constraints - target:" + target);
        }
    }

    void checkInferredFrom(Content source, Content target) {
        this.checkHasProperties(source, target);
    }

    void checkSelectedFrom(Content source, Content target) {
        if (source instanceof SCoordContent) {
            if (!(target instanceof ImageContent)) {
                log.warn("Violation of SELECT FROM Rel Constraints - target:" + target);
            }
        } else if (source instanceof TCoordContent) {
            if (!(target instanceof SCoordContent || target instanceof ImageContent || target instanceof WaveformContent)) {
                log.warn("Violation of SELECT FROM Rel Constraints - target:" + target);
            }
        } else {
            log.warn("Violation of SELECT FROM Rel Constraints - source:" + source);
        }
    }

    public void check(Content source, Content.RelationType relation, Content target) {
        this.checkTarget(target);
        if (relation == Content.RelationType.CONTAINS) {
            this.checkContains(source, target);
        } else if (relation == Content.RelationType.HAS_OBS_CONTEXT) {
            this.checkHasObsContext(source, target);
        } else if (relation == Content.RelationType.HAS_ACQ_CONTEXT) {
            this.checkHasAcqContext(source, target);
        } else if (relation == Content.RelationType.HAS_CONCEPT_MOD) {
            this.checkHasConceptMod(source, target);
        } else if (relation == Content.RelationType.HAS_PROPERTIES) {
            this.checkHasProperties(source, target);
        } else if (relation == Content.RelationType.INFERRED_FROM) {
            this.checkInferredFrom(source, target);
        } else if (relation == Content.RelationType.SELECTED_FROM) {
            this.checkSelectedFrom(source, target);
        } else {
            throw new IllegalArgumentException("" + relation);
        }
    }
}

