/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.CodeContent;
import org.dcm4che.srom.CompositeContent;
import org.dcm4che.srom.ContainerContent;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.DateContent;
import org.dcm4che.srom.DateTimeContent;
import org.dcm4che.srom.Equipment;
import org.dcm4che.srom.IconImage;
import org.dcm4che.srom.ImageContent;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.NumContent;
import org.dcm4che.srom.PNameContent;
import org.dcm4che.srom.Patient;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.ReferencedContent;
import org.dcm4che.srom.RelationConstraints;
import org.dcm4che.srom.Request;
import org.dcm4che.srom.SCoordContent;
import org.dcm4che.srom.SOPInstanceRef;
import org.dcm4che.srom.Series;
import org.dcm4che.srom.Study;
import org.dcm4che.srom.TCoordContent;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.TextContent;
import org.dcm4che.srom.TimeContent;
import org.dcm4che.srom.UIDRefContent;
import org.dcm4che.srom.WaveformContent;
import org.dcm4cheri.srom.CodeContentImpl;
import org.dcm4cheri.srom.CodeImpl;
import org.dcm4cheri.srom.CompositeContentImpl;
import org.dcm4cheri.srom.ContainerContentImpl;
import org.dcm4cheri.srom.ContentImpl;
import org.dcm4cheri.srom.DateContentImpl;
import org.dcm4cheri.srom.DateTimeContentImpl;
import org.dcm4cheri.srom.EquipmentImpl;
import org.dcm4cheri.srom.ImageContentImpl;
import org.dcm4cheri.srom.NumContentImpl;
import org.dcm4cheri.srom.PNameContentImpl;
import org.dcm4cheri.srom.PatientImpl;
import org.dcm4cheri.srom.ReferencedContentImpl;
import org.dcm4cheri.srom.RelationConstraintsImpl;
import org.dcm4cheri.srom.RequestImpl;
import org.dcm4cheri.srom.SCoordContentImpl;
import org.dcm4cheri.srom.SOPInstanceRefImpl;
import org.dcm4cheri.srom.SeriesImpl;
import org.dcm4cheri.srom.StudyImpl;
import org.dcm4cheri.srom.TCoordContentImpl;
import org.dcm4cheri.srom.TemplateImpl;
import org.dcm4cheri.srom.TextContentImpl;
import org.dcm4cheri.srom.TimeContentImpl;
import org.dcm4cheri.srom.UIDRefContentImpl;
import org.dcm4cheri.srom.WaveformContentImpl;

class KeyObjectImpl
extends ContainerContentImpl
implements KeyObject {
    protected Patient patient;
    protected Study study;
    protected Series series;
    protected Equipment equipment;
    protected final String modality;
    protected final String sopClassUID;
    protected String sopInstanceUID;
    protected String specificCharacterSet;
    protected Long instanceCreationDateTime;
    protected String instanceCreatorUID;
    protected int instanceNumber = 1;
    protected long contentDateTime = Calendar.getInstance().getTime().getTime();
    protected final List requests = new LinkedList();
    protected final List currentEvidence = new LinkedList();
    protected final List identicalDocuments = new LinkedList();
    protected final RelationConstraints relConstraints;

    KeyObjectImpl(Patient patient, Study study, Series series, Equipment equipment, String sopInstanceUID, int instanceNumber, Date obsDateTime, Code title, boolean separate) {
        this(patient, study, series, equipment, "1.2.840.10008.5.1.4.1.1.88.59", sopInstanceUID, instanceNumber, obsDateTime, TemplateImpl.TID_2010, title, separate, "KO");
    }

    protected KeyObjectImpl(Patient patient, Study study, Series series, Equipment equipment, String sopClassUID, String sopInstanceUID, int instanceNumber, Date obsDateTime, Template template, Code title, boolean separate, String modality) {
        super(null, obsDateTime, template, title, separate);
        this.owner = this;
        if (sopClassUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (sopInstanceUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (title == null) {
            throw new NullPointerException();
        }
        this.sopClassUID = sopClassUID;
        this.sopInstanceUID = sopInstanceUID;
        this.instanceNumber = instanceNumber;
        this.modality = modality;
        this.relConstraints = RelationConstraintsImpl.valueOf(sopClassUID);
        this.setPatient(patient);
        this.setStudy(study);
        this.setSeries(series);
        this.setEquipment(equipment);
    }

    static KeyObject newKeyObject(Dataset ds) throws DcmValueException {
        String sopClassUID = ds.getString(524310);
        if (!"1.2.840.10008.5.1.4.1.1.88.59".equals(sopClassUID)) {
            throw new IllegalArgumentException(sopClassUID);
        }
        TemplateImpl template = new TemplateImpl(ds.getItem(4236548));
        if (!((Object)TemplateImpl.TID_2010).equals(template)) {
            throw new IllegalArgumentException(((Object)template).toString());
        }
        if (!"CONTAINER".equals(ds.getString(0x40A040))) {
            throw new IllegalArgumentException(ds.getString(0x40A040));
        }
        KeyObjectImpl ko = new KeyObjectImpl(new PatientImpl(ds), new StudyImpl(ds), new SeriesImpl(ds), new EquipmentImpl(ds), ds.getString(524312), ds.getInt(2097171, -1), ds.getDate(4235314), new CodeImpl(ds.getItem(4235331)), "SEPARATE".equals(ds.getString(4235344)));
        ko.init(ds);
        return ko;
    }

    protected void init(Dataset ds) throws DcmValueException {
        this.setSpecificCharacterSet(ds.getString(524293));
        this.setInstanceCreationDateTime(ds.getDateTime(524306, 524307));
        this.setContentDateTime(ds.getDateTime(524323, 524339));
        this.initRequests(ds.get(4236144));
        this.initSOPInstanceRefList(this.currentEvidence, ds.get(4236149));
        this.initSOPInstanceRefList(this.identicalDocuments, ds.get(4236581));
        super.initChilds(this, ds);
    }

    protected void initRequests(DcmElement sq) throws DcmValueException {
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            this.requests.add(new RequestImpl(sq.getItem(i)));
        }
    }

    protected void initSOPInstanceRefList(List list, DcmElement sq) throws DcmValueException {
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset ds = sq.getItem(i);
            String studyInstanceUID = ds.getString(0x20000D);
            DcmElement sq2 = ds.get(528661);
            int n2 = sq2.countItems();
            for (int i2 = 0; i2 < n2; ++i2) {
                Dataset ds2 = sq2.getItem(i2);
                String seriesInstanceUID = ds2.getString(0x20000E);
                DcmElement sq3 = ds2.get(528793);
                if (sq3 == null) continue;
                int n3 = sq3.countItems();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Dataset ds3 = sq3.getItem(i3);
                    list.add(new SOPInstanceRefImpl(ds3.getString(528720), ds3.getString(528725), seriesInstanceUID, studyInstanceUID));
                }
            }
        }
    }

    public String toString() {
        return "Key Object Selection Document[" + this.getName().getCodeMeaning() + "," + this.getSOPInstanceUID() + ",#" + this.getInstanceNumber() + "," + this.getContentDateTime() + "]";
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        if (patient == null) {
            throw new NullPointerException();
        }
        this.patient = patient;
    }

    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        if (study == null) {
            throw new NullPointerException();
        }
        this.study = study;
    }

    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        if (!this.modality.equals(series.getModality())) {
            throw new IllegalArgumentException(series.getModality());
        }
        this.series = series;
    }

    public Equipment getEquipment() {
        return this.equipment;
    }

    public void setEquipment(Equipment equipment) {
        this.equipment = new EquipmentImpl(equipment);
    }

    public RelationConstraints getRelationConstraints() {
        return this.relConstraints;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public void setSOPInstanceUID(String sopInstanceUID) {
        if (sopInstanceUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.sopInstanceUID = sopInstanceUID;
    }

    public String getSpecificCharacterSet() {
        return this.specificCharacterSet;
    }

    public void setSpecificCharacterSet(String specificCharacterSet) {
        this.specificCharacterSet = specificCharacterSet;
    }

    public Date getInstanceCreationDateTime() {
        return this.instanceCreationDateTime != null ? new Date(this.instanceCreationDateTime) : null;
    }

    public void setInstanceCreationDateTime(Date instanceCreationDateTime) {
        this.instanceCreationDateTime = instanceCreationDateTime != null ? new Long(instanceCreationDateTime.getTime()) : null;
    }

    public String getInstanceCreatorUID() {
        return this.instanceCreatorUID;
    }

    public void setInstanceCreatorUID(String instanceCreatorUID) {
        this.instanceCreatorUID = instanceCreatorUID;
    }

    public void setInstanceNumber(int instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setContentDateTime(Date contentDateTime) {
        this.contentDateTime = contentDateTime.getTime();
    }

    public Date getContentDateTime() {
        return new Date(this.contentDateTime);
    }

    protected static List checkList(Object[] a) {
        if (a == null) {
            return Collections.EMPTY_LIST;
        }
        List<Object> list = Arrays.asList(a);
        int i = list.indexOf(null);
        if (i != -1) {
            throw new NullPointerException("[" + i + "]");
        }
        return list;
    }

    protected static SOPInstanceRef findSOPInstanceRef(List list, RefSOP ref) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!ref.equals(o)) continue;
            return (SOPInstanceRef)o;
        }
        return null;
    }

    public Request[] getRequests() {
        return this.requests.toArray(RequestImpl.EMPTY_ARRAY);
    }

    public void setRequests(Request[] newRequests) {
        List list = KeyObjectImpl.checkList(newRequests);
        this.requests.clear();
        this.requests.addAll(list);
    }

    public boolean addRequest(Request request) {
        if (request == null) {
            throw new NullPointerException();
        }
        if (this.requests.indexOf(request) != -1) {
            return false;
        }
        return this.requests.add(request);
    }

    public boolean removeRequest(Request request) {
        return this.requests.remove(request);
    }

    public SOPInstanceRef[] getCurrentEvidence() {
        return this.currentEvidence.toArray(SOPInstanceRefImpl.EMPTY_ARRAY);
    }

    public SOPInstanceRef findCurrentEvidence(RefSOP ref) {
        return KeyObjectImpl.findSOPInstanceRef(this.currentEvidence, ref);
    }

    public void setCurrentEvidence(SOPInstanceRef[] refs) {
        List list = KeyObjectImpl.checkList(refs);
        this.currentEvidence.clear();
        this.currentEvidence.addAll(list);
    }

    public boolean addCurrentEvidence(SOPInstanceRef ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        if (this.currentEvidence.indexOf(ref) != -1) {
            return false;
        }
        return this.currentEvidence.add(ref);
    }

    public boolean removeCurrentEvidence(RefSOP ref) {
        return this.currentEvidence.remove(ref);
    }

    public SOPInstanceRef[] getIdenticalDocuments() {
        return this.identicalDocuments.toArray(SOPInstanceRefImpl.EMPTY_ARRAY);
    }

    public void setIdenticalDocuments(SOPInstanceRef[] refs) {
        List list = KeyObjectImpl.checkList(refs);
        this.identicalDocuments.clear();
        this.identicalDocuments.addAll(list);
    }

    public boolean addIdenticalDocument(SOPInstanceRef ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        if (this.identicalDocuments.indexOf(ref) != -1) {
            return false;
        }
        return this.identicalDocuments.add(ref);
    }

    public boolean removeIdenticalDocument(RefSOP ref) {
        return this.identicalDocuments.remove(ref);
    }

    private static Content getChild(Content parent, int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        int count = index;
        for (Content child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (--count != 0) continue;
            return child;
        }
        return null;
    }

    public Content getContent(int[] id) {
        if (id.length == 0 || id[0] != 1) {
            throw new IllegalArgumentException();
        }
        Content cur = this;
        for (int i = 1; i < id.length; ++i) {
            cur = KeyObjectImpl.getChild(cur, id[i]);
        }
        return cur;
    }

    public ContainerContent createContainerContent(Date obsDateTime, Template template, Code name, boolean separate) {
        return new ContainerContentImpl(this, obsDateTime, template, name, separate);
    }

    public TextContent createTextContent(Date obsDateTime, Template template, Code name, String text) {
        return new TextContentImpl(this, obsDateTime, template, name, text);
    }

    public PNameContent createPNameContent(Date obsDateTime, Template template, Code name, String pname) {
        return new PNameContentImpl(this, obsDateTime, template, name, pname);
    }

    public UIDRefContent createUIDRefContent(Date obsDateTime, Template template, Code name, String uid) {
        return new UIDRefContentImpl(this, obsDateTime, template, name, uid);
    }

    public CodeContent createCodeContent(Date obsDateTime, Template template, Code name, Code code) {
        return new CodeContentImpl(this, obsDateTime, template, name, code);
    }

    public NumContent createNumContent(Date obsDateTime, Template template, Code name, float value, Code unit) {
        return new NumContentImpl(this, obsDateTime, template, name, new Float(value), unit, null);
    }

    public NumContent createNumContent(Date obsDateTime, Template template, Code name, Float value, Code unit, Code qualifier) {
        return new NumContentImpl(this, obsDateTime, template, name, value, unit, qualifier);
    }

    public DateContent createDateContent(Date obsDateTime, Template template, Code name, Date date) {
        return new DateContentImpl((KeyObject)this, obsDateTime, template, name, date);
    }

    public TimeContent createTimeContent(Date obsDateTime, Template template, Code name, Date time) {
        return new TimeContentImpl((KeyObject)this, obsDateTime, template, name, time);
    }

    public DateTimeContent createDateTimeContent(Date obsDateTime, Template template, Code name, Date dateTime) {
        return new DateTimeContentImpl((KeyObject)this, obsDateTime, template, name, dateTime);
    }

    public CompositeContent createCompositeContent(Date obsDateTime, Template template, Code name, RefSOP refSOP) {
        return new CompositeContentImpl(this, obsDateTime, template, name, refSOP);
    }

    public ImageContent createImageContent(Date obsDateTime, Template template, Code name, RefSOP refSOP, int[] frameNumbers, RefSOP refPresentationSOP, IconImage iconImage) {
        return new ImageContentImpl(this, obsDateTime, template, name, refSOP, frameNumbers, refPresentationSOP, iconImage);
    }

    public WaveformContent createWaveformContent(Date obsDateTime, Template template, Code name, RefSOP refSOP, int[] channelNumbers) {
        return new WaveformContentImpl(this, obsDateTime, template, name, refSOP, channelNumbers);
    }

    public SCoordContent.Point createPointSCoordContent(Date obsDateTime, Template template, Code name, float[] graphicData) {
        return new SCoordContentImpl.Point(this, obsDateTime, template, name, graphicData);
    }

    public SCoordContent.MultiPoint createMultiPointSCoordContent(Date obsDateTime, Template template, Code name, float[] graphicData) {
        return new SCoordContentImpl.MultiPoint(this, obsDateTime, template, name, graphicData);
    }

    public SCoordContent.Polyline createPolylineSCoordContent(Date obsDateTime, Template template, Code name, float[] graphicData) {
        return new SCoordContentImpl.Polyline(this, obsDateTime, template, name, graphicData);
    }

    public SCoordContent.Circle createCircleSCoordContent(Date obsDateTime, Template template, Code name, float[] graphicData) {
        return new SCoordContentImpl.Circle(this, obsDateTime, template, name, graphicData);
    }

    public SCoordContent.Ellipse createEllipseSCoordContent(Date obsDateTime, Template template, Code name, float[] graphicData) {
        return new SCoordContentImpl.Ellipse(this, obsDateTime, template, name, graphicData);
    }

    public TCoordContent.Point createPointTCoordContent(Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
        return new TCoordContentImpl.Point(this, obsDateTime, template, name, positions);
    }

    public TCoordContent.MultiPoint createMultiPointTCoordContent(Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
        return new TCoordContentImpl.MultiPoint(this, obsDateTime, template, name, positions);
    }

    public TCoordContent.Segment createSegmentTCoordContent(Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
        return new TCoordContentImpl.Segment(this, obsDateTime, template, name, positions);
    }

    public TCoordContent.MultiSegment createMultiSegmentTCoordContent(Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
        return new TCoordContentImpl.MultiSegment(this, obsDateTime, template, name, positions);
    }

    public TCoordContent.Begin createBeginTCoordContent(Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
        return new TCoordContentImpl.Begin(this, obsDateTime, template, name, positions);
    }

    public TCoordContent.End createEndTCoordContent(Date obsDateTime, Template template, Code name, TCoordContent.Positions positions) {
        return new TCoordContentImpl.End(this, obsDateTime, template, name, positions);
    }

    public ReferencedContent createReferencedContent(Content refContent) {
        return new ReferencedContentImpl((KeyObject)this, refContent);
    }

    public ReferencedContent createReferencedContent(int[] refContentId) {
        return new ReferencedContentImpl((KeyObject)this, refContentId);
    }

    public Content importContent(Content content, boolean deep) {
        return ((ContentImpl)content).clone(this, deep, true);
    }

    protected static void sopInstanceRefListToSQ(List list, DcmElement sq) {
        HashMap studyMap = new HashMap();
        Iterator<Object> it = list.iterator();
        while (it.hasNext()) {
            LinkedList<SOPInstanceRef> refSOPList;
            SOPInstanceRef ref = (SOPInstanceRef)it.next();
            HashMap<String, LinkedList<SOPInstanceRef>> seriesMap = (HashMap<String, LinkedList<SOPInstanceRef>>)studyMap.get(ref.getStudyInstanceUID());
            if (seriesMap == null) {
                seriesMap = new HashMap<String, LinkedList<SOPInstanceRef>>();
                studyMap.put(ref.getStudyInstanceUID(), seriesMap);
            }
            if ((refSOPList = (LinkedList<SOPInstanceRef>)seriesMap.get(ref.getSeriesInstanceUID())) == null) {
                refSOPList = new LinkedList<SOPInstanceRef>();
                seriesMap.put(ref.getSeriesInstanceUID(), refSOPList);
            }
            refSOPList.add(ref);
        }
        it = studyMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Dataset study = sq.addNewItem();
            study.putUI(0x20000D, (String)entry.getKey());
            DcmElement refSeriesSeq = study.putSQ(528661);
            Iterator it2 = ((Map)entry.getValue()).entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry2 = it2.next();
                Dataset series = refSeriesSeq.addNewItem();
                series.putUI(0x20000E, (String)entry2.getKey());
                DcmElement refSOPSeq = series.putSQ(528793);
                Iterator it3 = ((List)entry2.getValue()).iterator();
                while (it3.hasNext()) {
                    ((SOPInstanceRef)it3.next()).toDataset(refSOPSeq.addNewItem());
                }
            }
        }
    }

    public void toDataset(Dataset ds) {
        Date dt;
        if (this.specificCharacterSet != null) {
            ds.putCS(524293, this.specificCharacterSet);
        }
        ds.putUI(524310, this.sopClassUID);
        ds.putUI(524312, this.sopInstanceUID);
        ds.putIS(2097171, this.instanceNumber);
        if (this.instanceCreationDateTime != null) {
            dt = new Date(this.instanceCreationDateTime);
            ds.putDA(524306, dt);
            ds.putTM(524307, dt);
        }
        dt = this.getContentDateTime();
        ds.putDA(524323, dt);
        ds.putTM(524339, dt);
        this.patient.toDataset(ds);
        this.study.toDataset(ds);
        this.series.toDataset(ds);
        this.equipment.toDataset(ds);
        if (!this.requests.isEmpty()) {
            DcmElement sq = ds.putSQ(4236144);
            Iterator it = this.requests.iterator();
            while (it.hasNext()) {
                ((Request)it.next()).toDataset(sq.addNewItem());
            }
        }
        if (!this.currentEvidence.isEmpty()) {
            KeyObjectImpl.sopInstanceRefListToSQ(this.currentEvidence, ds.putSQ(4236149));
        }
        if (!this.identicalDocuments.isEmpty()) {
            KeyObjectImpl.sopInstanceRefListToSQ(this.currentEvidence, ds.putSQ(4236581));
        }
        super.toDataset(ds);
    }

    public Dataset toDataset() {
        Dataset ds = dsfact.newDataset();
        this.toDataset(ds);
        return ds;
    }
}

