/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dcm4che.data.PersonName;

class PersonNameImpl
implements PersonName {
    private static final int[] FORMAT_ORDER = new int[]{3, 1, 2, 0, 4};
    private static final Logger log = Logger.getLogger(PersonNameImpl.class);
    private final String[] components = new String[5];
    private PersonNameImpl ideographic;
    private PersonNameImpl phonetic;

    public PersonNameImpl() {
    }

    public PersonNameImpl(String s, boolean lenient) {
        String tk;
        int grLen = s.indexOf(61);
        if ((grLen == -1 ? s.length() : grLen) > 64) {
            if (lenient) {
                log.warn("To long PN: " + s);
            } else {
                throw new IllegalArgumentException(s);
            }
        }
        StringTokenizer stk = new StringTokenizer(s, "=^", true);
        int field = 0;
        block4: while (stk.hasMoreTokens()) {
            tk = stk.nextToken();
            switch (tk.charAt(0)) {
                case '^': {
                    if (++field <= 4) continue block4;
                    log.warn("Illegal PN: " + s + " - ignore '^' delimiter");
                    --field;
                    continue block4;
                }
                case '=': {
                    break block4;
                }
                default: {
                    this.components[field] = tk;
                    continue block4;
                }
            }
        }
        if (!stk.hasMoreTokens()) {
            return;
        }
        tk = stk.nextToken("=");
        if (tk.charAt(0) != '=') {
            this.ideographic = new PersonNameImpl(tk, lenient);
            if (stk.hasMoreTokens()) {
                tk = stk.nextToken("=");
            }
        }
        if (!stk.hasMoreTokens()) {
            return;
        }
        tk = stk.nextToken();
        if (tk.charAt(0) == '=' || stk.hasMoreTokens()) {
            throw new IllegalArgumentException(s);
        }
        this.phonetic = new PersonNameImpl(tk, lenient);
    }

    public String get(int field) {
        return this.components[field];
    }

    public void set(int field, String value) {
        this.components[field] = value;
    }

    public PersonName getIdeographic() {
        return this.ideographic;
    }

    public PersonName getPhonetic() {
        return this.phonetic;
    }

    public void setIdeographic(PersonName ideographic) {
        this.ideographic = (PersonNameImpl)ideographic;
    }

    public void setPhonetic(PersonName phonetic) {
        this.phonetic = (PersonNameImpl)phonetic;
    }

    private StringBuffer appendComponents(StringBuffer sb, String nullmask, boolean trim) {
        sb.append(this.maskNull(this.components[0], nullmask));
        sb.append('^');
        sb.append(this.maskNull(this.components[1], nullmask));
        sb.append('^');
        sb.append(this.maskNull(this.components[2], nullmask));
        sb.append('^');
        sb.append(this.maskNull(this.components[3], nullmask));
        sb.append('^');
        sb.append(this.maskNull(this.components[4], nullmask));
        if (trim) {
            int last;
            for (last = sb.length() - 1; last >= 0 && sb.charAt(last) == '^'; --last) {
            }
            sb.setLength(last + 1);
        }
        return sb;
    }

    private String maskNull(String val, String mask) {
        return val != null ? val : mask;
    }

    public String toComponentGroupString(boolean trim) {
        return this.toComponentGroupString("", trim);
    }

    public String toComponentGroupMatch() {
        return this.trimMatch(this.toComponentGroupString("*", false));
    }

    private String trimMatch(String val) {
        char[] a = val.toCharArray();
        int len = a.length;
        if (len < 3 || a[len - 3] != '*' || a[len - 2] != '^' || a[len - 1] != '*') {
            return val;
        }
        while ((len -= 2) >= 3 && a[len - 3] == '*' && a[len - 2] == '^') {
        }
        return val.substring(0, len);
    }

    private String toComponentGroupString(String nullMask, boolean trim) {
        StringBuffer sb = new StringBuffer();
        this.appendComponents(sb, nullMask, trim);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.appendComponents(sb, "", true);
        if (this.ideographic != null || this.phonetic != null) {
            sb.append('=');
            if (this.ideographic != null) {
                this.ideographic.appendComponents(sb, "", true);
            }
            if (this.phonetic != null) {
                sb.append('=');
                this.phonetic.appendComponents(sb, "", true);
            }
        }
        return sb.toString();
    }

    public String format() {
        return this.format(FORMAT_ORDER);
    }

    public String format(int[] fields) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            String s = this.get(fields[i]);
            if (s == null || s.length() <= 0) continue;
            sb.append(s).append(' ');
        }
        return sb.substring(0, Math.max(0, sb.length() - 1));
    }

    public boolean equals(Object o) {
        if (!(o instanceof PersonNameImpl)) {
            return false;
        }
        PersonNameImpl other = (PersonNameImpl)o;
        return Arrays.equals(this.components, other.components);
    }
}

