/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.DcmHandlerAdapter;
import org.dcm4cheri.data.DcmHandlerAdapter2;
import org.dcm4cheri.data.DcmObjectImpl;
import org.dcm4cheri.data.DcmParserImpl;
import org.dcm4cheri.data.DcmStreamHandlerImpl;
import org.xml.sax.ContentHandler;

final class FileMetaInfoImpl
extends DcmObjectImpl
implements FileMetaInfo {
    static final byte[] DICM_PREFIX = new byte[]{68, 73, 67, 77};
    static final byte[] VERSION = new byte[]{0, 1};
    private byte[] preamble = new byte[128];
    private String sopClassUID = null;
    private String sopInstanceUID = null;
    private String tsUID = null;
    private String implClassUID = null;
    private String implVersionName = null;

    FileMetaInfoImpl() {
    }

    public String toString() {
        return "FileMetaInfo[uid=" + this.sopInstanceUID + "\n\tclass=" + DICT.lookup(this.sopClassUID) + "\n\tts=" + DICT.lookup(this.tsUID) + "\n\timpl=" + this.implClassUID + "-" + this.implVersionName + "]";
    }

    public final byte[] getPreamble() {
        return this.preamble != null ? (byte[])this.preamble.clone() : null;
    }

    public final void setPreamble(byte[] preamble) {
        if (preamble == null) {
            this.preamble = null;
        } else {
            if (preamble.length != 128) {
                throw new IllegalArgumentException("preamble length: " + preamble.length);
            }
            this.preamble = (byte[])preamble.clone();
        }
    }

    FileMetaInfoImpl init(String sopClassUID, String sopInstUID, String tsUID, String implClassUID, String implVersName) {
        this.preamble = new byte[128];
        this.putOB(131073, (byte[])VERSION.clone());
        this.putUI(131074, sopClassUID);
        this.putUI(131075, sopInstUID);
        this.putUI(131088, tsUID);
        this.putUI(131090, implClassUID);
        if (implVersName != null) {
            this.putSH(131091, implVersName);
        }
        return this;
    }

    public String getMediaStorageSOPClassUID() {
        return this.sopClassUID;
    }

    public String getMediaStorageSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getTransferSyntaxUID() {
        return this.tsUID;
    }

    public String getImplementationClassUID() {
        return this.implClassUID;
    }

    public String getImplementationVersionName() {
        return this.implVersionName;
    }

    protected DcmElement put(DcmElement newElem) {
        int tag = newElem.tag();
        if ((tag & 0xFFFF0000) != 131072) {
            throw new IllegalArgumentException(newElem.toString());
        }
        try {
            switch (tag) {
                case 131074: {
                    this.sopClassUID = newElem.getString(null);
                    break;
                }
                case 131075: {
                    this.sopInstanceUID = newElem.getString(null);
                    break;
                }
                case 131088: {
                    this.tsUID = newElem.getString(null);
                    break;
                }
                case 131090: {
                    this.implClassUID = newElem.getString(null);
                    break;
                }
                case 131091: {
                    this.implVersionName = newElem.getString(null);
                }
            }
        }
        catch (DcmValueException ex) {
            throw new IllegalArgumentException(newElem.toString());
        }
        return super.put(newElem);
    }

    public int length() {
        return this.grLen() + 12;
    }

    private int grLen() {
        int len = 0;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            DcmElement e = (DcmElement)this.list.get(i);
            len += e.length() + (VRs.isLengthField16Bit(e.vr()) ? 8 : 12);
        }
        return len;
    }

    public void write(DcmHandler handler) throws IOException {
        handler.startFileMetaInfo(this.preamble);
        handler.setDcmDecodeParam(DcmDecodeParam.EVR_LE);
        this.write(131072, this.grLen(), handler);
        handler.endFileMetaInfo();
    }

    public void write(OutputStream out) throws IOException {
        this.write(new DcmStreamHandlerImpl(out));
    }

    public void write(ImageOutputStream out) throws IOException {
        this.write(new DcmStreamHandlerImpl(out));
    }

    public void write(ContentHandler ch, TagDictionary dict) throws IOException {
        this.write(new DcmHandlerAdapter(ch, dict));
    }

    public void write2(ContentHandler ch, TagDictionary dict, int[] excludeTags, int excludeValueLengthLimit, File basedir) throws IOException {
        this.write(new DcmHandlerAdapter2(ch, dict, excludeTags, excludeValueLengthLimit, basedir));
    }

    public void read(InputStream in) throws IOException {
        DcmParserImpl parser = new DcmParserImpl(in);
        parser.setDcmHandler(this.getDcmHandler());
        parser.parseFileMetaInfo();
    }
}

