/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.image;

import java.nio.ByteOrder;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;

public class PixelDataDescription {
    protected final int cols;
    protected final int rows;
    protected final int nf;
    protected final int frameSize;
    protected final int size;
    protected final int samplesPerFrame;
    protected final int ba;
    protected final int bs;
    protected final int hb;
    protected final int spp;
    protected final boolean signed;
    protected final boolean byPlane;
    protected final String pmi;
    protected final ByteOrder byteOrder;
    protected final int pixelDataVr;

    private PixelDataDescription(int cols, int rows, int nf, int ba, int bs, int hb, int spp, boolean signed, boolean byPlane, String pmi, ByteOrder byteOrder, int pixelDataVr) {
        this.cols = cols;
        this.rows = rows;
        this.nf = nf;
        this.frameSize = cols * rows;
        this.samplesPerFrame = this.frameSize * spp;
        this.size = this.frameSize * nf;
        this.ba = ba;
        this.bs = bs;
        this.hb = hb;
        this.spp = spp;
        this.signed = signed;
        this.byPlane = byPlane;
        this.pmi = pmi;
        this.byteOrder = byteOrder;
        this.pixelDataVr = pixelDataVr;
    }

    public PixelDataDescription(PixelDataDescription desc, DcmDecodeParam dcmParam, int bitsAllocated, int bitsStored, boolean signed, boolean byPlane) {
        this.cols = desc.getCols();
        this.rows = desc.getRows();
        this.nf = desc.getNumberOfFrames();
        this.ba = bitsAllocated;
        this.bs = bitsStored;
        this.hb = this.bs - 1;
        this.spp = desc.getSamplesPerPixel();
        this.frameSize = this.cols * this.rows;
        this.samplesPerFrame = this.frameSize * this.spp;
        this.size = this.frameSize * this.nf;
        this.signed = signed;
        this.byPlane = byPlane;
        this.pmi = desc.getPmi();
        this.byteOrder = dcmParam.byteOrder;
        this.pixelDataVr = dcmParam.explicitVR ? (bitsAllocated > 8 ? 20311 : 20290) : 20311;
    }

    public PixelDataDescription(Dataset ds, ByteOrder byteOrder, int pixelDataVr) {
        this.pmi = ds.getString(2621444, "MONOCHROME2");
        if (this.pmi == null) {
            throw new IllegalArgumentException("No photometric interpretation");
        }
        this.ba = ds.getInt(2621696, -1);
        if (this.ba == -1) {
            throw new IllegalArgumentException("No Bits Allocated");
        }
        this.bs = ds.getInt(2621697, -1);
        if (this.bs == -1) {
            throw new IllegalArgumentException("No Bits Stored");
        }
        this.hb = ds.getInt(2621698, -1);
        if (this.hb == -1) {
            throw new IllegalArgumentException("No High Bit");
        }
        if (this.bs <= this.hb) {
            throw new IllegalArgumentException("Bits Stored <= High Bit");
        }
        int tmp = ds.getInt(2621699, -1);
        if (tmp == -1) {
            throw new IllegalArgumentException("No Pixel Representation");
        }
        this.signed = tmp == 1;
        this.spp = ds.getInt(0x280002, 1);
        if (this.spp == -1) {
            throw new IllegalArgumentException("No Samples Per Pixel");
        }
        tmp = ds.getInt(2621446, 0);
        this.byPlane = tmp == 1;
        this.cols = ds.getInt(2621457, -1);
        if (this.cols == -1) {
            throw new IllegalArgumentException("No Columns");
        }
        this.rows = ds.getInt(2621456, -1);
        if (this.rows == -1) {
            throw new IllegalArgumentException("No Rows");
        }
        this.nf = ds.getInt(0x280008, 1);
        this.frameSize = this.cols * this.rows;
        this.samplesPerFrame = this.frameSize * this.spp;
        this.size = this.frameSize * this.nf;
        if (this.ba > 32) {
            throw new UnsupportedOperationException("Bits Allocated > 32 are not supported: " + this.ba);
        }
        this.byteOrder = byteOrder;
        this.pixelDataVr = pixelDataVr;
    }

    public long calcPixelDataLength() {
        long pixelDataLen = (long)this.cols * (long)this.rows * (long)this.nf * (long)this.spp * (long)this.ba;
        pixelDataLen = pixelDataLen % 8L != 0L ? (pixelDataLen >>> 3) + 1L : (pixelDataLen >>>= 3);
        return (pixelDataLen & 1L) == 0L ? pixelDataLen : pixelDataLen + 1L;
    }

    public int maxPossibleStoredValue() {
        return this.signed ? (1 << this.bs - 1) - 1 : (1 << this.bs) - 1;
    }

    public int minPossibleStoredValue() {
        return this.signed ? -this.maxPossibleStoredValue() - 1 : 0;
    }

    public int getBitsAllocated() {
        return this.ba;
    }

    public int getBitsStored() {
        return this.bs;
    }

    public boolean isByPlane() {
        return this.byPlane;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getCols() {
        return this.cols;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public int getHighBit() {
        return this.hb;
    }

    public int getNumberOfFrames() {
        return this.nf;
    }

    public int getPixelDataVr() {
        return this.pixelDataVr;
    }

    public String getPmi() {
        return this.pmi;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSamplesPerFrame() {
        return this.samplesPerFrame;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getSize() {
        return this.size;
    }

    public int getSamplesPerPixel() {
        return this.spp;
    }

    protected Object clone() throws CloneNotSupportedException {
        return new PixelDataDescription(this.cols, this.rows, this.nf, this.ba, this.bs, this.hb, this.spp, this.signed, this.byPlane, this.pmi, this.byteOrder, this.pixelDataVr);
    }
}

