/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import org.hibernate.util.StringHelper;

public class HibernateMappingGlobalSettings {
    private String schemaName;
    private String catalogName;
    private String defaultCascade;
    private String defaultPackage;
    private String defaultAccess;
    private boolean autoImport = true;
    private boolean defaultLazy = true;

    public boolean hasNonDefaultSettings() {
        return this.hasDefaultPackage() || this.hasSchemaName() || this.hasCatalogName() || this.hasNonDefaultCascade() || this.hasNonDefaultAccess() || !this.isDefaultLazy() || !this.isAutoImport();
    }

    public boolean hasDefaultPackage() {
        return !StringHelper.isEmpty((String)this.defaultPackage);
    }

    public boolean hasSchemaName() {
        return !StringHelper.isEmpty((String)this.schemaName);
    }

    public boolean hasCatalogName() {
        return !StringHelper.isEmpty((String)this.catalogName);
    }

    public boolean hasNonDefaultCascade() {
        return !StringHelper.isEmpty((String)this.defaultCascade) ? !"none".equals(this.defaultCascade) : false;
    }

    public boolean hasNonDefaultAccess() {
        return !StringHelper.isEmpty((String)this.defaultAccess) ? !"property".equals(this.defaultAccess) : false;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDefaultCascade() {
        return this.defaultCascade;
    }

    public String getDefaultAccess() {
        return this.defaultAccess;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public boolean isDefaultLazy() {
        return this.defaultLazy;
    }

    public boolean isAutoImport() {
        return this.autoImport;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setDefaultCascade(String defaultCascade) {
        this.defaultCascade = defaultCascade;
    }

    public void setDefaultAccess(String defaultAccess) {
        this.defaultAccess = defaultAccess;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public void setAutoImport(boolean autoImport) {
        this.autoImport = autoImport;
    }

    public void setDefaultLazy(boolean defaultLazy) {
        this.defaultLazy = defaultLazy;
    }
}

