/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.ContainerContent;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.IconImage;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.SOPInstanceRef;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

class ContainerContentImpl
extends NamedContentImpl
implements ContainerContent {
    private boolean separate;

    ContainerContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, boolean separate) {
        super(owner, obsDateTime, template, name);
        this.separate = separate;
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        return new ContainerContentImpl(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.separate);
    }

    public String toString() {
        return this.prompt().append(this.separate ? "separate" : "continuous").toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.CONTAINER;
    }

    public final boolean isSeparate() {
        return this.separate;
    }

    public final void setSeparate(boolean separate) {
        this.separate = separate;
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        ds.putCS(4235344, this.separate ? "SEPARATE" : "CONTINUOUS");
    }

    public void insertCompositeContent(Code name, SOPInstanceRef refSOP) {
        this.appendChild(Content.RelationType.CONTAINS, this.owner.createCompositeContent(null, null, name, refSOP));
        this.owner.addCurrentEvidence(refSOP);
    }

    public void insertImageContent(Code name, SOPInstanceRef refSOP, int[] frameNumbers, SOPInstanceRef refPresentationSOP, IconImage iconImage) {
        this.appendChild(Content.RelationType.CONTAINS, this.owner.createImageContent(null, null, name, refSOP, frameNumbers, refPresentationSOP, iconImage));
        this.owner.addCurrentEvidence(refSOP);
        if (refPresentationSOP != null) {
            this.owner.addCurrentEvidence(refPresentationSOP);
        }
    }

    public void insertWaveformContent(Code name, SOPInstanceRef refSOP, int[] channelNumbers) {
        this.appendChild(Content.RelationType.CONTAINS, this.owner.createWaveformContent(null, null, name, refSOP, channelNumbers));
        this.owner.addCurrentEvidence(refSOP);
    }
}

