/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.sendmml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import open.dolphin.client.IMainService;
import open.dolphin.client.IMainWindow;
import open.dolphin.client.MmlMessageEvent;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;

public class SendMmlImpl
implements IMainService {
    private String csgwPath;
    private String encoding;
    private LinkedBlockingQueue queue;
    private Kicker kicker;
    private Thread sendThread;
    private IMainWindow context;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    public String getCSGWPath() {
        return this.csgwPath;
    }

    public void setCSGWPath(String val) {
        this.csgwPath = val;
        File directory = new File(this.csgwPath);
        if (!directory.exists()) {
            if (directory.mkdirs()) {
                LogWriter.debug(this.getClass(), "MML\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u5148\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f");
            } else {
                LogWriter.debug(this.getClass(), "MML\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u5148\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093");
            }
        }
    }

    @Override
    public void stop() {
        try {
            Thread moribund = this.sendThread;
            this.sendThread = null;
            moribund.interrupt();
            this.logDump();
            LogWriter.info(this.getClass(), "Send MML stopped");
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            LogWriter.warn(this.getClass(), "Exception while stopping the send MML");
            LogWriter.warn(this.getClass(), e.getMessage());
        }
    }

    @Override
    public void start() {
        this.setCSGWPath(GlobalVariables.getCSGWPath());
        this.encoding = GlobalVariables.getMMLEncoding();
        this.queue = new LinkedBlockingQueue();
        this.kicker = new Kicker();
        this.sendThread = new Thread(this.kicker);
        this.sendThread.start();
        LogWriter.info(SendMmlImpl.class, "Send MML statered with CSGW = " + this.getCSGWPath());
    }

    public void mmlMessageEvent(MmlMessageEvent e) {
        this.queue.offer(e);
    }

    public Object getMML() throws InterruptedException {
        return this.queue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDump() {
        LinkedBlockingQueue linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            int size = this.queue.size();
            if (size != 0) {
                for (int i = 0; i < size; ++i) {
                    try {
                        MmlMessageEvent evt = (MmlMessageEvent)this.queue.take();
                        continue;
                    }
                    catch (Exception e) {
                        LogWriter.error(this.getClass(), e);
                    }
                }
            }
        }
    }

    protected String getCSGWPathname(String fileName, String ext) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.csgwPath);
        buf.append(File.separator);
        buf.append(fileName);
        buf.append(".");
        buf.append(ext);
        return buf.toString();
    }

    protected class Kicker
    implements Runnable {
        protected Kicker() {
        }

        @Override
        public void run() {
            Thread thisThread = Thread.currentThread();
            BufferedOutputStream writer = null;
            while (thisThread == SendMmlImpl.this.sendThread) {
                try {
                    MmlMessageEvent mevt = (MmlMessageEvent)SendMmlImpl.this.getMML();
                    LogWriter.debug(this.getClass(), "MML\u30d5\u30a1\u30a4\u30eb\u3092\u30b3\u30f3\u30b7\u30e5\u30fc\u30e0\u3057\u307e\u3057\u305f");
                    String groupId = mevt.getGroupId();
                    String instance = mevt.getMmlInstance();
                    List<SchemaModel> schemas = mevt.getSchema();
                    String dest = SendMmlImpl.this.getCSGWPathname(groupId, "xml");
                    String temp = SendMmlImpl.this.getCSGWPathname(groupId, "xml.tmp");
                    File f = new File(temp);
                    writer = new BufferedOutputStream(new FileOutputStream(f));
                    byte[] bytes = instance.getBytes(SendMmlImpl.this.encoding);
                    writer.write(bytes);
                    writer.flush();
                    writer.close();
                    f.renameTo(new File(dest));
                    LogWriter.info(SendMmlImpl.class, "MML\u30d5\u30a1\u30a4\u30eb\u3092\u66f8\u304d\u8fbc\u307f\u307e\u3057\u305f");
                    if (schemas == null) continue;
                    for (SchemaModel schema : schemas) {
                        dest = SendMmlImpl.this.csgwPath + File.separator + schema.getExtRef().getHref();
                        temp = dest + ".tmp";
                        f = new File(temp);
                        writer = new BufferedOutputStream(new FileOutputStream(f));
                        writer.write(schema.getJpegBytes());
                        writer.flush();
                        writer.close();
                        f.renameTo(new File(dest));
                        LogWriter.debug(this.getClass(), "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u3092\u66f8\u304d\u8fbc\u307f\u307e\u3057\u305f");
                    }
                }
                catch (IOException e) {
                    LogWriter.error(this.getClass(), e);
                    LogWriter.warn(this.getClass(), "IOException while send MML");
                    LogWriter.warn(this.getClass(), e.getMessage());
                }
                catch (InterruptedException ie) {
                    LogWriter.warn(this.getClass(), "InterruptedException while send MML");
                    break;
                }
            }
        }
    }
}

