/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import open.dolphin.client.editor.diagnosis.DiagnosisTablePanel;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.order.RegisteredDiagnosisTransferable;
import open.dolphin.table.ObjectTableModel;

public class RegisteredDiagnosisTransferHandler
extends TransferHandler {
    private DataFlavor registeredDiagnosisFlavor = RegisteredDiagnosisTransferable.registeredDiagnosisFlavor;
    private JTable sourceTable;
    private boolean shouldRemove;
    private int fromIndex;
    private int toIndex;
    private DiagnosisTablePanel editor;

    public RegisteredDiagnosisTransferHandler(DiagnosisTablePanel editor) {
        this.editor = editor;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.sourceTable = (JTable)c;
        ObjectTableModel tableModel = (ObjectTableModel)this.sourceTable.getModel();
        this.fromIndex = this.sourceTable.getSelectedRow();
        RegisteredDiagnosisModel dragItem = (RegisteredDiagnosisModel)tableModel.getObject(this.fromIndex);
        return dragItem != null ? new RegisteredDiagnosisTransferable(dragItem) : null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            try {
                JTable dropTable = (JTable)c;
                ObjectTableModel tableModel = (ObjectTableModel)dropTable.getModel();
                this.toIndex = dropTable.getSelectedRow();
                boolean bl = this.shouldRemove = dropTable == this.sourceTable;
                if (this.shouldRemove) {
                    tableModel.moveRow(this.fromIndex, this.toIndex);
                    if (this.editor != null) {
                        this.editor.redraw();
                    }
                }
                this.sourceTable.getSelectionModel().setSelectionInterval(this.toIndex, this.toIndex);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action != 2 || this.shouldRemove) {
            // empty if block
        }
        this.shouldRemove = false;
        this.fromIndex = -1;
        this.toIndex = -1;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        JTable dropTable = (JTable)c;
        ObjectTableModel tableModel = (ObjectTableModel)dropTable.getModel();
        if (tableModel.getObject(dropTable.getSelectedRow()) != null) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!this.registeredDiagnosisFlavor.equals(flavors[i])) continue;
                return true;
            }
        }
        return false;
    }
}

