/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import open.dolphin.client.IStampEditorDialog;
import open.dolphin.client.editor.stamp.StampModelEditor;
import open.dolphin.order.ClaimConst;
import open.dolphin.order.MasterSetPanel;
import open.dolphin.order.RadItemTablePanel;

public final class LRadiologyStampEditor
extends StampModelEditor {
    private static final long serialVersionUID = 2467212598346800512L;
    private RadItemTablePanel testTable;
    private MasterSetPanel masterPanel;

    public LRadiologyStampEditor(IStampEditorDialog context, MasterSetPanel masterPanel) {
        this.setContext(context);
        this.masterPanel = masterPanel;
        this.initCustomComponents();
    }

    @Override
    public void start() {
        ClaimConst.ClaimSpec spec = ClaimConst.ClaimSpec.RADIOLOGY;
        this.masterPanel.setSearchClass(spec.getSearchCode());
        this.masterPanel.setRadLocationEnabled(true);
        this.masterPanel.startTest(this.testTable);
    }

    private void initCustomComponents() {
        ClaimConst.ClaimSpec spec = ClaimConst.ClaimSpec.RADIOLOGY;
        this.testTable = new RadItemTablePanel(this);
        this.testTable.setOrderName(spec.getName());
        this.testTable.setClassCode(spec.getClassCode());
        this.testTable.setClassCodeId("Claim007");
        this.testTable.setSubClassCodeId("Claim003");
        this.setTitle(spec.getName());
        Border b = BorderFactory.createEtchedBorder();
        this.testTable.setBorder(BorderFactory.createTitledBorder(b, spec.getName()));
        this.setLayout(new BorderLayout());
        this.add((Component)this.testTable, "Center");
    }

    @Override
    public Object getValue() {
        return this.testTable.getValue();
    }

    @Override
    public void setValue(Object val) {
        this.testTable.setValue(val);
    }

    @Override
    public void dispose() {
        this.masterPanel.stopTest(this.testTable);
    }

    @Override
    public void clear() {
        this.testTable.clear();
    }
}

