/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.persistence.Transient;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.utils.CombinedStringParser;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PatientVisitModel
extends InfoModel {
    public static final DataFlavor PVT_FLAVOR = new DataFlavor(PatientVisitModel.class, "Patient Visit");
    public static DataFlavor[] flavors = new DataFlavor[]{PVT_FLAVOR};
    private long id;
    private PatientModel patient;
    private String facilityId;
    private String pvtDate;
    private String department;
    private int status;
    private String insuranceUid;
    @Transient
    private String appointment;
    @Transient
    private int number;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public PatientModel getPatient() {
        return this.patient;
    }

    public void setAppointment(String appointment) {
        this.appointment = appointment;
    }

    public String getAppointment() {
        return this.appointment;
    }

    public void setPatient(PatientModel patient) {
        this.patient = patient;
    }

    public String getFacilityId() {
        return this.facilityId;
    }

    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public String getPvtDate() {
        return this.pvtDate;
    }

    public void setPvtDate(String pvtDate) {
        this.pvtDate = pvtDate;
    }

    public String getPvtDateTrimTime() {
        return ModelUtils.trimTime(this.pvtDate);
    }

    public String getPvtDateTrimDate() {
        return ModelUtils.trimDate(this.pvtDate);
    }

    public String getDepartmentName() {
        String[] tokens = this.tokenizeDept(this.department);
        return tokens[0];
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getCategory() {
        String[] tokens = this.tokenizeDept(this.department);
        return tokens[5];
    }

    public String getDepartmentCode() {
        String[] tokens = this.tokenizeDept(this.department);
        return tokens[1];
    }

    public String getAssignedDoctorName() {
        String[] tokens = this.tokenizeDept(this.department);
        return tokens[2];
    }

    public String getAssignedDoctorId() {
        String[] tokens = this.tokenizeDept(this.department);
        return tokens[3];
    }

    public String getJmariCode() {
        String[] tokens = this.tokenizeDept(this.department);
        return tokens[4];
    }

    public String getDeptNoTokenize() {
        return this.department;
    }

    private String[] tokenizeDept(String dept) {
        CombinedStringParser line = new CombinedStringParser(',', dept);
        String[] result = new String[line.size()];
        for (int index = 0; index < line.size(); ++index) {
            result[index] = line.get(index);
        }
        return result;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Integer getState() {
        return new Integer(this.status);
    }

    public String getPatientId() {
        return this.getPatient().getPatientId();
    }

    public String getPatientName() {
        return this.getPatient().getFullName();
    }

    public String getPatientGenderDesc() {
        return ModelUtils.getGenderDesc(this.getPatient().getGender());
    }

    public String getMemo() {
        return ModelUtils.getMemo(this.getPatient().getMemo());
    }

    public String getPatientAgeBirthday() {
        return ModelUtils.getAgeBirthday(this.getPatient().getBirthday());
    }

    public String getPatientBirthday() {
        return this.getPatient().getBirthday();
    }

    public String getPatientAge() {
        return ModelUtils.getAge(this.getPatient().getBirthday());
    }

    public String getInsuranceUid() {
        return this.insuranceUid;
    }

    public void setInsuranceUid(String insuranceuid) {
        this.insuranceUid = insuranceuid;
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        return df.equals(PVT_FLAVOR);
    }

    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (df.equals(PVT_FLAVOR)) {
            return this;
        }
        throw new UnsupportedFlavorException(df);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

