/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import open.dolphin.client.IChart;

public abstract class DBTask<T> {
    protected IChart context;

    public DBTask(IChart context) {
        this.context = context;
    }

    protected abstract T doInBackground() throws Exception;

    protected void succeeded(T result) {
    }

    protected void cancelled() {
    }

    protected void timeout() {
    }

    protected void failed(Throwable cause) {
    }

    private void startProgress() {
    }

    private void stopProgress() {
    }

    private void taskDone(T result) {
        this.succeeded(result);
    }

    private void taskFailed(Throwable cause) {
        this.failed(cause);
    }

    private void taskTimeout() {
        this.timeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.startProgress();
            this.taskDone(this.doInBackground());
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException ex) {
            this.taskFailed(ex);
        }
        catch (TimeoutException ex) {
            this.taskTimeout();
        }
        catch (Exception ex) {
            this.taskFailed(ex);
        }
        finally {
            this.stopProgress();
        }
    }
}

