/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.settings;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.project.GlobalVariables;

public class SendMmlSettingPanel
extends JPanel
implements IAbstractSettingPanel {
    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    protected IAbstractSettingPanel.State state = IAbstractSettingPanel.State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private static final String ID = "mmlSetting";
    private static final String TITLE = "MML\u51fa\u529b";
    private static final String ICON = "cd_24.gif";
    private MmlModel model;
    private StateMgr stateMgr;
    private ButtonGroup bg1;
    private ButtonGroup bg2;
    private JPanel content;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JRadioButton mml23;
    private JRadioButton mml3;
    private JPanel panel1;
    private JPanel panel2;
    private JComboBox protocolCombo;
    private JRadioButton sendMML;
    private JRadioButton sendNoMML;
    private JTextField shareDirectory;
    private JTextField uploaderServer;

    public SendMmlSettingPanel() {
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
        this.setId(ID);
        this.setTitle(TITLE);
        this.setIcon(ICON);
    }

    private void initComponents() {
        this.bg1 = new ButtonGroup();
        this.bg2 = new ButtonGroup();
        this.content = new JPanel();
        this.panel1 = new JPanel();
        this.sendMML = new JRadioButton();
        this.sendNoMML = new JRadioButton();
        this.label1 = new JLabel();
        this.panel2 = new JPanel();
        this.mml23 = new JRadioButton();
        this.mml3 = new JRadioButton();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.protocolCombo = new JComboBox();
        this.uploaderServer = new JTextField();
        this.label4 = new JLabel();
        this.shareDirectory = new JTextField();
        this.setLayout(new GridLayout(1, 0));
        this.content.setBorder(BorderFactory.createTitledBorder("MML(XML)\u51fa\u529b"));
        this.content.setName("content");
        this.panel1.setName("panel1");
        this.panel1.setLayout(new FlowLayout(0, 0, 5));
        this.bg1.add(this.sendMML);
        this.sendMML.setText("\u3059\u308b");
        this.sendMML.setName("sendMML");
        this.sendMML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SendMmlSettingPanel.this.sendMMLActionPerformed(evt);
            }
        });
        this.panel1.add(this.sendMML);
        this.bg1.add(this.sendNoMML);
        this.sendNoMML.setText("\u3057\u306a\u3044");
        this.sendNoMML.setName("sendNoMML");
        this.sendNoMML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SendMmlSettingPanel.this.sendNoMMLActionPerformed(evt);
            }
        });
        this.panel1.add(this.sendNoMML);
        this.label1.setText("MML \u30d0\u30fc\u30b8\u30e7\u30f3:");
        this.label1.setHorizontalTextPosition(4);
        this.label1.setName("label1");
        this.panel2.setName("panel2");
        this.panel2.setLayout(new FlowLayout(0, 0, 5));
        this.bg2.add(this.mml23);
        this.mml23.setText("2.3");
        this.mml23.setName("mml23");
        this.panel2.add(this.mml23);
        this.bg2.add(this.mml3);
        this.mml3.setText("3.0");
        this.mml3.setName("mml3");
        this.panel2.add(this.mml3);
        this.label2.setText("\u9001\u4fe1\u30d7\u30ed\u30c8\u30b3\u30eb:");
        this.label2.setHorizontalTextPosition(4);
        this.label2.setName("label2");
        this.label3.setText("\u9001\u4fe1\u30b5\u30fc\u30d0\u30a2\u30c9\u30ec\u30b9:");
        this.label3.setHorizontalTextPosition(4);
        this.label3.setName("label3");
        this.protocolCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Samba"}));
        this.protocolCombo.setName("protocolCombo");
        this.uploaderServer.setColumns(10);
        this.uploaderServer.setName("uploaderServer");
        this.label4.setText("\u9001\u4fe1\u5148\u30c7\u30a3\u30ec\u30af\u30c8\u30ea:");
        this.label4.setHorizontalTextPosition(4);
        this.label4.setName("label4");
        this.shareDirectory.setColumns(10);
        this.shareDirectory.setName("shareDirectory");
        GroupLayout contentLayout = new GroupLayout(this.content);
        this.content.setLayout(contentLayout);
        contentLayout.setHorizontalGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contentLayout.createSequentialGroup().addGap(89, 89, 89).addGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.label1).addComponent(this.label4).addComponent(this.label3).addComponent(this.label2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.shareDirectory).addComponent(this.protocolCombo, -2, -1, -2).addComponent(this.panel1, -1, -1, Short.MAX_VALUE).addComponent(this.panel2, -1, 100, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, contentLayout.createSequentialGroup().addComponent(this.uploaderServer, -2, -1, -2).addGap(4, 4, 4))).addGap(205, 205, 205)));
        contentLayout.setVerticalGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contentLayout.createSequentialGroup().addContainerGap().addComponent(this.panel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contentLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.label1)).addGroup(contentLayout.createSequentialGroup().addComponent(this.panel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.protocolCombo, -2, -1, -2).addComponent(this.label2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label3).addComponent(this.uploaderServer, -2, 19, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label4).addComponent(this.shareDirectory, -2, -1, -2)).addGap(194, 194, 194)));
        this.add(this.content);
    }

    private void sendMMLActionPerformed(ActionEvent evt) {
        this.stateMgr.controlSendMml();
    }

    private void sendNoMMLActionPerformed(ActionEvent evt) {
        this.stateMgr.controlSendMml();
    }

    @Override
    public void start() {
        this.model = new MmlModel();
        this.model.populate();
    }

    @Override
    public void save() {
        this.model.restore();
    }

    public void connect() {
        this.stateMgr = new StateMgr();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SendMmlSettingPanel.this.stateMgr.checkState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SendMmlSettingPanel.this.stateMgr.checkState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SendMmlSettingPanel.this.stateMgr.checkState();
            }
        };
        this.uploaderServer.getDocument().addDocumentListener(dl);
        this.shareDirectory.getDocument().addDocumentListener(dl);
        this.uploaderServer.addFocusListener(AutoRomanListener.getInstance());
        this.shareDirectory.addFocusListener(AutoRomanListener.getInstance());
        this.stateMgr.controlSendMml();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public ProjectSettingDialog getContext() {
        return this.context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener("stateProp", context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return this.loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        this.loginState = login;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    @Override
    public void setState(IAbstractSettingPanel.State state) {
        this.state = state;
        this.boundSupport.firePropertyChange("stateProp", null, (Object)this.state);
    }

    @Override
    public IAbstractSettingPanel.State getState() {
        return this.state;
    }

    class StateMgr {
        StateMgr() {
        }

        public void checkState() {
            IAbstractSettingPanel.State newState;
            IAbstractSettingPanel.State state = newState = this.isValid() ? IAbstractSettingPanel.State.VALID_STATE : IAbstractSettingPanel.State.INVALID_STATE;
            if (newState != SendMmlSettingPanel.this.state) {
                SendMmlSettingPanel.this.setState(newState);
            }
        }

        public void controlSendMml() {
            boolean b = SendMmlSettingPanel.this.sendMML.isSelected();
            SendMmlSettingPanel.this.mml3.setEnabled(b);
            SendMmlSettingPanel.this.mml23.setEnabled(b);
            SendMmlSettingPanel.this.protocolCombo.setEnabled(b);
            SendMmlSettingPanel.this.uploaderServer.setEnabled(b);
            SendMmlSettingPanel.this.shareDirectory.setEnabled(b);
            this.checkState();
        }

        protected boolean isValid() {
            if (SendMmlSettingPanel.this.sendMML.isSelected()) {
                boolean uploadAddrOk = !SendMmlSettingPanel.this.uploaderServer.getText().trim().equals("");
                boolean shareOk = !SendMmlSettingPanel.this.shareDirectory.getText().trim().equals("");
                return uploadAddrOk && shareOk;
            }
            return true;
        }
    }

    class MmlModel {
        MmlModel() {
        }

        public void populate() {
            boolean sending = GlobalVariables.getSendMML();
            SendMmlSettingPanel.this.sendNoMML.setSelected(!sending);
            SendMmlSettingPanel.this.sendMML.setSelected(sending);
            String val = GlobalVariables.getMMLVersion();
            if (val != null && val.startsWith("2")) {
                SendMmlSettingPanel.this.mml23.setSelected(true);
            } else {
                SendMmlSettingPanel.this.mml3.setSelected(true);
            }
            val = GlobalVariables.getUploaderIPAddress();
            if (val != null && !val.equals("")) {
                SendMmlSettingPanel.this.uploaderServer.setText(val);
            }
            if ((val = GlobalVariables.getUploadShareDirectory()) != null && !val.equals("")) {
                SendMmlSettingPanel.this.shareDirectory.setText(val);
            }
            SendMmlSettingPanel.this.connect();
        }

        public void restore() {
            boolean b = SendMmlSettingPanel.this.sendMML.isSelected();
            GlobalVariables.setSendMML(b);
            String val = SendMmlSettingPanel.this.mml3.isSelected() ? "300" : "230";
            GlobalVariables.setMMLVersion(val);
            val = SendMmlSettingPanel.this.uploaderServer.getText().trim();
            if (!val.equals("")) {
                GlobalVariables.setUploaderIPAddress(val);
            }
            if (!(val = SendMmlSettingPanel.this.shareDirectory.getText().trim()).equals("")) {
                GlobalVariables.setUploadShareDirectory(val);
            }
        }
    }
}

