/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.settings;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.container.NameValuePair;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;

public class AreaNetWorkSettingPanel
extends JPanel
implements IAbstractSettingPanel {
    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    protected IAbstractSettingPanel.State state = IAbstractSettingPanel.State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private NameValuePair[] networkProjects;
    private NetworkModel model;
    private StateMgr stateMgr;
    private JComboBox areaNetworkCombo;
    private ButtonGroup bg;
    private JPanel content;
    private JTextField creatorIdField;
    private JTextField facilityIdField;
    private JPanel groupPanel;
    private JRadioButton joinAreaNetwork;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JRadioButton noJoinAreaNetwork;
    private JPanel panel1;

    public AreaNetWorkSettingPanel() {
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
        this.setId("areaNetwork");
        this.setTitle("\u5730\u57df\u9023\u643a");
        this.setIcon("web_24.gif");
    }

    private void initComponents() {
        this.bg = new ButtonGroup();
        this.content = new JPanel();
        this.panel1 = new JPanel();
        this.joinAreaNetwork = new JRadioButton();
        this.noJoinAreaNetwork = new JRadioButton();
        this.groupPanel = new JPanel();
        this.label1 = new JLabel();
        this.areaNetworkCombo = new JComboBox();
        this.label2 = new JLabel();
        this.facilityIdField = new JTextField();
        this.label3 = new JLabel();
        this.creatorIdField = new JTextField();
        this.setLayout(new GridLayout(1, 0));
        this.content.setBorder(BorderFactory.createTitledBorder("\u5730\u57df\u9023\u643a"));
        this.content.setName("content");
        this.panel1.setName("panel1");
        this.panel1.setLayout(new FlowLayout(0, 0, 5));
        this.bg.add(this.joinAreaNetwork);
        this.joinAreaNetwork.setText("\u53c2\u52a0\u3059\u308b");
        this.joinAreaNetwork.setName("joinAreaNetwork");
        this.joinAreaNetwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AreaNetWorkSettingPanel.this.joinAreaNetworkActionPerformed(evt);
            }
        });
        this.panel1.add(this.joinAreaNetwork);
        this.bg.add(this.noJoinAreaNetwork);
        this.noJoinAreaNetwork.setText("\u53c2\u52a0\u3057\u306a\u3044");
        this.noJoinAreaNetwork.setName("noJoinAreaNetwork");
        this.noJoinAreaNetwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AreaNetWorkSettingPanel.this.noJoinAreaNetworkActionPerformed(evt);
            }
        });
        this.panel1.add(this.noJoinAreaNetwork);
        this.groupPanel.setName("groupPanel");
        this.label1.setText("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8:");
        this.label1.setName("label1");
        this.areaNetworkCombo.setName("areaNetworkCombo");
        this.areaNetworkCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AreaNetWorkSettingPanel.this.areaNetworkComboItemStateChanged(evt);
            }
        });
        this.label2.setText("\u9023\u643a\u7528\u533b\u7642\u6a5f\u95a2ID:");
        this.label2.setName("label2");
        this.facilityIdField.setColumns(20);
        this.facilityIdField.setName("facilityIdField");
        this.label3.setText("\u9023\u643a\u7528\u30e6\u30fc\u30b6ID:");
        this.label3.setName("label3");
        this.creatorIdField.setColumns(20);
        this.creatorIdField.setName("creatorIdField");
        GroupLayout groupPanelLayout = new GroupLayout(this.groupPanel);
        this.groupPanel.setLayout(groupPanelLayout);
        groupPanelLayout.setHorizontalGroup(groupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupPanelLayout.createSequentialGroup().addGroup(groupPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.label1).addComponent(this.label3).addGroup(groupPanelLayout.createSequentialGroup().addComponent(this.label2).addGap(3, 3, 3))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.creatorIdField, -2, -1, -2).addComponent(this.facilityIdField, -2, -1, -2).addComponent(this.areaNetworkCombo, -2, 109, -2))));
        groupPanelLayout.setVerticalGroup(groupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupPanelLayout.createSequentialGroup().addGroup(groupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label1).addComponent(this.areaNetworkCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2, -2, 17, -2).addComponent(this.facilityIdField, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label3).addComponent(this.creatorIdField, -2, 17, -2))));
        GroupLayout contentLayout = new GroupLayout(this.content);
        this.content.setLayout(contentLayout);
        contentLayout.setHorizontalGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contentLayout.createSequentialGroup().addGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contentLayout.createSequentialGroup().addGap(163, 163, 163).addComponent(this.panel1, -2, -1, -2)).addGroup(contentLayout.createSequentialGroup().addGap(86, 86, 86).addComponent(this.groupPanel, -2, -1, -2))).addContainerGap(101, Short.MAX_VALUE)));
        contentLayout.setVerticalGroup(contentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contentLayout.createSequentialGroup().addComponent(this.panel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.groupPanel, -2, -1, -2).addContainerGap(195, Short.MAX_VALUE)));
        this.add(this.content);
    }

    private void areaNetworkComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.stateMgr.checkState();
        }
    }

    private void noJoinAreaNetworkActionPerformed(ActionEvent evt) {
        this.stateMgr.controlJoinArea();
    }

    private void joinAreaNetworkActionPerformed(ActionEvent evt) {
        this.stateMgr.controlJoinArea();
    }

    private void initCustomComponents() {
        this.networkProjects = GlobalConstants.getNameValuePair("areaNetwork.list");
        this.areaNetworkCombo.setModel(new DefaultComboBoxModel<NameValuePair>(this.networkProjects));
    }

    private void connect() {
        this.stateMgr = new StateMgr();
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AreaNetWorkSettingPanel.this.stateMgr.checkState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AreaNetWorkSettingPanel.this.stateMgr.checkState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AreaNetWorkSettingPanel.this.stateMgr.checkState();
            }
        };
        this.facilityIdField.getDocument().addDocumentListener(dl);
        this.creatorIdField.getDocument().addDocumentListener(dl);
        this.facilityIdField.addFocusListener(AutoRomanListener.getInstance());
        this.creatorIdField.addFocusListener(AutoRomanListener.getInstance());
        this.stateMgr.controlJoinArea();
    }

    @Override
    public void start() {
        this.initCustomComponents();
        this.connect();
        this.model = new NetworkModel();
        this.model.populate();
    }

    @Override
    public void save() {
        this.model.restore();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public ProjectSettingDialog getContext() {
        return this.context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener("stateProp", context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return this.loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        this.loginState = login;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    @Override
    public void setState(IAbstractSettingPanel.State state) {
        this.state = state;
        this.boundSupport.firePropertyChange("stateProp", null, (Object)this.state);
    }

    @Override
    public IAbstractSettingPanel.State getState() {
        return this.state;
    }

    class StateMgr {
        StateMgr() {
        }

        public void checkState() {
            IAbstractSettingPanel.State newState;
            IAbstractSettingPanel.State state = newState = this.isValid() ? IAbstractSettingPanel.State.VALID_STATE : IAbstractSettingPanel.State.INVALID_STATE;
            if (newState != AreaNetWorkSettingPanel.this.state) {
                AreaNetWorkSettingPanel.this.setState(newState);
            }
        }

        public void controlJoinArea() {
            AreaNetWorkSettingPanel.this.groupPanel.setEnabled(AreaNetWorkSettingPanel.this.joinAreaNetwork.isSelected());
            AreaNetWorkSettingPanel.this.areaNetworkCombo.setEnabled(AreaNetWorkSettingPanel.this.joinAreaNetwork.isSelected());
            AreaNetWorkSettingPanel.this.creatorIdField.setEnabled(AreaNetWorkSettingPanel.this.joinAreaNetwork.isSelected());
            AreaNetWorkSettingPanel.this.facilityIdField.setEnabled(AreaNetWorkSettingPanel.this.joinAreaNetwork.isSelected());
            this.checkState();
        }

        private boolean isValid() {
            if (AreaNetWorkSettingPanel.this.joinAreaNetwork.isSelected()) {
                boolean projOk = AreaNetWorkSettingPanel.this.areaNetworkCombo.getSelectedIndex() != 0;
                boolean facilityOk = !AreaNetWorkSettingPanel.this.facilityIdField.getText().trim().equals("");
                boolean creatorOk = !AreaNetWorkSettingPanel.this.creatorIdField.getText().trim().equals("");
                return projOk && facilityOk && creatorOk;
            }
            return true;
        }
    }

    class NetworkModel {
        NetworkModel() {
        }

        public void populate() {
            boolean join = GlobalVariables.getJoinAreaNetwork();
            AreaNetWorkSettingPanel.this.joinAreaNetwork.setSelected(join);
            AreaNetWorkSettingPanel.this.noJoinAreaNetwork.setSelected(!join);
            String val = GlobalVariables.getAreaNetworkName();
            if (val != null) {
                for (int i = 0; i < AreaNetWorkSettingPanel.this.networkProjects.length; ++i) {
                    if (!val.equals(AreaNetWorkSettingPanel.this.networkProjects[i].getValue())) continue;
                    AreaNetWorkSettingPanel.this.areaNetworkCombo.setSelectedIndex(i);
                    break;
                }
            }
            val = (val = GlobalVariables.getAreaNetworkFacilityId()) != null ? val : "";
            AreaNetWorkSettingPanel.this.facilityIdField.setText(val);
            val = GlobalVariables.getAreaNetworkCreatorId();
            val = val != null ? val : "";
            AreaNetWorkSettingPanel.this.creatorIdField.setText(val);
            if (join) {
                AreaNetWorkSettingPanel.this.areaNetworkCombo.setEnabled(true);
                AreaNetWorkSettingPanel.this.facilityIdField.setEnabled(true);
                AreaNetWorkSettingPanel.this.creatorIdField.setEnabled(true);
            }
        }

        public void restore() {
            boolean join = AreaNetWorkSettingPanel.this.joinAreaNetwork.isSelected();
            GlobalVariables.setJoinAreaNetwork(join);
            NameValuePair pair = (NameValuePair)AreaNetWorkSettingPanel.this.areaNetworkCombo.getSelectedItem();
            GlobalVariables.setAreaNetworkName(pair.getValue());
            String val = AreaNetWorkSettingPanel.this.facilityIdField.getText().trim();
            if (!val.equals("")) {
                GlobalVariables.setAreaNetworkFacilityId(val);
            }
            if (!(val = AreaNetWorkSettingPanel.this.creatorIdField.getText().trim()).equals("")) {
                GlobalVariables.setAreaNetworkCreatorId(val);
            }
        }
    }
}

