/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.patientsearch;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.BlockGlass;
import open.dolphin.client.CalendarCardPanel;
import open.dolphin.client.IMainCommandAccepter;
import open.dolphin.client.IMainComponent;
import open.dolphin.client.IMainWindow;
import open.dolphin.client.patientsearch.AddressTipsTable;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.delegater.remote.RemotePVTDelegater;
import open.dolphin.delegater.remote.RemotePatientDelegater;
import open.dolphin.dto.PatientSearchSpec;
import open.dolphin.helper.KeyBlocker;
import open.dolphin.infomodel.AllergyModel;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.PatientMemoModel;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.queries.DolphinQuery;
import open.dolphin.table.ObjectReflectTableModel;
import open.dolphin.table.OddEvenRowRenderer;
import open.dolphin.utils.CombinedStringParser;
import open.dolphin.utils.StringTool;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.layout.GroupLayout;

public class PatientSearchView
extends JPanel
implements IMainComponent {
    private String name;
    private String icon;
    private IMainWindow context;
    private int number = 10000;
    private final String NAME = "\u60a3\u8005\u691c\u7d22";
    private final String[] COLUMN_NAMES = new String[]{"ID", "\u6c0f\u540d", "\u30ab\u30ca", "\u6027\u5225", "\u751f\u5e74\u6708\u65e5"};
    private final int START_NUM_ROWS = 0;
    private final String[] METHOD_NAMES = new String[]{"getPatientId", "getFullName", "getKanaName", "getGenderDesc", "getAgeBirthday"};
    private final int[] COLUMN_WIDTH = new int[]{80, 120, 120, 30, 80};
    private final String UNSUITABLE_CHAR = "\u691c\u7d22\u306b\u9069\u3055\u306a\u3044\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002";
    private PatientModel selectedPatient;
    private boolean isAgeDisplayed;
    private final int AGE_COLUMN = 4;
    private final String[] AGE_METHOD = new String[]{"getAgeBirthday", "getBirthday"};
    private KeyBlocker keyBlocker;
    private int sortItemValue;
    private Application app;
    private ApplicationContext appCtx;
    private TaskMonitor taskMonitor;
    private JButton allergySearchButton;
    private JCheckBox autoIme;
    private JLabel cntLbl;
    private JLabel dateLbl;
    private JButton historySearchButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JButton karteSearchButton;
    private JTextField keywordFld;
    private JButton memoSearchButton;
    private JProgressBar progressBar;
    private JComboBox sortItem;
    private JTable table;

    public PatientSearchView() {
        this.initComponents();
        this.jScrollPane1.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.name = "\u60a3\u8005\u691c\u7d22";
        this.appCtx = GlobalConstants.getApplicationContext();
        this.app = this.appCtx.getApplication();
        this.taskMonitor = this.appCtx.getTaskMonitor();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new AddressTipsTable();
        this.keywordFld = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.progressBar = new JProgressBar();
        this.cntLbl = new JLabel();
        this.jPanel2 = new JPanel();
        this.dateLbl = new JLabel();
        this.jLabel1 = new JLabel();
        this.sortItem = new JComboBox();
        this.autoIme = new JCheckBox();
        this.historySearchButton = new JButton();
        this.memoSearchButton = new JButton();
        this.allergySearchButton = new JButton();
        this.karteSearchButton = new JButton();
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.table);
        this.keywordFld.setToolTipText("ID\u7b49\u306e\u4e00\u90e8\u3001\u60a3\u8005\u6c0f\u540d\u3001\u53f3\u30af\u30ea\u30c3\u30af\u3067\u6765\u9662\u65e5\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044.");
        this.jPanel1.setLayout(new FlowLayout(2, 5, 0));
        this.progressBar.setMaximumSize(new Dimension(100, 14));
        this.progressBar.setMinimumSize(new Dimension(100, 14));
        this.progressBar.setPreferredSize(new Dimension(100, 14));
        this.jPanel1.add(this.progressBar);
        this.cntLbl.setFont(new Font("Lucida Grande", 0, 10));
        this.cntLbl.setText("0 \u4ef6");
        this.jPanel1.add(this.cntLbl);
        this.jPanel2.setBorder(new SoftBevelBorder(0));
        this.jPanel2.setMaximumSize(new Dimension(2, 12));
        this.jPanel2.setMinimumSize(new Dimension(2, 12));
        this.jPanel2.setPreferredSize(new Dimension(2, 12));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 6, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel2);
        this.dateLbl.setFont(new Font("Lucida Grande", 0, 10));
        this.dateLbl.setText("2007-11-26(\u65e5)");
        this.jPanel1.add(this.dateLbl);
        this.jLabel1.setText("\u30bd\u30fc\u30c8:");
        this.sortItem.setModel(new DefaultComboBoxModel<String>(new String[]{"\u60a3\u8005ID", "\u30ab\u30ca"}));
        this.autoIme.setText("\u81ea\u52d5IME");
        this.historySearchButton.setFont(new Font("MS UI Gothic", 0, 10));
        this.historySearchButton.setText("\u5c65\u6b74");
        this.historySearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatientSearchView.this.historySearchButtonActionPerformed(evt);
            }
        });
        this.memoSearchButton.setFont(new Font("MS UI Gothic", 0, 10));
        this.memoSearchButton.setText("\u30e1\u30e2");
        this.memoSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatientSearchView.this.memoSearchButtonActionPerformed(evt);
            }
        });
        this.allergySearchButton.setFont(new Font("MS UI Gothic", 0, 10));
        this.allergySearchButton.setText("\u30a2\u30ec\u30eb\u30ae\u30fc");
        this.allergySearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatientSearchView.this.allergySearchButtonActionPerformed(evt);
            }
        });
        this.karteSearchButton.setFont(new Font("MS UI Gothic", 0, 10));
        this.karteSearchButton.setText("\u30ab\u30eb\u30c6\u5185\u5bb9");
        this.karteSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatientSearchView.this.karteSearchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -2, -1, -2).add((Component)this.jScrollPane1, -1, 683, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.sortItem, -2, -1, -2))).addPreferredGap(0, 47, Short.MAX_VALUE).add((Component)this.keywordFld, -2, 164, -2).addPreferredGap(0).add((Component)this.autoIme).addPreferredGap(0).add((Component)this.historySearchButton, -2, 69, -2).addPreferredGap(0).add((Component)this.memoSearchButton, -2, 65, -2).addPreferredGap(0).add((Component)this.allergySearchButton).addPreferredGap(0).add((Component)this.karteSearchButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.sortItem, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.karteSearchButton, -2, 22, -2).add((Component)this.allergySearchButton, -2, 22, -2).add((Component)this.memoSearchButton, -2, 22, -2).add((Component)this.historySearchButton, -2, 22, -2).add((Component)this.autoIme).add((Component)this.keywordFld, -2, -1, -2)).add(7, 7, 7).add((Component)this.jScrollPane1, -1, 284, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jPanel1, -2, 20, -2).addContainerGap()));
    }

    private void historySearchButtonActionPerformed(ActionEvent evt) {
        this.app = GlobalConstants.getApplicationContext().getApplication();
        TitleSearchTask task = new TitleSearchTask(this.app);
        this.appCtx.getTaskService().execute((Task)task);
    }

    private void memoSearchButtonActionPerformed(ActionEvent evt) {
        this.app = GlobalConstants.getApplicationContext().getApplication();
        MemoSearchTask task = new MemoSearchTask(this.app);
        this.appCtx.getTaskService().execute((Task)task);
    }

    private void allergySearchButtonActionPerformed(ActionEvent evt) {
        this.app = GlobalConstants.getApplicationContext().getApplication();
        AllergySearchTask task = new AllergySearchTask(this.app);
        this.appCtx.getTaskService().execute((Task)task);
    }

    private void karteSearchButtonActionPerformed(ActionEvent evt) {
        this.app = GlobalConstants.getApplicationContext().getApplication();
        KarteSearchTask task = new KarteSearchTask(this.app);
        this.appCtx.getTaskService().execute((Task)task);
    }

    private int getSelectedRow(JTable table) {
        int result = table.getSelectedRow();
        if (result >= 0 && result < table.getRowCount()) {
            result = table.convertRowIndexToModel(result);
        }
        return result;
    }

    @Override
    public void start() {
        this.initCustomComponents();
        this.connect();
        this.enter();
    }

    @Override
    public void enter() {
        this.controlMenu();
    }

    @Override
    public void stop() {
    }

    public PatientModel getSelectedPatinet() {
        return this.selectedPatient;
    }

    public void setSelectedPatinet(PatientModel model) {
        this.selectedPatient = model;
        this.controlMenu();
    }

    public void switchAgeDisplay() {
        this.isAgeDisplayed = !this.isAgeDisplayed;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        preferences.putBoolean("ageDisplay", this.isAgeDisplayed);
        if (this.table != null) {
            ObjectReflectTableModel tModel = (ObjectReflectTableModel)this.table.getModel();
            String method = this.isAgeDisplayed ? this.AGE_METHOD[0] : this.AGE_METHOD[1];
            tModel.setMethodName(method, 4);
        }
    }

    private void controlMenu() {
        boolean enabled = this.canOpen(this.getSelectedPatinet());
        this.getContext().enabledAction("openKarte", enabled);
    }

    private boolean canOpen(PatientModel patient) {
        if (patient == null) {
            return false;
        }
        return !this.isKarteOpened(patient);
    }

    private boolean isKarteOpened(PatientModel patient) {
        return this.context.isKarteOpened(patient.getId());
    }

    @Override
    public boolean dispatchMainCommand(IMainCommandAccepter.MainCommand command) {
        switch (command) {
            case openKarte: {
                return this.openKarte();
            }
        }
        return false;
    }

    private void initCustomComponents() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.isAgeDisplayed = preferences.getBoolean("ageDisplay", true);
        if (!this.isAgeDisplayed) {
            this.METHOD_NAMES[4] = this.AGE_METHOD[1];
        }
        ObjectReflectTableModel tableModel = new ObjectReflectTableModel(this.COLUMN_NAMES, 0, this.METHOD_NAMES, null);
        this.table.setModel(tableModel);
        this.table.setAutoCreateRowSorter(true);
        for (int i = 0; i < this.COLUMN_WIDTH.length; ++i) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.COLUMN_WIDTH[i]);
        }
        this.table.setDefaultRenderer(Object.class, new OddEvenRowRenderer());
        String formatStr = "yyyy-M-d(EEE)";
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        this.dateLbl.setText(sdf.format(new Date()));
        this.sortItemValue = preferences.getInt("sortItem", 0);
        this.sortItem.setSelectedIndex(this.sortItemValue);
        if (!GlobalConstants.isMac()) {
            this.autoIme.setSelected(preferences.getBoolean("autoIme", false));
        } else {
            this.autoIme.setEnabled(false);
        }
    }

    private void connect() {
        EventAdapter adp = new EventAdapter(this.keywordFld, this.table);
        this.autoIme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox check = (JCheckBox)e.getSource();
                boolean selected = check.isSelected();
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                preferences.putBoolean("autoIme", selected);
                if (selected) {
                    PatientSearchView.this.keywordFld.addFocusListener(AutoKanjiListener.getInstance());
                } else {
                    PatientSearchView.this.keywordFld.addFocusListener(AutoRomanListener.getInstance());
                }
            }
        });
        this.sortItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JComboBox cb = (JComboBox)e.getSource();
                    PatientSearchView.this.sortItemValue = cb.getSelectedIndex();
                    Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                    preferences.putInt("sortItem", PatientSearchView.this.sortItemValue);
                }
            }
        });
        PopupListener pl = new PopupListener(this.keywordFld);
        this.table.addMouseListener(new ContextListener());
        this.keyBlocker = new KeyBlocker(this.keywordFld);
    }

    private String constractDept() {
        CombinedStringParser line = new CombinedStringParser(',');
        line.set(0, GlobalVariables.getUserModel().getDepartmentModel().getDepartmentDesc());
        line.set(1, GlobalVariables.getUserModel().getDepartmentModel().getDepartment());
        line.set(2, GlobalVariables.getUserModel().getCommonName());
        line.set(3, GlobalVariables.getUserModel().getUserId());
        line.set(4, GlobalVariables.getJMARICode());
        line.set(5, "");
        return line.toCombinedString();
    }

    private boolean openKarte() {
        if (this.canOpen(this.getSelectedPatinet())) {
            PatientVisitModel pvt = new PatientVisitModel();
            pvt.setId(0L);
            pvt.setNumber(this.number);
            ++this.number;
            pvt.setPatient(this.getSelectedPatinet());
            pvt.setDepartment(this.constractDept());
            this.getContext().openKarte(pvt, this.keywordFld.getText());
        }
        return true;
    }

    private KarteBean getKarteBean(PatientModel patient) {
        PatientVisitModel pvt = new PatientVisitModel();
        pvt.setId(0L);
        pvt.setNumber(this.number);
        ++this.number;
        pvt.setPatient(patient);
        pvt.setDepartment(this.constractDept());
        int past = GlobalVariables.getPreferences().getInt("docHistory.period", -12);
        GregorianCalendar today = new GregorianCalendar();
        today.add(2, past);
        today.clear(11);
        today.clear(12);
        today.clear(13);
        today.clear(14);
        RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        KarteBean karteBean = ddl.getKarte(pvt.getPatient().getId(), today.getTime());
        return karteBean;
    }

    public void addAsPvt() {
        PatientVisitModel pvt = new PatientVisitModel();
        pvt.setId(0L);
        pvt.setNumber(this.number);
        ++this.number;
        pvt.setPatient(this.getSelectedPatinet());
        pvt.setDepartment(this.constractDept());
        pvt.setPvtDate(ModelUtils.getDateTimeAsString(new Date()));
        this.app = GlobalConstants.getApplicationContext().getApplication();
        this.taskMonitor = GlobalConstants.getApplicationContext().getTaskMonitor();
        AddAsPvtTask task = new AddAsPvtTask(this.app, pvt);
        MyInputBlocker blocker = new MyInputBlocker(task, this.getContext().getGlassPane(), this.keyBlocker);
        task.setInputBlocker(blocker);
        StatusMonitor bar = new StatusMonitor(task, this.taskMonitor, this.progressBar);
        GlobalConstants.getApplicationContext().getTaskService().execute((Task)task);
    }

    public PatientSearchSpec createSpec(String text) {
        PatientSearchSpec spec = new PatientSearchSpec();
        if (text.equals("")) {
            spec.setCode(0);
        } else if (text.startsWith("N ") || text.startsWith("n ")) {
            spec.setCode(2);
            text = text.substring(2);
            spec.setName(text);
        } else if (text.startsWith("K ") || text.startsWith("k ")) {
            spec.setCode(3);
            text = text.substring(2);
            spec.setName(text);
        } else if (text.startsWith("A ") || text.startsWith("a ")) {
            spec.setCode(7);
            text = text.substring(2);
            spec.setAddress(text);
        } else if (text.startsWith("Z ") || text.startsWith("z ")) {
            spec.setCode(6);
            text = text.substring(2);
            spec.setZipCode(text);
        } else if (text.startsWith("T ") || text.startsWith("t ")) {
            spec.setCode(5);
            text = text.substring(2);
            spec.setTelephone(text);
        } else if (text.startsWith("I ") || text.startsWith("i ")) {
            spec.setCode(1);
            text = text.substring(2);
            spec.setPatientId(text);
        } else if (text.startsWith("E ") || text.startsWith("e ")) {
            spec.setCode(8);
            text = text.substring(2);
            spec.setEmail(text);
        } else if (text.startsWith("O ") || text.startsWith("o ")) {
            spec.setCode(9);
            text = text.substring(2);
            spec.setOtherId(text);
        } else if (this.isDate(text)) {
            spec.setCode(11);
            spec.setDigit(text);
        } else if (this.isKana(text)) {
            spec.setCode(3);
            spec.setName(text);
        } else if (this.isNameAddress(text)) {
            spec.setCode(2);
            spec.setName(text);
        } else if (this.isTelephoneZip(text)) {
            int i = (text = text.trim()).length();
            if (i < 5) {
                StringBuffer sb = new StringBuffer();
                int j = 5 - i;
                for (int k = 0; k < j; ++k) {
                    sb.append(new String("0"));
                }
                sb.append(text);
                text = sb.toString();
            }
            spec.setCode(10);
            spec.setDigit(text);
        } else if (this.isId(text)) {
            int i = (text = text.trim()).length();
            if (i < 5) {
                StringBuilder sb = new StringBuilder();
                int j = 5 - i;
                for (int k = 0; k < j; ++k) {
                    sb.append(new String("0"));
                }
                sb.append(text);
                text = sb.toString();
            }
            spec.setCode(1);
            spec.setPatientId(text);
        } else {
            spec = null;
        }
        return spec;
    }

    private void find(String text) {
        PatientSearchSpec spec = this.createSpec(text);
        if (spec == null) {
            String msg = "\u691c\u7d22\u306b\u9069\u3055\u306a\u3044\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002";
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this.getPanel()), msg, this.getName(), 2);
            return;
        }
        this.app = GlobalConstants.getApplicationContext().getApplication();
        this.taskMonitor = GlobalConstants.getApplicationContext().getTaskMonitor();
        FindTask task = new FindTask(this.app, spec);
        MyInputBlocker blocker = new MyInputBlocker(task, this.getContext().getGlassPane(), this.keyBlocker);
        task.setInputBlocker(blocker);
        StatusMonitor bar = new StatusMonitor(task, this.taskMonitor, this.progressBar);
        this.appCtx.getTaskService().execute((Task)task);
    }

    private boolean isDate(String text) {
        boolean maybe = false;
        if (text != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                sdf.parse(text);
                maybe = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return maybe;
    }

    private boolean isKana(String text) {
        boolean maybe = true;
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (StringTool.isKatakana(c)) continue;
                maybe = false;
                break;
            }
            return maybe;
        }
        return false;
    }

    private boolean isNameAddress(String text) {
        boolean maybe = false;
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (Character.getType(c) != 5) continue;
                maybe = true;
                break;
            }
        }
        return maybe;
    }

    private boolean isId(String text) {
        boolean maybe = true;
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                int type = Character.getType(c);
                if (type == 1 || type == 2 || type == 9) continue;
                maybe = false;
                break;
            }
            return maybe;
        }
        return false;
    }

    private boolean isTelephoneZip(String text) {
        boolean maybe = true;
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                int type = Character.getType(c);
                if (type == 9 || c == '-' || c == '(' || c == ')') continue;
                maybe = false;
                break;
            }
            return maybe;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setPanel(JPanel panel) {
    }

    @Override
    public Callable<Boolean> getStartingTask() {
        return null;
    }

    @Override
    public Callable<Boolean> getStoppingTask() {
        return null;
    }

    class PopupListener
    extends MouseAdapter
    implements PropertyChangeListener {
        private JPopupMenu popup;
        private JTextField tf;

        public PopupListener(JTextField tf) {
            this.tf = tf;
            tf.addMouseListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup = new JPopupMenu();
                CalendarCardPanel cc = new CalendarCardPanel(GlobalConstants.getEventColorTable());
                cc.addPropertyChangeListener("pickedDate", this);
                cc.setCalendarRange(new int[]{-12, 0});
                this.popup.insert(cc, 0);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("pickedDate")) {
                SimpleDate sd = (SimpleDate)e.getNewValue();
                this.tf.setText(SimpleDate.simpleDateToMmldate(sd));
                this.popup.setVisible(false);
                this.popup = null;
                String test = this.tf.getText().trim();
                if (!test.equals("")) {
                    PatientSearchView.this.find(test);
                }
            }
        }
    }

    class MyInputBlocker
    extends Task.InputBlocker {
        private BlockGlass glassPane;
        private KeyBlocker keyBlocker;

        MyInputBlocker(Task task, BlockGlass glassPane, KeyBlocker keyBlocker) {
            super(task, Task.BlockingScope.WINDOW, (Object)glassPane);
            this.glassPane = glassPane;
            this.keyBlocker = keyBlocker;
        }

        protected void block() {
            this.glassPane.block();
            this.keyBlocker.block();
        }

        protected void unblock() {
            this.glassPane.unblock();
            this.keyBlocker.unblock();
        }
    }

    class KarteSearchTask
    extends Task<Collection, Void> {
        private PatientSearchSpec spec;
        private RemoteDocumentDelegater ddl;
        private Cursor currentCursor;

        public KarteSearchTask(Application app) {
            super(app);
            this.ddl = new RemoteDocumentDelegater();
        }

        protected Collection doInBackground() throws Exception {
            this.currentCursor = PatientSearchView.this.getCursor();
            PatientSearchView.this.setCursor(new Cursor(3));
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
            ArrayList<PatientModel> result = new ArrayList<PatientModel>();
            for (int index = 0; index < tableModel.getRowCount(); ++index) {
                PatientModel patientModel = (PatientModel)tableModel.getObject(index);
                KarteBean karteBean = PatientSearchView.this.getKarteBean(patientModel);
                Map<String, List> entries = karteBean.getEntries();
                List items = entries.get("docInfo");
                boolean found = false;
                DolphinQuery query = new DolphinQuery();
                query.addWhat("keyword", PatientSearchView.this.keywordFld.getText());
                if (items == null) continue;
                ArrayList<Long> docId = new ArrayList<Long>();
                for (DocInfoModel item : items) {
                    docId.add(new Long(item.getDocPk()));
                }
                List<DocumentModel> documents = this.ddl.getDocuments(docId);
                for (DocumentModel document : documents) {
                    Set<ModuleModel> modules = document.getModules();
                    for (ModuleModel module : modules) {
                        if (!module.search(query)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) continue;
                result.add(patientModel);
            }
            return result;
        }

        protected void succeeded(Collection result) {
            List list = (List)result;
            if (list != null && list.size() > 0) {
                switch (PatientSearchView.this.sortItemValue) {
                    case 0: {
                        Comparator<PatientModel> c = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                return p1.getPatientId().compareTo(p2.getPatientId());
                            }
                        };
                        Collections.sort(list, c);
                        break;
                    }
                    case 1: {
                        Comparator<PatientModel> c2 = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                String kana1 = p1.getKanaName();
                                String kana2 = p2.getKanaName();
                                if (kana1 != null && kana2 != null) {
                                    return p1.getKanaName().compareTo(p2.getKanaName());
                                }
                                if (kana1 != null && kana2 == null) {
                                    return -1;
                                }
                                if (kana1 == null && kana2 != null) {
                                    return 1;
                                }
                                return 0;
                            }
                        };
                        Collections.sort(list, c2);
                    }
                }
            }
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
            tableModel.setObjectList(list);
            int cnt = result != null ? result.size() : 0;
            String cntStr = String.valueOf(cnt);
            PatientSearchView.this.cntLbl.setText(cntStr + " \u4ef6");
            PatientSearchView.this.setCursor(this.currentCursor);
        }

        protected void failed(Throwable cause) {
            PatientSearchView.this.setCursor(this.currentCursor);
        }

        protected void cancelled() {
            PatientSearchView.this.setCursor(this.currentCursor);
        }
    }

    class AllergySearchTask
    extends Task<Collection, Void> {
        private PatientSearchSpec spec;
        private Cursor currentCursor;

        public AllergySearchTask(Application app) {
            super(app);
        }

        protected Collection doInBackground() throws Exception {
            this.currentCursor = PatientSearchView.this.getCursor();
            PatientSearchView.this.setCursor(new Cursor(3));
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
            ArrayList<PatientModel> result = new ArrayList<PatientModel>();
            DolphinQuery query = new DolphinQuery();
            query.addWhat("keyword", PatientSearchView.this.keywordFld.getText());
            for (int index = 0; index < tableModel.getRowCount(); ++index) {
                PatientModel patientModel = (PatientModel)tableModel.getObject(index);
                KarteBean karteBean = PatientSearchView.this.getKarteBean(patientModel);
                Map<String, List> entries = karteBean.getEntries();
                List items = entries.get("allergy");
                if (items == null) continue;
                boolean found = false;
                for (AllergyModel item : items) {
                    if (!item.search(query)) continue;
                    found = true;
                }
                if (!found) continue;
                result.add(patientModel);
            }
            return result;
        }

        protected void succeeded(Collection result) {
            List list = (List)result;
            if (list != null && list.size() > 0) {
                switch (PatientSearchView.this.sortItemValue) {
                    case 0: {
                        Comparator<PatientModel> c = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                return p1.getPatientId().compareTo(p2.getPatientId());
                            }
                        };
                        Collections.sort(list, c);
                        break;
                    }
                    case 1: {
                        Comparator<PatientModel> c2 = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                String kana1 = p1.getKanaName();
                                String kana2 = p2.getKanaName();
                                if (kana1 != null && kana2 != null) {
                                    return p1.getKanaName().compareTo(p2.getKanaName());
                                }
                                if (kana1 != null && kana2 == null) {
                                    return -1;
                                }
                                if (kana1 == null && kana2 != null) {
                                    return 1;
                                }
                                return 0;
                            }
                        };
                        Collections.sort(list, c2);
                    }
                }
            }
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
            tableModel.setObjectList(list);
            int cnt = result != null ? result.size() : 0;
            String cntStr = String.valueOf(cnt);
            PatientSearchView.this.cntLbl.setText(cntStr + " \u4ef6");
            PatientSearchView.this.setCursor(this.currentCursor);
        }

        protected void failed(Throwable cause) {
            PatientSearchView.this.setCursor(this.currentCursor);
        }

        protected void cancelled() {
            PatientSearchView.this.setCursor(this.currentCursor);
        }
    }

    class MemoSearchTask
    extends Task<Collection, Void> {
        private PatientSearchSpec spec;
        private Cursor currentCursor;

        public MemoSearchTask(Application app) {
            super(app);
        }

        protected Collection doInBackground() throws Exception {
            this.currentCursor = PatientSearchView.this.getCursor();
            PatientSearchView.this.setCursor(new Cursor(3));
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
            ArrayList<PatientModel> result = new ArrayList<PatientModel>();
            DolphinQuery query = new DolphinQuery();
            query.addWhat("keyword", PatientSearchView.this.keywordFld.getText());
            for (int index = 0; index < tableModel.getRowCount(); ++index) {
                PatientModel patientModel = (PatientModel)tableModel.getObject(index);
                KarteBean karteBean = PatientSearchView.this.getKarteBean(patientModel);
                Map<String, List> entries = karteBean.getEntries();
                List items = entries.get("patientMemo");
                if (items == null) continue;
                boolean found = false;
                for (PatientMemoModel item : items) {
                    if (!item.search(query)) continue;
                    found = true;
                }
                if (!found) continue;
                result.add(patientModel);
            }
            return result;
        }

        protected void succeeded(Collection result) {
            List list = (List)result;
            if (list != null && list.size() > 0) {
                switch (PatientSearchView.this.sortItemValue) {
                    case 0: {
                        Comparator<PatientModel> c = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                return p1.getPatientId().compareTo(p2.getPatientId());
                            }
                        };
                        Collections.sort(list, c);
                        break;
                    }
                    case 1: {
                        Comparator<PatientModel> c2 = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                String kana1 = p1.getKanaName();
                                String kana2 = p2.getKanaName();
                                if (kana1 != null && kana2 != null) {
                                    return p1.getKanaName().compareTo(p2.getKanaName());
                                }
                                if (kana1 != null && kana2 == null) {
                                    return -1;
                                }
                                if (kana1 == null && kana2 != null) {
                                    return 1;
                                }
                                return 0;
                            }
                        };
                        Collections.sort(list, c2);
                    }
                }
            }
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
            tableModel.setObjectList(list);
            int cnt = result != null ? result.size() : 0;
            String cntStr = String.valueOf(cnt);
            PatientSearchView.this.cntLbl.setText(cntStr + " \u4ef6");
            PatientSearchView.this.setCursor(this.currentCursor);
        }

        protected void failed(Throwable cause) {
            PatientSearchView.this.setCursor(this.currentCursor);
        }

        protected void cancelled() {
            PatientSearchView.this.setCursor(this.currentCursor);
        }
    }

    class TitleSearchTask
    extends Task<Collection, Void> {
        private PatientSearchSpec spec;
        private Cursor currentCursor;

        public TitleSearchTask(Application app) {
            super(app);
        }

        protected Collection doInBackground() throws Exception {
            this.currentCursor = PatientSearchView.this.getCursor();
            PatientSearchView.this.setCursor(new Cursor(3));
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
            ArrayList<PatientModel> result = new ArrayList<PatientModel>();
            DolphinQuery query = new DolphinQuery();
            query.addWhat("keyword", PatientSearchView.this.keywordFld.getText());
            for (int index = 0; index < tableModel.getRowCount(); ++index) {
                PatientModel patientModel = (PatientModel)tableModel.getObject(index);
                KarteBean karteBean = PatientSearchView.this.getKarteBean(patientModel);
                Map<String, List> entries = karteBean.getEntries();
                List items = entries.get("docInfo");
                if (items == null) continue;
                boolean found = false;
                for (DocInfoModel item : items) {
                    if (!item.search(query)) continue;
                    found = true;
                }
                if (!found) continue;
                result.add(patientModel);
            }
            return result;
        }

        protected void succeeded(Collection result) {
            List list = (List)result;
            if (list != null && list.size() > 0) {
                switch (PatientSearchView.this.sortItemValue) {
                    case 0: {
                        Comparator<PatientModel> c = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                return p1.getPatientId().compareTo(p2.getPatientId());
                            }
                        };
                        Collections.sort(list, c);
                        break;
                    }
                    case 1: {
                        Comparator<PatientModel> c2 = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                String kana1 = p1.getKanaName();
                                String kana2 = p2.getKanaName();
                                if (kana1 != null && kana2 != null) {
                                    return p1.getKanaName().compareTo(p2.getKanaName());
                                }
                                if (kana1 != null && kana2 == null) {
                                    return -1;
                                }
                                if (kana1 == null && kana2 != null) {
                                    return 1;
                                }
                                return 0;
                            }
                        };
                        Collections.sort(list, c2);
                    }
                }
            }
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
            tableModel.setObjectList(list);
            int cnt = result != null ? result.size() : 0;
            String cntStr = String.valueOf(cnt);
            PatientSearchView.this.cntLbl.setText(cntStr + " \u4ef6");
            PatientSearchView.this.setCursor(this.currentCursor);
        }

        protected void failed(Throwable cause) {
            PatientSearchView.this.setCursor(this.currentCursor);
        }

        protected void cancelled() {
            PatientSearchView.this.setCursor(this.currentCursor);
        }
    }

    class FindTask
    extends Task<Collection, Void> {
        private PatientSearchSpec spec;

        public FindTask(Application app, PatientSearchSpec spec) {
            super(app);
            this.spec = spec;
        }

        protected List<PatientModel> doInBackground() throws Exception {
            RemotePatientDelegater pdl = new RemotePatientDelegater();
            List<PatientModel> result = pdl.getPatients(this.spec);
            return result;
        }

        protected void succeeded(Collection result) {
            List list = (List)result;
            if (list != null && list.size() > 0) {
                switch (PatientSearchView.this.sortItemValue) {
                    case 0: {
                        Comparator<PatientModel> c = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                return p1.getPatientId().compareTo(p2.getPatientId());
                            }
                        };
                        Collections.sort(list, c);
                        break;
                    }
                    case 1: {
                        Comparator<PatientModel> c2 = new Comparator<PatientModel>(){

                            @Override
                            public int compare(PatientModel p1, PatientModel p2) {
                                String kana1 = p1.getKanaName();
                                String kana2 = p2.getKanaName();
                                if (kana1 != null && kana2 != null) {
                                    return p1.getKanaName().compareTo(p2.getKanaName());
                                }
                                if (kana1 != null && kana2 == null) {
                                    return -1;
                                }
                                if (kana1 == null && kana2 != null) {
                                    return 1;
                                }
                                return 0;
                            }
                        };
                        Collections.sort(list, c2);
                    }
                }
            }
            ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
            tableModel.setObjectList(list);
            int cnt = result != null ? result.size() : 0;
            String cntStr = String.valueOf(cnt);
            PatientSearchView.this.cntLbl.setText(cntStr + " \u4ef6");
        }

        protected void failed(Throwable cause) {
        }

        protected void cancelled() {
        }
    }

    class StatusMonitor
    implements PropertyChangeListener {
        private Task task;
        private TaskMonitor taskMonitor;
        private JProgressBar bar;

        public StatusMonitor(Task task, TaskMonitor taskMonitor, JProgressBar bar) {
            this.task = task;
            this.taskMonitor = taskMonitor;
            this.bar = bar;
            taskMonitor.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("started".equals(propertyName)) {
                this.bar.setIndeterminate(true);
            } else if ("done".equals(propertyName)) {
                this.bar.setIndeterminate(false);
                this.bar.setValue(0);
                this.taskMonitor.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    class AddAsPvtTask
    extends Task<Void, Void> {
        private PatientVisitModel pvt;

        public AddAsPvtTask(Application app, PatientVisitModel pvt) {
            super(app);
            this.pvt = pvt;
        }

        protected Void doInBackground() {
            RemotePVTDelegater pdl = new RemotePVTDelegater();
            pdl.addPvt(this.pvt);
            return null;
        }
    }

    class EventAdapter
    implements ActionListener,
    ListSelectionListener,
    MouseListener {
        public EventAdapter(JTextField tf, JTable tbl) {
            tf.addActionListener(this);
            tf.addFocusListener(AutoKanjiListener.getInstance());
            tbl.getSelectionModel().addListSelectionListener(this);
            tbl.addMouseListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf = (JTextField)e.getSource();
            String test = tf.getText().trim();
            PatientSearchView.this.find(test);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ObjectReflectTableModel tableModel = (ObjectReflectTableModel)PatientSearchView.this.table.getModel();
                PatientSearchView.this.setSelectedPatinet((PatientModel)tableModel.getObject(PatientSearchView.this.getSelectedRow(PatientSearchView.this.table)));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                JTable table = (JTable)e.getSource();
                ObjectReflectTableModel tableModel = (ObjectReflectTableModel)table.getModel();
                PatientSearchView.this.setSelectedPatinet((PatientModel)tableModel.getObject(PatientSearchView.this.getSelectedRow(table)));
                PatientSearchView.this.openKarte();
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }
    }

    class ContextListener
    extends MouseAdapter {
        ContextListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mabeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mabeShowPopup(e);
        }

        public void mabeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu contextMenu = new JPopupMenu();
                int row = PatientSearchView.this.table.rowAtPoint(e.getPoint());
                Object obj = ((ObjectReflectTableModel)PatientSearchView.this.table.getModel()).getObject(row);
                int selected = ((JTable)e.getSource()).getSelectedRow();
                if (row == selected && obj != null) {
                    contextMenu.add(new JMenuItem(new AbstractAction("\u30ab\u30eb\u30c6\u3092\u958b\u304f"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PatientSearchView.this.openKarte();
                        }
                    }));
                    contextMenu.add(new JMenuItem(new AbstractAction("\u53d7\u4ed8\u767b\u9332"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PatientSearchView.this.addAsPvt();
                        }
                    }));
                }
                JCheckBoxMenuItem item = new JCheckBoxMenuItem("\u5e74\u9f62\u8868\u793a");
                contextMenu.add(item);
                item.setSelected(PatientSearchView.this.isAgeDisplayed);
                item.addActionListener(EventHandler.create(ActionListener.class, PatientSearchView.this, "switchAgeDisplay"));
                contextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

