/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestimporter;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import open.dolphin.client.labotestimporter.AverageInformation;
import open.dolphin.client.labotestimporter.LaboTestInformation;
import open.dolphin.client.labotestimporter.LaboTestResultInformation;
import open.dolphin.log.LogWriter;

public class MedisParser {
    private static final String RESULT_INFO = "A1";
    private static final String AVERAGE_LEVEL = "S1";
    private String recordType = "A1";
    private static final int[] COMMON_HEADER_SIZES = new int[]{2, 6, 20, 8, 12, 20};
    private static final int[] RESULT_HEADER_SIZES = new int[]{1, 3, 3, 3};
    private static final int[] RESULT_BODY_SIZES = new int[]{17, 8, 1, 3, 3};
    private static final int[] RESULT_FOOTER_SIZES = new int[]{8, 2, 1, 1, 1, 1, 1, 1, 2};
    private static final int[] AVERAGE_LEVEL_SIZES = new int[]{1, 8, 8, 12, 8};
    private static final int[] AVERAGE_FOOTER_SIZES = new int[]{3};
    private static final int BUF_SIZE = 258;
    private LaboTestInformation laboTestInformation;

    public List<LaboTestInformation> parse(InputStream is) throws IOException {
        ArrayList<LaboTestInformation> result = new ArrayList<LaboTestInformation>();
        byte[] buf = new byte[258];
        int len = 0;
        int lineNum = 1;
        while ((len = is.read(buf)) != -1 && len == 258) {
            if (this.parseLine(buf)) {
                result.add(this.laboTestInformation);
            }
            ++lineNum;
        }
        return result;
    }

    private boolean parseLine(byte[] ba) {
        int pos = 0;
        boolean result = false;
        if (RESULT_INFO.equals(this.recordType)) {
            this.laboTestInformation = new LaboTestInformation();
            pos = this.parseCommonHeader(ba, pos);
            pos = this.parseResultHeader(ba, pos);
            pos = this.parseResultBody(ba, pos);
            pos = this.parseResultFooter(ba, pos);
            this.recordType = AVERAGE_LEVEL;
            result = false;
        } else if (AVERAGE_LEVEL.equals(this.recordType)) {
            pos = this.parseCommonHeader(ba, pos);
            pos = this.parseAverageLevel(ba, pos);
            pos = this.parseAverageFooter(ba, pos);
            this.recordType = RESULT_INFO;
            result = true;
        }
        return result;
    }

    private int parseCommonHeader(byte[] ba, int from) {
        ListPosition listPosition = this.getListPosition(ba, COMMON_HEADER_SIZES, from);
        List<String> header = listPosition.getList();
        this.recordType = header.get(0);
        this.laboTestInformation.setCenterCode(header.get(1));
        this.laboTestInformation.setSampleTime(header.get(2));
        this.laboTestInformation.setConfirmedDate(header.get(3));
        this.laboTestInformation.setCommitionedKey(header.get(4));
        this.laboTestInformation.setPatiantName(header.get(5));
        return listPosition.getPosition();
    }

    private int parseResultHeader(byte[] ba, int from) {
        ListPosition listPosition = this.getListPosition(ba, RESULT_HEADER_SIZES, from);
        List<String> header = listPosition.getList();
        this.laboTestInformation.setStatus(header.get(0));
        this.laboTestInformation.setMilk(header.get(1));
        this.laboTestInformation.setHemolytic(header.get(2));
        this.laboTestInformation.setBilirubin(header.get(3));
        return listPosition.getPosition();
    }

    private int parseResultBody(byte[] ba, int from) {
        ListPosition listPosition = null;
        List<String> body = null;
        for (int n = 0; n < 5; ++n) {
            listPosition = this.getListPosition(ba, RESULT_BODY_SIZES, from);
            body = listPosition.getList();
            from = listPosition.getPosition();
            this.laboTestInformation.addTestResultInformation(new LaboTestResultInformation(body.get(0), body.get(1), body.get(2), body.get(3), body.get(4)));
        }
        return listPosition.getPosition();
    }

    private int parseResultFooter(byte[] ba, int from) {
        ListPosition listPosition = this.getListPosition(ba, RESULT_FOOTER_SIZES, from);
        List<String> footer = listPosition.getList();
        this.laboTestInformation.setRegistTime(footer.get(0));
        this.laboTestInformation.setAbnormalValueFlag(footer.get(2));
        this.laboTestInformation.addAbnormalValue(footer.get(3));
        this.laboTestInformation.addAbnormalValue(footer.get(4));
        this.laboTestInformation.addAbnormalValue(footer.get(5));
        this.laboTestInformation.addAbnormalValue(footer.get(6));
        this.laboTestInformation.addAbnormalValue(footer.get(7));
        return listPosition.getPosition();
    }

    private int parseAverageLevel(byte[] ba, int from) {
        ListPosition listPosition = null;
        List<String> body = null;
        for (int n = 0; n < 5; ++n) {
            listPosition = this.getListPosition(ba, AVERAGE_LEVEL_SIZES, from);
            body = listPosition.getList();
            from = listPosition.getPosition();
            this.laboTestInformation.addAverageInformation(new AverageInformation(body.get(0), body.get(1), body.get(2), body.get(3)));
        }
        return listPosition.getPosition();
    }

    private int parseAverageFooter(byte[] ba, int from) {
        ListPosition listPosition = this.getListPosition(ba, AVERAGE_FOOTER_SIZES, from);
        return listPosition.getPosition();
    }

    private ListPosition getListPosition(byte[] ba, int[] sizes, int start) {
        int from = start;
        int to = start;
        ArrayList<String> result = new ArrayList<String>();
        for (int size : sizes) {
            to += size;
            try {
                byte[] a = Arrays.copyOfRange(ba, from, to);
                String str = new String(a, "Windows-31J");
                result.add(str);
            }
            catch (UnsupportedEncodingException ex) {
                LogWriter.error(MedisParser.class, "", (Throwable)ex);
            }
            from += size;
        }
        return new ListPosition(result, to);
    }

    private class ListPosition {
        private List<String> list;
        private int position;

        public ListPosition(List<String> list, int position) {
            this.list = list;
            this.position = position;
        }

        public List<String> getList() {
            return this.list;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

