/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestdocument;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import open.dolphin.client.labotestdocument.SimpleLaboTestItem;

public class LaboTestGraphPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 7472151201436824606L;
    public static final int TT_ABSOLUTE_GRAPH = 0;
    public static final int TT_RELATIVE_GRAPH = 1;
    static final String UPPER_LIMIT_STRING = "\u4e0a\u9650\u5024";
    static final String LOWER_LIMIT_STRING = "\u4e0b\u9650\u5024";
    static final float UPPER_LIMIT_VALUE = 1.0f;
    static final float LOWER_LIMIT_VALUE = 0.0f;
    static final float Y_SCALE_UNIT = 0.2f;
    static final String RELATIVE_VALUE_STRING = "\u76f8\u5bfe\u5024";
    static final int OFFSET_LEFT = 12;
    static final int OFFSET_RIGHT = 12;
    static final int OFFSET_TOP = 12;
    static final int OFFSET_BOTTOM = 20;
    static final float SCALE_FRAME_SPACE = 5.0f;
    static final float EXAMPLE_FRAME_SPACE = 50.0f;
    static final float EXAMPLE_SPACE = 30.0f;
    static final float DUMMY_VALUE = -9999.99f;
    String[] sampleTime;
    String[] itemName;
    String[] itemUnit;
    float[][] data;
    float[] upperLimit;
    float[] lowerLimit;
    float[] maxValue;
    float[] minValue;
    boolean validData;
    float canvasWidth;
    float canvasHeight;
    int offsetTop;
    int offsetLeft;
    int offsetRight;
    int offsetBottom;
    float xMin;
    float xMax;
    float yMin;
    float yMax;
    float pixelsPerX;
    float pixelsPerY;
    Color background = new Color(245, 245, 245);
    float plotCircleRadius = 10.0f;
    Color[] plotColors = new Color[]{Color.red, Color.blue, Color.pink, Color.cyan, Color.orange, Color.green, Color.magenta, Color.yellow};
    boolean bValueCircle = true;
    boolean antiAliasing = true;
    boolean textAntiAliasing = false;
    Color scaleLineColor = Color.lightGray;
    float scaleLineWidth = 1.0f;
    Color scaleColor = Color.black;
    Font scaleFont = new Font("Dialig", 0, 12);
    float[] yScaleDashPattern = new float[]{2.0f, 2.0f};
    Color xTitleColor = Color.black;
    Font xTitleFont = new Font("Dialig", 0, 12);
    Color yTitleColor = Color.black;
    Font yTitleFont = new Font("Dialig", 0, 12);
    Font itemNameFont = new Font("Dialig", 0, 12);
    float valueLineWidth = 1.7f;
    Color upperLimitColor = new Color(255, 64, 183);
    Color normalAreaColor = new Color(127, 250, 107);
    Color lowerLimitColor = new Color(19, 100, 250);
    float valueAreaAlpha = 0.5f;
    int mode = 1;
    private Object[] yScales;
    boolean hasOffset;
    boolean hasPixelsPerValue;

    public LaboTestGraphPanel() {
        this.initComponents();
        this.setBackground(this.background);
        this.addComponentListener(this);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int newMode) {
        int old = this.mode;
        if (newMode == 0 || newMode == 1) {
            this.mode = newMode;
        }
        if (newMode != old) {
            this.hasPixelsPerValue = false;
            this.repaint();
        }
    }

    public void setTestValue(String[] sampleTime, List list, int mode) {
        if (this.data != null) {
            this.itemName = null;
            this.itemUnit = null;
            this.data = null;
            this.upperLimit = null;
            this.lowerLimit = null;
            this.maxValue = null;
            this.minValue = null;
            this.hasPixelsPerValue = false;
        }
        this.mode = mode;
        this.sampleTime = sampleTime;
        int sampleCount = sampleTime.length;
        int itemCount = list.size();
        this.itemName = new String[itemCount];
        this.itemUnit = new String[itemCount];
        this.data = new float[itemCount][sampleCount];
        this.upperLimit = new float[itemCount];
        this.lowerLimit = new float[itemCount];
        this.maxValue = new float[itemCount];
        this.minValue = new float[itemCount];
        float value = 0.0f;
        float maxUp = 0.0f;
        float maxVal = 0.0f;
        float minVal = -9999.99f;
        float minLow = -9999.99f;
        String strVal = null;
        for (int i = 0; i < itemCount; ++i) {
            List al = (List)list.get(i);
            int size = al.size();
            boolean hasName = false;
            boolean hasUnit = false;
            boolean firstValue = true;
            boolean firstUp = true;
            boolean firstLow = true;
            for (int j = 0; j < size; ++j) {
                SimpleLaboTestItem test = (SimpleLaboTestItem)al.get(j);
                if (test == null) {
                    this.data[i][j] = -9999.99f;
                    continue;
                }
                try {
                    this.data[i][j] = value = Float.parseFloat(test.getItemValue());
                    if (firstValue) {
                        maxVal = value;
                        minVal = value;
                        firstValue = false;
                    } else {
                        maxVal = Math.max(value, maxVal);
                        minVal = Math.min(value, minVal);
                    }
                }
                catch (Exception e) {
                    this.data[i][j] = -9999.99f;
                }
                try {
                    value = Float.parseFloat(test.getUp());
                    if (firstUp) {
                        maxUp = value;
                        firstUp = false;
                    } else {
                        maxUp = Math.max(value, maxUp);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    value = Float.parseFloat(test.getLow());
                    if (firstLow) {
                        minLow = value;
                        firstLow = false;
                    } else {
                        minLow = Math.min(value, minLow);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!hasName && (strVal = test.getItemName()) != null) {
                    this.itemName[i] = strVal;
                    hasName = true;
                }
                if (hasUnit || (strVal = test.getItemUnit()) == null) continue;
                this.itemUnit[i] = strVal;
                hasUnit = true;
            }
            this.maxValue[i] = maxVal;
            this.minValue[i] = minVal;
            this.upperLimit[i] = maxUp;
            this.lowerLimit[i] = minLow;
        }
        this.repaint();
    }

    protected float getCanvasWidth() {
        return this.getWidth() - this.offsetLeft - this.offsetRight;
    }

    protected float getCanvasHeight() {
        return this.getHeight() - this.offsetTop - this.offsetBottom;
    }

    protected float getPixelsForSample(int j) {
        return ((float)j + 0.5f) * this.pixelsPerX;
    }

    protected float getPixelsForSampleBound(int j) {
        return (float)j * this.pixelsPerX;
    }

    protected float getPixelsForSample(float j) {
        return j * this.pixelsPerX;
    }

    protected float getPixelsForValue(float value) {
        return this.canvasHeight - (value - this.yMin) * this.pixelsPerY;
    }

    protected Rectangle2D getGraphRect() {
        float left = this.getPixelsForSample(this.xMin);
        float top = this.getPixelsForValue(this.yMax);
        float right = this.getPixelsForSample(this.xMax);
        float bottom = this.getPixelsForValue(this.yMin);
        return new Rectangle2D.Float(left, top, right - left, bottom - top);
    }

    protected Rectangle2D getUpperLimitRect() {
        float left = this.getPixelsForSample(this.xMin);
        float top = this.getPixelsForValue(this.yMax);
        float right = this.getPixelsForSample(this.xMax);
        float bottom = this.getPixelsForValue(1.0f);
        return new Rectangle2D.Float(left, top, right - left, bottom - top);
    }

    protected Rectangle2D getLowerLimitRect() {
        float left = this.getPixelsForSample(this.xMin);
        float top = this.getPixelsForValue(0.0f);
        float right = this.getPixelsForSample(this.xMax);
        float bottom = this.getPixelsForValue(this.yMin);
        return new Rectangle2D.Float(left, top, right - left, bottom - top);
    }

    protected Rectangle2D getNormalValueRect() {
        float left = this.getPixelsForSample(this.xMin);
        float top = this.getPixelsForValue(1.0f);
        float right = this.getPixelsForSample(this.xMax);
        float bottom = this.getPixelsForValue(0.0f);
        return new Rectangle2D.Float(left, top, right - left, bottom - top);
    }

    protected Ellipse2D getPlotCircle2D(Point2D point) {
        return new Ellipse2D.Float((float)point.getX() - this.plotCircleRadius / 2.0f, (float)point.getY() - this.plotCircleRadius / 2.0f, this.plotCircleRadius, this.plotCircleRadius);
    }

    protected Color getPlotColor(int index) {
        Color color = null;
        color = index >= this.plotColors.length ? this.plotColors[index % this.plotColors.length] : this.plotColors[index];
        return color;
    }

    protected void drawData(Graphics2D g2) {
        Color color = null;
        g2.setFont(this.scaleFont);
        FontMetrics fm = g2.getFontMetrics(this.scaleFont);
        BasicStroke lineStroke = new BasicStroke(this.valueLineWidth);
        BasicStroke dashStroke = new BasicStroke(this.valueLineWidth, 0, 0, 10.0f, this.yScaleDashPattern, 0.0f);
        for (int i = 0; i < this.data.length; ++i) {
            color = this.getPlotColor(i);
            g2.setColor(color);
            g2.setPaint(color);
            if (this.mode == 0) {
                this.plotValue(g2, fm, lineStroke, dashStroke, i, this.bValueCircle);
                continue;
            }
            this.plotRelativeValue(g2, fm, lineStroke, dashStroke, i, this.bValueCircle);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.data == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object aliasing = this.antiAliasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        Object textAl = this.textAntiAliasing ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aliasing);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textAl);
        if (this.mode == 0) {
            this.setupWorld(g2);
            this.drawCoordinate(g2);
            this.drawData(g2);
        } else {
            this.setupRelativeWorld(g2);
            this.drawRelativeCoordinate(g2);
            this.drawData(g2);
        }
    }

    protected void setupRelativeWorld(Graphics2D g2) {
        if (!this.hasOffset) {
            g2.setFont(this.scaleFont);
            FontMetrics fm = g2.getFontMetrics(this.scaleFont);
            int maxWidth = fm.stringWidth(this.itemName[0]);
            for (int i = 1; i < this.itemName.length; ++i) {
                maxWidth = Math.max(fm.stringWidth(this.itemName[i]), maxWidth);
            }
            this.offsetLeft = maxWidth + 12 + 50;
            this.offsetRight = 12;
            this.offsetTop = 12;
            this.offsetBottom = 20;
            this.hasOffset = true;
        }
        this.xMin = 0.0f;
        this.xMax = this.sampleTime.length;
        this.yMax = 0.0f;
        this.yMin = 0.0f;
        for (int i = 0; i < this.data.length; ++i) {
            float maxVal = (this.maxValue[i] - this.lowerLimit[i]) / (this.upperLimit[i] - this.lowerLimit[i]);
            float minVal = (this.minValue[i] - this.lowerLimit[i]) / (this.upperLimit[i] - this.lowerLimit[i]);
            this.yMax = i == 0 ? maxVal : Math.max(maxVal, this.yMax);
            this.yMin = i == 0 ? minVal : Math.min(minVal, this.yMin);
        }
        this.yMax = this.yMax > 1.0f ? this.yMax : 1.0f;
        this.yMin = this.yMin < 0.0f ? this.yMin : 0.0f;
        int plusCountount = 1;
        while (0.2f * (float)plusCountount <= this.yMax) {
            ++plusCountount;
        }
        int minusCountount = 1;
        while (-0.2f * (float)minusCountount > this.yMin) {
            ++minusCountount;
        }
        this.yMax = 0.2f * (float)plusCountount;
        this.yMin = -0.2f * (float)minusCountount;
        this.hasPixelsPerValue = true;
        this.canvasWidth = this.getCanvasWidth();
        this.canvasHeight = this.getCanvasHeight();
        this.pixelsPerX = this.canvasWidth / (this.xMax - this.xMin);
        this.pixelsPerY = this.canvasHeight / (this.yMax - this.yMin);
        g2.translate(this.offsetLeft, this.offsetTop);
    }

    protected void drawRelativeCoordinate(Graphics2D g2) {
        int j;
        g2.setColor(this.scaleLineColor);
        g2.setStroke(new BasicStroke(this.scaleLineWidth));
        g2.draw(this.getGraphRect());
        g2.setFont(this.scaleFont);
        FontMetrics fm = g2.getFontMetrics(this.scaleFont);
        g2.setColor(this.scaleColor);
        float xp = 0.0f;
        float yp = 0.0f;
        String str = null;
        g2.setStroke(new BasicStroke(this.scaleLineWidth, 0, 0, 10.0f, this.yScaleDashPattern, 0.0f));
        for (j = 1; j < this.sampleTime.length; ++j) {
            xp = this.getPixelsForSampleBound(j);
            g2.draw(new Line2D.Float(new Point2D.Float(xp, 0.0f), new Point2D.Float(xp, this.canvasHeight)));
        }
        for (j = 0; j < this.sampleTime.length; ++j) {
            xp = this.getPixelsForSample(j);
            str = this.sampleTime[j];
            yp = this.canvasHeight + (float)fm.getAscent() + (float)fm.getDescent();
            g2.drawString(str, xp -= (float)fm.stringWidth(str) / 2.0f, yp);
        }
        for (float start = this.yMin + 0.2f; start < this.yMax; start += 0.2f) {
            xp = this.getPixelsForSample(this.xMin);
            yp = this.getPixelsForValue(start);
            Point2D.Float from = new Point2D.Float(xp, yp);
            xp = this.getPixelsForSample(this.xMax);
            Point2D.Float to = new Point2D.Float(xp, yp);
            g2.draw(new Line2D.Float(from, to));
        }
        str = UPPER_LIMIT_STRING;
        xp = this.getPixelsForSample(this.xMax) - (float)fm.stringWidth(str) - 5.0f;
        yp = this.getPixelsForValue(1.0f) - (float)fm.getDescent();
        g2.drawString(str, xp, yp);
        str = LOWER_LIMIT_STRING;
        xp = this.getPixelsForSample(this.xMax) - (float)fm.stringWidth(str) - 5.0f;
        yp = this.getPixelsForValue(0.0f) + (float)fm.getAscent();
        g2.drawString(str, xp, yp);
        str = String.valueOf(this.yMax);
        xp = this.getPixelsForSample(this.xMin) - (float)fm.stringWidth(str) - 5.0f;
        yp = this.getPixelsForValue(this.yMax) + (float)fm.getDescent();
        g2.drawString(str, xp, yp);
        str = RELATIVE_VALUE_STRING;
        xp = xp - (float)fm.stringWidth(str) - 5.0f;
        g2.drawString(str, xp, yp);
        str = String.valueOf(1.0f);
        xp = this.getPixelsForSample(this.xMin) - (float)fm.stringWidth(str) - 5.0f;
        yp = this.getPixelsForValue(1.0f) + (float)fm.getDescent();
        g2.drawString(str, xp, yp);
        str = String.valueOf(0.0f);
        xp = this.getPixelsForSample(this.xMin) - (float)fm.stringWidth(str) - 5.0f;
        yp = this.getPixelsForValue(0.0f) + (float)fm.getDescent();
        g2.drawString(str, xp, yp);
        str = String.valueOf(this.yMin);
        xp = this.getPixelsForSample(this.xMin) - (float)fm.stringWidth(str) - 5.0f;
        yp = this.getPixelsForValue(this.yMin) + (float)fm.getDescent();
        g2.drawString(str, xp, yp);
        Rectangle2D rect = this.getUpperLimitRect();
        g2.setPaint(this.upperLimitColor);
        int rule = 3;
        g2.setComposite(AlphaComposite.getInstance(rule, this.valueAreaAlpha));
        g2.fill(rect);
        rect = this.getNormalValueRect();
        g2.setPaint(this.normalAreaColor);
        g2.fill(rect);
        rect = this.getLowerLimitRect();
        g2.setPaint(this.lowerLimitColor);
        g2.fill(rect);
    }

    protected void plotRelativeValue(Graphics2D g2, FontMetrics fm, BasicStroke lineStroke, BasicStroke dashStroke, int index, boolean circle) {
        int sampleCount = this.sampleTime.length;
        float up = this.upperLimit[index];
        float low = this.lowerLimit[index];
        if (up == -9999.99f || low == -9999.99f) {
            return;
        }
        float scale = up - low;
        float x = 0.0f;
        float y = 0.0f;
        Point2D.Float fromP = null;
        Point2D.Float toP = null;
        boolean firstValue = true;
        String str = this.itemName[index];
        float xe = this.getPixelsForSample(this.xMin) - (float)fm.stringWidth(str) - 50.0f;
        float space = fm.getAscent() + fm.getDescent() + fm.getLeading();
        float ye = this.getPixelsForValue(1.0f) + (float)index * space;
        g2.drawString(str, xe, ye);
        xe += (float)fm.stringWidth(str);
        for (int j = 0; j < sampleCount - 1; ++j) {
            if (this.data[index][j] == -9999.99f) continue;
            x = this.getPixelsForSample(j);
            y = (this.data[index][j] - low) / scale;
            y = this.getPixelsForValue(y);
            if (firstValue) {
                fromP = new Point2D.Float(xe, ye);
                toP = new Point2D.Float(x, y);
                g2.setStroke(dashStroke);
                g2.draw(new Line2D.Float(fromP, toP));
                g2.setStroke(lineStroke);
                firstValue = false;
            }
            fromP = new Point2D.Float(x, y);
            if (circle) {
                g2.fill(this.getPlotCircle2D(fromP));
            }
            if (this.data[index][j + 1] != -9999.99f) {
                x = this.getPixelsForSample(j + 1);
                y = (this.data[index][j + 1] - low) / scale;
                y = this.getPixelsForValue(y);
                toP = new Point2D.Float(x, y);
                g2.draw(new Line2D.Float(fromP, toP));
                continue;
            }
            if (!circle) continue;
            g2.fill(this.getPlotCircle2D(fromP));
        }
        if (this.data[index][sampleCount - 1] != -9999.99f && circle) {
            x = this.getPixelsForSample(sampleCount - 1);
            y = (this.data[index][sampleCount - 1] - low) / scale;
            y = this.getPixelsForValue(y);
            fromP = new Point2D.Float(x, y);
            g2.fill(this.getPlotCircle2D(fromP));
        }
    }

    protected Object[] getScale(float max, float min) {
        double start;
        float value = max - min;
        double[] base = new double[]{1.0, 2.0, 5.0, 10.0};
        int keta = this.getFigureNumber(max - min);
        double k = Math.pow(10.0, keta - 2);
        double nearestToTen = 0.0;
        double val = 0.0;
        int index = 0;
        for (int i = 0; i < base.length; ++i) {
            val = (double)value / (k * base[i]);
            if (i == 0) {
                nearestToTen = Math.abs(val - 10.0);
                index = 0;
                continue;
            }
            if (!(Math.abs(val - 10.0) < nearestToTen)) continue;
            nearestToTen = Math.abs(val - 10.0);
            index = i;
        }
        double unit = k * base[index];
        ArrayList<String> ret = new ArrayList<String>();
        if (min < 0.0f) {
            for (start = 0.0; start > (double)min; start -= unit) {
            }
        }
        while (start < (double)max) {
            ret.add(String.valueOf((float)start));
            start += unit;
        }
        ret.add(String.valueOf((float)start));
        return ret.toArray();
    }

    protected int getFigureNumber(float value) {
        if (value >= 1.0f) {
            int keta = 1;
            while (Math.pow(10.0, keta) < (double)value) {
                ++keta;
            }
            return keta;
        }
        int keta = 1;
        return keta;
    }

    protected void setupWorld(Graphics2D g2) {
        if (!this.hasOffset) {
            g2.setFont(this.scaleFont);
            FontMetrics fm = g2.getFontMetrics(this.scaleFont);
            int maxWidth = fm.stringWidth(this.itemName[0]);
            for (int i = 1; i < this.itemName.length; ++i) {
                maxWidth = Math.max(fm.stringWidth(this.itemName[i]), maxWidth);
            }
            this.offsetLeft = maxWidth + 12 + 50;
            this.offsetRight = 12;
            this.offsetTop = 12;
            this.offsetBottom = 20;
            this.hasOffset = true;
        }
        this.xMin = 0.0f;
        this.xMax = this.sampleTime.length;
        this.yMax = 0.0f;
        this.yMin = 0.0f;
        for (int i = 0; i < this.data.length; ++i) {
            float maxVal = this.maxValue[i];
            float minVal = this.minValue[i];
            maxVal = this.upperLimit[i] != -9999.99f ? Math.max(maxVal, this.upperLimit[i]) : maxVal;
            minVal = this.lowerLimit[i] != -9999.99f ? Math.min(minVal, this.lowerLimit[i]) : minVal;
            this.yMax = i == 0 ? maxVal : Math.max(maxVal, this.yMax);
            this.yMin = i == 0 ? minVal : Math.min(minVal, this.yMin);
        }
        this.yMin = this.yMin >= 0.0f ? 0.0f : this.yMin;
        this.yScales = this.getScale(this.yMax, this.yMin);
        this.yMax = Float.parseFloat((String)this.yScales[this.yScales.length - 1]);
        this.yMin = Float.parseFloat((String)this.yScales[0]);
        this.hasPixelsPerValue = true;
        this.canvasWidth = this.getCanvasWidth();
        this.canvasHeight = this.getCanvasHeight();
        this.pixelsPerX = this.canvasWidth / (this.xMax - this.xMin);
        this.pixelsPerY = this.canvasHeight / (this.yMax - this.yMin);
        g2.translate(this.offsetLeft, this.offsetTop);
    }

    protected void drawCoordinate(Graphics2D g2) {
        int j;
        g2.setColor(this.scaleLineColor);
        g2.setStroke(new BasicStroke(this.scaleLineWidth));
        g2.draw(this.getGraphRect());
        g2.setFont(this.scaleFont);
        FontMetrics fm = g2.getFontMetrics(this.scaleFont);
        g2.setColor(this.scaleColor);
        float xp = 0.0f;
        float yp = 0.0f;
        String str = null;
        g2.setStroke(new BasicStroke(this.scaleLineWidth, 0, 0, 10.0f, this.yScaleDashPattern, 0.0f));
        for (j = 1; j < this.sampleTime.length; ++j) {
            xp = this.getPixelsForSampleBound(j);
            g2.draw(new Line2D.Float(new Point2D.Float(xp, 0.0f), new Point2D.Float(xp, this.canvasHeight)));
        }
        for (j = 0; j < this.sampleTime.length; ++j) {
            xp = this.getPixelsForSample(j);
            str = this.sampleTime[j];
            yp = this.canvasHeight + (float)fm.getAscent() + (float)fm.getDescent();
            g2.drawString(str, xp -= (float)fm.stringWidth(str) / 2.0f, yp);
        }
        for (int i = 0; i < this.yScales.length; ++i) {
            yp = Float.parseFloat((String)this.yScales[i]);
            yp = this.getPixelsForValue(yp);
            g2.draw(new Line2D.Float(new Point2D.Float(0.0f, yp), new Point2D.Float(this.canvasWidth, yp)));
            str = (String)this.yScales[i];
            xp = 0.0f - (float)fm.stringWidth(str) - 2.0f;
            g2.drawString(str, xp, yp += (float)fm.getDescent());
        }
    }

    protected void plotValue(Graphics2D g2, FontMetrics fm, BasicStroke lineStroke, BasicStroke dashStroke, int index, boolean circle) {
        int sampleCount = this.sampleTime.length;
        float x = 0.0f;
        float y = 0.0f;
        Point2D.Float fromP = null;
        Point2D.Float toP = null;
        boolean firstValue = true;
        String str = this.itemName[index];
        float xe = this.getPixelsForSample(this.xMin) - (float)fm.stringWidth(str) - 50.0f;
        float space = fm.getAscent() + fm.getDescent() + fm.getLeading();
        float ye = this.getPixelsForValue(2.0f * this.yMax / 3.0f) + (float)index * space;
        g2.drawString(str, xe, ye);
        xe += (float)fm.stringWidth(str);
        for (int j = 0; j < sampleCount - 1; ++j) {
            if (this.data[index][j] == -9999.99f) continue;
            x = this.getPixelsForSample(j);
            y = this.data[index][j];
            y = this.getPixelsForValue(y);
            if (firstValue) {
                fromP = new Point2D.Float(xe, ye);
                toP = new Point2D.Float(x, y);
                g2.setStroke(dashStroke);
                g2.draw(new Line2D.Float(fromP, toP));
                g2.setStroke(lineStroke);
                firstValue = false;
            }
            fromP = new Point2D.Float(x, y);
            if (circle) {
                g2.fill(this.getPlotCircle2D(fromP));
            }
            if (this.data[index][j + 1] != -9999.99f) {
                x = this.getPixelsForSample(j + 1);
                y = this.data[index][j + 1];
                y = this.getPixelsForValue(y);
                toP = new Point2D.Float(x, y);
                g2.draw(new Line2D.Float(fromP, toP));
                continue;
            }
            if (!circle) continue;
            g2.fill(this.getPlotCircle2D(fromP));
        }
        if (this.data[index][sampleCount - 1] != -9999.99f && circle) {
            x = this.getPixelsForSample(sampleCount - 1);
            y = this.data[index][sampleCount - 1];
            y = this.getPixelsForValue(y);
            fromP = new Point2D.Float(x, y);
            g2.fill(this.getPlotCircle2D(fromP));
        }
        if (this.data.length == 1) {
            this.drawUpperLowerLine(g2, fm);
        }
    }

    private void drawUpperLowerLine(Graphics2D g2, FontMetrics fm) {
        String unit;
        float up = this.upperLimit[0];
        float low = this.lowerLimit[0];
        float xp = 0.0f;
        float yp = 0.0f;
        Point2D.Float from = null;
        Point2D.Float to = null;
        if (up != -9999.99f) {
            xp = this.getPixelsForSample(this.xMin);
            yp = this.getPixelsForValue(up);
            from = new Point2D.Float(xp, yp);
            xp = this.getPixelsForSample(this.xMax);
            to = new Point2D.Float(xp, yp);
            g2.setColor(this.upperLimitColor);
            g2.draw(new Line2D.Float(from, to));
        }
        if (low != -9999.99f) {
            xp = this.getPixelsForSample(this.xMin);
            yp = this.getPixelsForValue(low);
            from = new Point2D.Float(xp, yp);
            xp = this.getPixelsForSample(this.xMax);
            to = new Point2D.Float(xp, yp);
            g2.setColor(this.lowerLimitColor);
            g2.draw(new Line2D.Float(from, to));
        }
        if ((unit = this.itemUnit[0]) != null) {
            xp = this.getPixelsForSample(this.xMin) - (float)fm.stringWidth(unit) - (float)fm.stringWidth((String)this.yScales[this.yScales.length - 1]) - 5.0f;
            yp = this.getPixelsForValue(this.yMax) + (float)fm.getDescent();
            g2.setColor(this.scaleColor);
            g2.drawString(unit, xp, yp);
        }
    }
}

