/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.karte;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.EventHandler;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.karte.AllergyPanel;
import open.dolphin.client.karte.BasicInfoPanel;
import open.dolphin.client.karte.DocumentHistoryPanel;
import open.dolphin.client.karte.PhysicalPanel;
import open.dolphin.component.DnDTabbedPane;
import open.dolphin.component.TabTransferHandler;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.project.GlobalConstants;
import org.jdesktop.application.ApplicationContext;

public class PatientInspector
extends JPanel
implements IChartDocument {
    public static final String TITLE = "\u30a4\u30f3\u30b9\u30da\u30af\u30bf";
    private BasicInfoPanel basicInfoInspector;
    private DocumentHistoryPanel docHistory;
    private List<JTabbedPane> tabbedPanels;
    private String keyword;
    private IChart parent;
    private String title = "\u30a4\u30f3\u30b9\u30da\u30af\u30bf";
    private JPanel inspector;
    private JScrollPane jScrollPane1;

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.PatientInspector;
    }

    public PatientInspector(IChart parent, String keyword) {
        this.keyword = keyword;
        this.parent = parent;
        this.tabbedPanels = new ArrayList<JTabbedPane>();
        this.initComponents();
        this.initCustomComponents();
        this.setBounds((Rectangle)this.loadLayout("layout", this.getBounds()));
        this.applyTabLocations((Properties)this.loadLayout("tabLocation", this.initialTabLocations()));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.inspector = new JPanel();
        this.setName(TITLE);
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setName("jScrollPane1");
        this.inspector.setName("inspector");
        this.inspector.setLayout(new BoxLayout(this.inspector, 1));
        this.jScrollPane1.setViewportView(this.inspector);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void release() {
        this.saveLayout("tabLocation", this.getTabLocations());
        this.saveLayout("layout", this.getBounds());
    }

    public void dispose() {
        this.docHistory.clear();
        ((AllergyPanel)this.parent.getChartDocument("\u30a2\u30ec\u30eb\u30ae")).clear();
        ((PhysicalPanel)this.parent.getChartDocument("\u8eab\u9577\u4f53\u91cd")).clear();
    }

    private Serializable initialTabLocations() {
        Properties result = new Properties();
        result.setProperty("\u6587\u66f8\u5c65\u6b74", "0");
        result.setProperty("\u30e1\u30e2", "0");
        result.setProperty("\u30a2\u30ec\u30eb\u30ae", "1");
        result.setProperty("\u8eab\u9577\u4f53\u91cd", "1");
        result.setProperty("\u6765\u9662\u6b74", "2");
        result.setProperty("ORCA Do", "2");
        return result;
    }

    private Serializable loadLayout(String type, Serializable defaultValue) {
        Serializable result = null;
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        try {
            result = (Serializable)appCtx.getLocalStorage().load(this.getClass().getName() + "." + type + ".xml");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private void saveLayout(String type, Serializable layout) {
        try {
            GlobalConstants.getLocalStorage().save((Object)layout, this.getClass().getName() + "." + type + ".xml");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void applyTabLocations(Properties layout) {
        Enumeration<?> e = layout.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            int value = Integer.parseInt(layout.getProperty(key));
            this.tabbedPanels.get(value).addTab(key, (Component)((Object)this.parent.getChartDocument(key)));
        }
    }

    private Properties getTabLocations() {
        Properties result = new Properties();
        int panel_index = 0;
        for (JTabbedPane pane : this.tabbedPanels) {
            for (int index = 0; index < pane.getComponents().length; ++index) {
                if (!((IChartDocument)((Object)pane.getComponentAt(index))).itLayoutSaved()) continue;
                result.setProperty(pane.getTitleAt(index), Integer.toString(panel_index));
            }
            ++panel_index;
        }
        return result;
    }

    private void initCustomComponents() {
        this.basicInfoInspector = new BasicInfoPanel(this.getParentContext());
        DnDTabbedPane tabbedPane = null;
        for (int index = 0; index < 3; ++index) {
            tabbedPane = new DnDTabbedPane();
            tabbedPane.addChangeListener(EventHandler.create(ChangeListener.class, this, "tabChanged", ""));
            tabbedPane.setTransferHandler(new TabTransferHandler());
            this.tabbedPanels.add(tabbedPane);
        }
        for (JTabbedPane pane : this.tabbedPanels) {
            this.inspector.add(pane);
        }
    }

    public void tabChanged(ChangeEvent e) {
        DnDTabbedPane tabbedPane = (DnDTabbedPane)e.getSource();
        int index = tabbedPane.getSelectedIndex();
        String title = tabbedPane.getTitleAt(index);
        Component component = (Component)((Object)this.parent.getChartDocument(title));
        IChartDocument documentPanel = null;
        documentPanel = component instanceof JScrollPane ? (IChartDocument)((Object)((JViewport)((JScrollPane)component).getComponent(0)).getComponent(0)) : (IChartDocument)((Object)component);
        documentPanel.enter();
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    public KarteBean getKarte() {
        return this.getParentContext().getKarte();
    }

    public PatientModel getPatient() {
        return this.getParentContext().getKarte().getPatient();
    }

    public BasicInfoPanel getBasicInfoInspector() {
        return this.basicInfoInspector;
    }

    public DocumentHistoryPanel getDocumentHistory() {
        return this.docHistory;
    }

    public void setDocumentHistory(DocumentHistoryPanel docHistory) {
        this.docHistory = docHistory;
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        for (JTabbedPane tabbedPane : this.tabbedPanels) {
            for (Component component : tabbedPane.getComponents()) {
                if (!((IChartDocument)((Object)component)).isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return this.tabbedPanels;
    }
}

