/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import open.dolphin.client.AbstractCodeHelper;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.KartePane;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;

public class PCodeHelper
extends AbstractCodeHelper {
    public PCodeHelper(KartePane pPane, ChartMediator mediator) {
        super(pPane, mediator);
    }

    @Override
    protected void buildPopup(String text) {
        String test = text.toLowerCase();
        String entity = null;
        Preferences prefs = Preferences.userNodeForPackage(AbstractCodeHelper.class);
        if (prefs.get("text", "tx").startsWith(test)) {
            entity = "text";
        } else if (prefs.get("path", "pat").startsWith(test)) {
            entity = "path";
        } else if (prefs.get("generalOrder", "gen").startsWith(test)) {
            entity = "generalOrder";
        } else if (prefs.get("otherOrder", "oth").startsWith(test)) {
            entity = "otherOrder";
        } else if (prefs.get("treatmentOrder", "tr").startsWith(test)) {
            entity = "treatmentOrder";
        } else if (prefs.get("surgeryOrder", "sur").startsWith(test)) {
            entity = "surgeryOrder";
        } else if (prefs.get("radiologyOrder", "rad").startsWith(test)) {
            entity = "radiologyOrder";
        } else if (prefs.get("testOrder", "lab").startsWith(test)) {
            entity = "testOrder";
        } else if (prefs.get("physiologyOrder", "phy").startsWith(test)) {
            entity = "physiologyOrder";
        } else if (prefs.get("injectionOrder", "inj").startsWith(test)) {
            entity = "injectionOrder";
        } else if (prefs.get("medOrder", "rp").startsWith(test)) {
            entity = "medOrder";
        } else if (prefs.get("baseChargeOrder", "base").startsWith(test)) {
            entity = "baseChargeOrder";
        } else if (prefs.get("instractionChargeOrder", "ins").startsWith(test)) {
            entity = "instractionChargeOrder";
        } else if (prefs.get("stayOnHomeChargeOrder", "sty").startsWith(test)) {
            entity = "stayOnHomeChargeOrder";
        } else if (prefs.get("orcaSet", "orca").startsWith(test)) {
            entity = "orcaSet";
        }
        if (entity != null) {
            this.buildEntityPopup(entity);
        } else {
            this.buildMatchPopup(text);
        }
    }

    protected void buildMatchPopup(String text) {
        StampBoxFrame stampBox = this.mediator.getStampBox();
        List<StampTree> allTree = stampBox.getAllPTrees();
        if (allTree == null || allTree.isEmpty()) {
            return;
        }
        this.popup = new JPopupMenu();
        LinkedList<JComponent> menus = new LinkedList<JComponent>();
        menus.addFirst(this.popup);
        LinkedList<StampTreeNode> parents = new LinkedList<StampTreeNode>();
        this.pattern = Pattern.compile("^" + text + ".*");
        for (StampTree tree : allTree) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)tree.getModel().getRoot();
            Enumeration<TreeNode> e = rootNode.preorderEnumeration();
            if (e == null) continue;
            e.nextElement();
            while (e.hasMoreElements()) {
                String completion;
                ModuleInfoBean info;
                StampTreeNode node = (StampTreeNode)e.nextElement();
                StampTreeNode parent = (StampTreeNode)node.getParent();
                int index = parents.indexOf(parent);
                if (index > -1) {
                    JMenuItem item;
                    for (int i = 0; i < index; ++i) {
                        parents.removeFirst();
                        menus.removeFirst();
                    }
                    if (!node.isLeaf()) {
                        String folderName = node.getUserObject().toString();
                        JMenu subMenu = new JMenu(folderName);
                        if (menus.getFirst() instanceof JPopupMenu) {
                            ((JPopupMenu)menus.getFirst()).add(subMenu);
                        } else {
                            ((JMenu)menus.getFirst()).add(subMenu);
                        }
                        menus.addFirst(subMenu);
                        parents.addFirst(node);
                        item = new JMenuItem(folderName);
                        item.setIcon(icon);
                        subMenu.add(item);
                        this.addActionListner(item, node);
                        continue;
                    }
                    info = (ModuleInfoBean)node.getUserObject();
                    completion = info.getStampName();
                    item = new JMenuItem(completion);
                    this.addActionListner(item, node);
                    if (menus.getFirst() instanceof JPopupMenu) {
                        ((JPopupMenu)menus.getFirst()).add(item);
                        continue;
                    }
                    ((JMenu)menus.getFirst()).add(item);
                    continue;
                }
                if (!node.isLeaf()) {
                    String completion2 = node.getUserObject().toString();
                    Matcher matcher = this.pattern.matcher(completion2);
                    if (!matcher.matches()) continue;
                    String folderName = node.getUserObject().toString();
                    JMenu subMenu = new JMenu(folderName);
                    if (menus.getFirst() instanceof JPopupMenu) {
                        ((JPopupMenu)menus.getFirst()).add(subMenu);
                    } else {
                        ((JMenu)menus.getFirst()).add(subMenu);
                    }
                    menus.addFirst(subMenu);
                    parents.addFirst(node);
                    JMenuItem item = new JMenuItem(folderName);
                    item.setIcon(icon);
                    subMenu.add(item);
                    this.addActionListner(item, node);
                    continue;
                }
                info = (ModuleInfoBean)node.getUserObject();
                completion = info.getStampName();
                Matcher matcher = this.pattern.matcher(completion);
                if (!matcher.matches()) continue;
                JMenuItem item = new JMenuItem(completion);
                this.addActionListner(item, node);
                if (menus.getFirst() instanceof JPopupMenu) {
                    ((JPopupMenu)menus.getFirst()).add(item);
                    continue;
                }
                ((JMenu)menus.getFirst()).add(item);
            }
        }
    }
}

