/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import open.dolphin.client.ImageEntry;
import open.dolphin.client.ImageEntryTransferable;
import open.dolphin.client.ImageTableModel;
import open.dolphin.log.LogWriter;

public class ImagePalette
extends JPanel
implements DragSourceListener,
DragGestureListener {
    private static final int DEFAULT_COLUMN_COUNT = 3;
    private static final int DEFAULT_IMAGE_WIDTH = 120;
    private static final int DEFAULT_IMAGE_HEIGHT = 120;
    private static final String[] DEFAULT_IMAGE_SUFFIX = new String[]{".jpg"};
    private ImageTableModel imageTableModel;
    private int imageWidth;
    private int imageHeight;
    private JTable imageTable;
    private DragSource dragSource;
    private File imageDirectory;
    private String[] suffix = DEFAULT_IMAGE_SUFFIX;
    private boolean showHeader;

    public ImagePalette(String[] columnNames, int columnCount, int imageWidth, int imageHeight) {
        this.imageTableModel = new ImageTableModel(columnNames, columnCount);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.initCustomComponents(columnCount);
        this.connect();
    }

    public ImagePalette() {
        this(null, 3, 120, 120);
    }

    public List getImageList() {
        return this.imageTableModel.getImageList();
    }

    public void setImageList(List list) {
        this.imageTableModel.setImageList(list);
    }

    public JTable getable() {
        return this.imageTable;
    }

    public String[] getimageSuffix() {
        return this.suffix;
    }

    public void setImageSuffix(String[] suffix) {
        this.suffix = suffix;
    }

    public File getImageDirectory() {
        return this.imageDirectory;
    }

    public void setImageDirectory(File imageDirectory) {
        this.imageDirectory = imageDirectory;
        this.refresh();
    }

    public void dispose() {
        if (this.imageTableModel != null) {
            this.imageTableModel.clear();
        }
    }

    public void refresh() {
        if (!this.imageDirectory.exists() || !this.imageDirectory.isDirectory()) {
            return;
        }
        Dimension imageSize = new Dimension(this.imageWidth, this.imageHeight);
        File[] imageFiles = this.listImageFiles(this.imageDirectory, this.suffix);
        if (imageFiles != null && imageFiles.length > 0) {
            ArrayList<ImageEntry> imageList = new ArrayList<ImageEntry>();
            for (int j = 0; j < imageFiles.length; ++j) {
                try {
                    URL url = imageFiles[j].toURI().toURL();
                    ImageIcon icon = new ImageIcon(url);
                    ImageEntry entry = new ImageEntry();
                    entry.setImageIcon(this.adjustImageSize(icon, imageSize));
                    entry.setUrl(url.toString());
                    imageList.add(entry);
                    continue;
                }
                catch (Exception e) {
                    LogWriter.error(this.getClass(), e);
                }
            }
            this.imageTableModel.setImageList(imageList);
        }
    }

    private void initCustomComponents(int columnCount) {
        this.imageTable = new JTable(this.imageTableModel);
        this.imageTable.setSelectionMode(0);
        this.imageTable.setCellSelectionEnabled(true);
        this.imageTable.setAutoResizeMode(0);
        TableColumn column = null;
        for (int i = 0; i < columnCount; ++i) {
            column = this.imageTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.imageWidth);
        }
        this.imageTable.setRowHeight(this.imageHeight);
        ImageRenderer imageRenderer = new ImageRenderer();
        imageRenderer.setHorizontalAlignment(0);
        this.imageTable.setDefaultRenderer(Object.class, imageRenderer);
        this.setLayout(new BorderLayout());
        if (this.showHeader) {
            this.add(new JScrollPane(this.imageTable));
        } else {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(this.imageTable);
            this.add(new JScrollPane(panel));
        }
    }

    private void connect() {
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.imageTable, 3, this);
    }

    private ImageIcon adjustImageSize(ImageIcon icon, Dimension dim) {
        if (icon.getIconHeight() > dim.height || icon.getIconWidth() > dim.width) {
            int w;
            int h;
            float wRatio;
            Image img = icon.getImage();
            float hRatio = (float)icon.getIconHeight() / (float)dim.height;
            if (hRatio > (wRatio = (float)icon.getIconWidth() / (float)dim.width)) {
                h = dim.height;
                w = (int)((float)icon.getIconWidth() / hRatio);
            } else {
                w = dim.width;
                h = (int)((float)icon.getIconHeight() / wRatio);
            }
            img = img.getScaledInstance(w, h, 4);
            return new ImageIcon(img);
        }
        return icon;
    }

    private File[] listImageFiles(File dir, String[] suffix) {
        ImageFileFilter filter = new ImageFileFilter(suffix);
        return dir.listFiles(filter);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        try {
            int row = this.imageTable.getSelectedRow();
            int col = this.imageTable.getSelectedColumn();
            if (row != -1 && col != -1) {
                ImageEntry entry = (ImageEntry)this.imageTable.getValueAt(row, col);
                ImageEntryTransferable t = new ImageEntryTransferable(entry);
                this.dragSource.startDrag(event, DragSource.DefaultCopyDrop, t, this);
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    class ImageRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -7952145522385412194L;

        public ImageRenderer() {
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            Component compo = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
            JLabel l = (JLabel)compo;
            if (value != null) {
                ImageEntry entry = (ImageEntry)value;
                l.setIcon(entry.getImageIcon());
                l.setText(null);
            } else {
                l.setIcon(null);
                l.setText(null);
            }
            return compo;
        }
    }

    class ImageFileFilter
    implements FilenameFilter {
        private String[] suffix;

        public ImageFileFilter(String[] suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean accept = false;
            for (int i = 0; i < this.suffix.length; ++i) {
                if (!name.toLowerCase().endsWith(this.suffix[i])) continue;
                accept = true;
                break;
            }
            return accept;
        }
    }
}

