/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import open.dolphin.project.GlobalSettings;

public class CompletableJTextField
extends JTextField
implements ListSelectionListener {
    Completer completer = new Completer();
    JList completionList;
    DefaultListModel completionListModel = new DefaultListModel();
    JScrollPane listScroller;

    public CompletableJTextField(int col) {
        super(col);
        this.completionList = new JList(this.completionListModel);
        this.completionList.setSelectionMode(0);
        this.completionList.addListSelectionListener(this);
        this.listScroller = new JScrollPane(this.completionList, 20, 31);
        this.listScroller.setVisible(false);
        this.listScroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
    }

    protected void addCompletion(String s) {
        this.completer.addCompletion(s);
    }

    private void removeCompletion(String s) {
        this.completer.removeCompletion(s);
    }

    private void clearCompletions(String s) {
        this.completer.clearCompletions();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.completionList.getModel().getSize() == 0) {
            return;
        }
        this.listScroller.setVisible(false);
        final String completionString = (String)this.completionList.getSelectedValue();
        Thread worker = new Thread(){

            @Override
            public void run() {
                CompletableJTextField.this.setText(completionString);
            }
        };
        SwingUtilities.invokeLater(worker);
    }

    class Completer
    implements DocumentListener {
        private Pattern pattern;
        private List completions = new ArrayList();

        private Completer() {
            CompletableJTextField.this.getDocument().addDocumentListener(this);
        }

        private void addCompletion(String s) {
            this.completions.add(s);
            this.buildAndShowPopup();
        }

        private void removeCompletion(String s) {
            this.completions.remove(s);
            this.buildAndShowPopup();
        }

        private void clearCompletions() {
            this.completions.clear();
            this.buildPopup();
            CompletableJTextField.this.listScroller.setVisible(false);
        }

        private void buildPopup() {
            CompletableJTextField.this.completionListModel.clear();
            Iterator it = this.completions.iterator();
            this.pattern = Pattern.compile(CompletableJTextField.this.getText() + ".+");
            while (it.hasNext()) {
                String completion = (String)it.next();
                Matcher matcher = this.pattern.matcher(completion);
                if (!matcher.matches()) continue;
                CompletableJTextField.this.completionListModel.add(CompletableJTextField.this.completionListModel.getSize(), completion);
            }
        }

        private void showPopup() {
            if (CompletableJTextField.this.completionListModel.getSize() == 0) {
                CompletableJTextField.this.listScroller.setVisible(false);
                return;
            }
            int pos = CompletableJTextField.this.getCaretPosition();
            try {
                Rectangle r = CompletableJTextField.this.modelToView(pos);
                CompletableJTextField.this.listScroller.setBounds(r.x, r.y, 200, 300);
                CompletableJTextField.this.listScroller.setVisible(true);
                CompletableJTextField.this.listScroller.requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void buildAndShowPopup() {
            if (CompletableJTextField.this.getText().length() < 1) {
                return;
            }
            this.buildPopup();
            this.showPopup();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.buildAndShowPopup();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.buildAndShowPopup();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.buildAndShowPopup();
        }
    }
}

