/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DicomException;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

final class RLEReader {
    private final byte[] buf = new byte[16384];
    int pos;
    int len;

    RLEReader() {
    }

    private final byte nextByte(ImageInputStream imageInputStream) throws IOException {
        while (this.pos >= this.len) {
            this.len = imageInputStream.read(this.buf, 0, this.buf.length);
            if (this.len < 0) {
                throw new EOFException();
            }
            this.pos = 0;
        }
        return this.buf[this.pos++];
    }

    private final void seek(ImageInputStream imageInputStream, long l) throws IOException {
        this.len = 0;
        imageInputStream.seek(l);
    }

    void readRLEImage(ImageInputStream imageInputStream, Raster raster, int n, int n2) throws IOException {
        block32: {
            int n3;
            long[] lArray;
            int n4;
            int n5;
            int n6;
            DataBuffer dataBuffer;
            long l;
            block31: {
                l = imageInputStream.getStreamPosition();
                int n7 = raster.getWidth() * raster.getHeight();
                dataBuffer = raster.getDataBuffer();
                n6 = raster.getNumBands();
                n5 = dataBuffer.getSize();
                imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                n4 = imageInputStream.readInt();
                lArray = new long[15];
                for (n3 = 0; n3 < 15; ++n3) {
                    lArray[n3] = (long)imageInputStream.readInt() & 0xFFFFFFFFL;
                }
                if (n != 8) break block31;
                if (n4 != n6) {
                    throw new DicomException("ProtocoleViolation", "Invalid number of RLE bands");
                }
                for (n3 = 0; n3 < n6; ++n3) {
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    this.seek(imageInputStream, l + lArray[n3]);
                    if (n2 == 1 && n3 > 0) {
                        n11 = n3;
                        while (n11 < n5) {
                            n10 = this.nextByte(imageInputStream);
                            if (n10 >= 0) {
                                for (n9 = n10; n9 >= 0; --n9) {
                                    n8 = this.nextByte(imageInputStream);
                                    dataBuffer.setElem(n11, n8);
                                    dataBuffer.setElem(n11 += n6, n8);
                                    n11 += n6;
                                }
                                continue;
                            }
                            if (n10 == -128) continue;
                            n9 = this.nextByte(imageInputStream);
                            for (n8 = n10; n8 <= 0; ++n8) {
                                dataBuffer.setElem(n11, n9);
                                dataBuffer.setElem(n11 += n6, n9);
                                n11 += n6;
                            }
                        }
                        continue;
                    }
                    n11 = n3;
                    while (n11 < n5) {
                        n10 = this.nextByte(imageInputStream);
                        if (n10 >= 0) {
                            for (n9 = n10; n9 >= 0; --n9) {
                                dataBuffer.setElem(n11, this.nextByte(imageInputStream));
                                n11 += n6;
                            }
                            continue;
                        }
                        if (n10 == -128) continue;
                        n9 = this.nextByte(imageInputStream);
                        for (n8 = n10; n8 <= 0; ++n8) {
                            dataBuffer.setElem(n11, n9);
                            n11 += n6;
                        }
                    }
                }
                break block32;
            }
            if (n != 16) break block32;
            if (n4 != 2 * n6) {
                throw new DicomException("ProtocoleViolation", "Invalid number of RLE bands");
            }
            for (n3 = 0; n3 < n6; ++n3) {
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                if (n2 == 1 && n3 > 0) {
                    this.seek(imageInputStream, l + lArray[2 * n3]);
                    n16 = n3;
                    while (n16 < n5) {
                        n15 = this.nextByte(imageInputStream);
                        if (n15 >= 0) {
                            for (n14 = n15; n14 >= 0; --n14) {
                                n13 = (this.nextByte(imageInputStream) & 0xFF) << 8;
                                dataBuffer.setElem(n16, n13);
                                dataBuffer.setElem(n16 += n6, n13);
                                n16 += n6;
                            }
                            continue;
                        }
                        if (n15 == -128) continue;
                        n14 = this.nextByte(imageInputStream) & 0xFF;
                        for (n13 = n15; n13 <= 0; ++n13) {
                            dataBuffer.setElem(n16, n14 << 8);
                            dataBuffer.setElem(n16 += n6, n14 << 8);
                            n16 += n6;
                        }
                    }
                    this.seek(imageInputStream, l + lArray[2 * n3 + 1]);
                    n16 = n3;
                    while (n16 < n5) {
                        n15 = this.nextByte(imageInputStream);
                        if (n15 >= 0) {
                            for (n14 = n15; n14 >= 0; --n14) {
                                n13 = dataBuffer.getElem(n16);
                                n12 = n13 | this.nextByte(imageInputStream) & 0xFF;
                                dataBuffer.setElem(n16, n12);
                                dataBuffer.setElem(n16 += n6, n12);
                                n16 += n6;
                            }
                            continue;
                        }
                        if (n15 == -128) continue;
                        n14 = this.nextByte(imageInputStream) & 0xFF;
                        for (n13 = n15; n13 <= 0; ++n13) {
                            n12 = dataBuffer.getElem(n16) | n14;
                            dataBuffer.setElem(n16, n12);
                            dataBuffer.setElem(n16 += n6, n12);
                            n16 += n6;
                        }
                    }
                    continue;
                }
                this.seek(imageInputStream, l + lArray[2 * n3]);
                n16 = n3;
                while (n16 < n5) {
                    n15 = this.nextByte(imageInputStream);
                    if (n15 >= 0) {
                        for (n14 = n15; n14 >= 0; --n14) {
                            dataBuffer.setElem(n16, (this.nextByte(imageInputStream) & 0xFF) << 8);
                            n16 += n6;
                        }
                        continue;
                    }
                    if (n15 == -128) continue;
                    n14 = this.nextByte(imageInputStream) & 0xFF;
                    for (n13 = n15; n13 <= 0; ++n13) {
                        dataBuffer.setElem(n16, n14 << 8);
                        n16 += n6;
                    }
                }
                this.seek(imageInputStream, l + lArray[2 * n3 + 1]);
                n16 = n3;
                while (n16 < n5) {
                    n15 = this.nextByte(imageInputStream);
                    if (n15 >= 0) {
                        for (n14 = n15; n14 >= 0; --n14) {
                            n13 = dataBuffer.getElem(n16);
                            dataBuffer.setElem(n16, n13 | this.nextByte(imageInputStream) & 0xFF);
                            n16 += n6;
                        }
                        continue;
                    }
                    if (n15 == -128) continue;
                    n14 = this.nextByte(imageInputStream) & 0xFF;
                    for (n13 = n15; n13 <= 0; ++n13) {
                        n12 = dataBuffer.getElem(n16);
                        dataBuffer.setElem(n16, n12 | n14);
                        n16 += n6;
                    }
                }
            }
        }
    }
}

