/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventHandler;
import java.io.File;
import java.io.FileFilter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import open.dolphin.client.AbstractMainTool;
import open.dolphin.client.ImagePalette;
import open.dolphin.helper.ComponentMemory;
import open.dolphin.project.GlobalConstants;

public class ImageBox
extends AbstractMainTool {
    private static final int DEFAULT_COLUMN_COUNT = 3;
    private static final int DEFAULT_IMAGE_WIDTH = 120;
    private static final int DEFAULT_IMAGE_HEIGHT = 120;
    private static final String[] DEFAULT_IMAGE_SUFFIX = new String[]{".jpg"};
    private String imageLocation = GlobalConstants.getLocation("schema");
    private JTabbedPane tabbedPane;
    private JButton refreshBtn;
    private int columnCount = 3;
    private int imageWidth = 120;
    private int imageHeight = 120;
    private String[] suffix = DEFAULT_IMAGE_SUFFIX;
    private int defaultWidth = 406;
    private int defaultHeight = 587;
    private int defaultLocX = 537;
    private int defaultLocY = 22;
    private JDialog frame;
    private String title = "\u30b7\u30a7\u30fc\u30de\u30dc\u30c3\u30af\u30b9";
    private static final int TIMER_DELAY = 200;
    private static final int MAX_ESTIMATION = 5000;
    private static final String PROGRESS_NOTE = "\u753b\u50cf\u3092\u30ed\u30fc\u30c9\u3057\u3066\u3044\u307e\u3059...";

    @Override
    public void start() {
        this.initCustomComponents();
        this.connect();
        this.setImageLocation(this.imageLocation);
    }

    @Override
    public void stop() {
        if (this.tabbedPane != null) {
            int cnt = this.tabbedPane.getTabCount();
            for (int i = 0; i < cnt; ++i) {
                ImagePalette ip = (ImagePalette)this.tabbedPane.getComponentAt(i);
                if (ip == null) continue;
                ip.dispose();
            }
        }
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public JDialog getFrame() {
        return this.frame;
    }

    public void toFront() {
        if (this.frame != null) {
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
            this.frame.toFront();
        }
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(String loc) {
        this.imageLocation = loc;
        this.createImagePalettes();
        if (!this.frame.isVisible()) {
            this.frame.setVisible(true);
        }
    }

    public void refresh() {
        this.tabbedPane.removeAll();
        this.createImagePalettes();
    }

    private void initCustomComponents() {
        this.tabbedPane = new JTabbedPane();
        this.refreshBtn = new JButton(GlobalConstants.getImageIcon("ref_24.gif"));
        this.refreshBtn.addActionListener(EventHandler.create(ActionListener.class, this, "refresh"));
        this.refreshBtn.setToolTipText("\u30b7\u30a7\u30fc\u30de\u30ea\u30b9\u30c8\u3092\u66f4\u65b0\u3057\u307e\u3059");
        JPanel btnPanel = new JPanel(new FlowLayout(2));
        btnPanel.add(this.refreshBtn);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)btnPanel, "North");
        p.add((Component)this.tabbedPane, "Center");
        p.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.frame = new JDialog((Frame)null, this.title, false);
        this.frame.setResizable(false);
        ComponentMemory cm = new ComponentMemory((Component)this.frame, new Point(this.defaultLocX, this.defaultLocY), new Dimension(this.defaultWidth, this.defaultHeight), (Object)this);
        cm.setToPreferenceBounds();
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImageBox.this.frame.setVisible(false);
            }
        });
        this.frame.getContentPane().add(p);
    }

    private void connect() {
    }

    public void createImagePalettes() {
        ImagePalette imageTable;
        String tabName;
        int i;
        File baseDir = new File(this.imageLocation);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            return;
        }
        File[] directories = this.listDirectories(baseDir);
        if (directories == null || directories.length == 0) {
            return;
        }
        for (i = 0; i < directories.length; ++i) {
            tabName = directories[i].getName();
            if (!tabName.equals("\u57fa\u672c")) continue;
            imageTable = new ImagePalette(null, this.columnCount, this.imageWidth, this.imageHeight);
            imageTable.setImageSuffix(this.suffix);
            imageTable.setImageDirectory(directories[i]);
            this.tabbedPane.addTab(tabName, imageTable);
            break;
        }
        for (i = 0; i < directories.length; ++i) {
            tabName = directories[i].getName();
            if (tabName.equals("\u57fa\u672c")) continue;
            imageTable = new ImagePalette(null, this.columnCount, this.imageWidth, this.imageHeight);
            imageTable.setImageSuffix(this.suffix);
            imageTable.setImageDirectory(directories[i]);
            this.tabbedPane.addTab(tabName, imageTable);
        }
    }

    private File[] listDirectories(File dir) {
        DirectoryFilter filter = new DirectoryFilter();
        File[] directories = dir.listFiles(filter);
        return directories;
    }

    public void processWindowClosing() {
        this.stop();
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setSuffix(String[] suffix) {
        this.suffix = suffix;
    }

    public String[] getSuffix() {
        return this.suffix;
    }

    class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        @Override
        public boolean accept(File path) {
            return path.isDirectory() && !path.isHidden();
        }
    }
}

