/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package open.dolphin.plugin;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.KartePane;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.plugin.IPlugin.Type;

/**
 *
 * @author
 */
public class PluginWrapper {

    private open.dolphin.plugin.IPlugin plugin;
    private Exception lastException;
    private boolean isDispatched;

    /**
     *
     * @param plugin
     */
    public PluginWrapper(IPlugin plugin) {
        this.plugin = plugin;
        this.lastException = null;
    }

    /**
     *
     * @return
     */
    public open.dolphin.plugin.IPlugin.Type getType() {
        Object[] request = new Object[0];
        Object[] response = new Object[1];
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.getType, request, response);
        return (Type) response[0];
    }

    /**
     *
     * @return
     */
    public String getName() {
        Object[] request = new Object[0];
        Object[] response = new Object[1];
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.getName, request, response);
        return (String) response[0];
    }

    /**
     *
     * @return
     */
    public String getReadableName() {
        Object[] request = new Object[0];
        Object[] response = new Object[1];
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.getReadableName, request, response);
        return (String) response[0];
    }

    /**
     *
     * @return
     */
    public DataFlavor getFlavor() {
        Object[] request = new Object[0];
        Object[] response = new Object[1];
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.getFlavor, request, response);
        return (DataFlavor) response[0];
    }

    /**
     *
     * @return
     */
    public IAbstractSettingPanel configure() {
        Object[] request = new Object[0];
        Object[] response = new Object[1];
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.configure, request, response);
        return (IAbstractSettingPanel) response[0];
    }

    /**
     *
     * @param parent
     * @return
     */
    public IChartDocument panel(IChart parent) {
        Object[] request = new Object[1];
        Object[] response = new Object[1];
        request[0] = parent;
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.panel, request, response);
        return (IChartDocument) response[0];
    }

    /**
     *
     * @param send
     * @return
     */
    public Object update(Object send) {
        Object[] request = new Object[1];
        request[0] = send;
        Object[] response = new Object[1];
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.update, request, response);
        return response[0];
    }

    /**
     *
     * @param pane
     * @param transferable
     * @return
     */
    public boolean drop(KartePane pane, Transferable transferable) {
        Object[] request = new Object[2];
        request[0] = pane;
        request[1] = transferable;
        Object[] response = new Object[1];
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.drop, request, response);
        return (Boolean) response[0];
    }

    /**
     *
     * @param parent
     * @return
     */
    public boolean execute(IChart parent) {
        Object[] request = new Object[1];
        request[0] = parent;
        Object[] response = new Object[1];
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.execute, request, response);
        return (Boolean) response[0];
    }

    /**
     *
     * @param send
     * @return
     */
    public Object message(Object send) {
        Object[] request = new Object[1];
        request[0] = send;
        Object[] response = new Object[1];
        dispatchHarnes(open.dolphin.plugin.IPlugin.Command.messaging, request, response);
        return response[0];
    }

    /**
     *
     * @param command
     * @param request
     * @param response
     */
    public void dispatchHarnes(open.dolphin.plugin.IPlugin.Command command, Object[] request, Object[] response) {
        try {
            isDispatched = plugin.dispatchCommand(command, request, response);
        } catch (Exception e) {
            lastException = e;
        }
    }

    /**
     * @return the lastException
     */
    public Exception getLastException() {
        return lastException;
    }

    /**
     * @return the isDispatched
     */
    public boolean IsDispatched() {
        return isDispatched;
    }
}
