/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class UnparsedPDUImpl {
    static final long MAX_LENGTH = 0x100000L;
    private final byte[] buf;
    private final int type;
    private final int len;

    public UnparsedPDUImpl(InputStream in, byte[] buf) throws IOException {
        if (buf == null || buf.length < 6) {
            buf = new byte[10];
        }
        UnparsedPDUImpl.readFully(in, buf, 0, 6);
        this.type = buf[0] & 0xFF;
        this.len = (buf[2] & 0xFF) << 24 | (buf[3] & 0xFF) << 16 | (buf[4] & 0xFF) << 8 | (buf[5] & 0xFF) << 0;
        if ((long)(this.len & 0xFFFFFFFF) > 0x100000L) {
            UnparsedPDUImpl.skipFully(in, (long)this.len & 0xFFFFFFFFL);
            this.buf = null;
            return;
        }
        if (buf.length < 6 + this.len) {
            this.buf = new byte[6 + this.len];
            System.arraycopy(buf, 0, this.buf, 0, 6);
        } else {
            this.buf = buf;
        }
        UnparsedPDUImpl.readFully(in, this.buf, 6, this.len);
    }

    public final int type() {
        return this.type;
    }

    public final int length() {
        return this.len;
    }

    public final byte[] buffer() {
        return this.buf;
    }

    public String toString() {
        return "PDU[type=" + this.type + ", length=" + ((long)this.len & 0xFFFFFFFFL) + "]";
    }

    static void skipFully(InputStream in, long len) throws IOException {
        long count;
        for (long n = 0L; n < len; n += count) {
            count = in.skip(len - n);
            if (count > 0L) continue;
            throw new EOFException();
        }
    }

    static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = in.read(b, n + off, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

