/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.media.DirBuilder;
import org.dcm4che.media.DirBuilderFactory;
import org.dcm4che.media.DirBuilderPref;
import org.dcm4che.media.DirReader;
import org.dcm4che.media.DirWriter;
import org.dcm4cheri.media.DirBuilderImpl;
import org.dcm4cheri.media.DirBuilderPrefImpl;
import org.dcm4cheri.media.DirReaderImpl;
import org.dcm4cheri.media.DirWriterImpl;

public final class DirBuilderFactoryImpl
extends DirBuilderFactory {
    public DirReader newDirReader(File file) throws IOException {
        return new DirReaderImpl(file, new FileImageInputStream(file)).initReader();
    }

    public DirReader newDirReader(ImageInputStream in) throws IOException {
        return new DirReaderImpl(null, in).initReader();
    }

    public DirWriter newDirWriter(File file, DcmEncodeParam encParam) throws IOException {
        return new DirWriterImpl(file, new FileImageOutputStream(file), encParam).initWriter();
    }

    public DirWriter newDirWriter(File file, FileMetaInfo fmi, String filesetID, File descriptorFile, String specCharset, DcmEncodeParam encParam) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        return new DirWriterImpl(file, new FileImageOutputStream(file), encParam).initWriter(fmi, filesetID, descriptorFile, specCharset);
    }

    public DirWriter newDirWriter(File file, String uid, String filesetID, File descriptorFile, String specCharset, DcmEncodeParam encParam) throws IOException {
        return this.newDirWriter(file, DcmObjectFactory.getInstance().newFileMetaInfo("1.2.840.10008.1.3.10", uid, "1.2.840.10008.1.2.1"), filesetID, descriptorFile, specCharset, encParam);
    }

    public DirBuilder newDirBuilder(DirWriter writer, DirBuilderPref pref) {
        return new DirBuilderImpl(writer, pref);
    }

    public DirBuilderPref newDirBuilderPref() {
        return new DirBuilderPrefImpl();
    }
}

