/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.media;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.Implementation;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.media.DirBuilder;
import org.dcm4che.media.DirBuilderPref;
import org.dcm4che.media.DirReader;
import org.dcm4che.media.DirWriter;

public abstract class DirBuilderFactory {
    private static HashMap REC_TYPE_MAP = new HashMap(79);

    public static String getRecordType(String classUID) {
        String type = (String)REC_TYPE_MAP.get(classUID);
        if (type == null) {
            return "PRIVATE";
        }
        return type;
    }

    public static DirBuilderFactory getInstance() {
        return (DirBuilderFactory)Implementation.findFactory("dcm4che.media.DirBuilderFactory");
    }

    public abstract DirReader newDirReader(File var1) throws IOException;

    public abstract DirReader newDirReader(ImageInputStream var1) throws IOException;

    public abstract DirWriter newDirWriter(File var1, DcmEncodeParam var2) throws IOException;

    public abstract DirWriter newDirWriter(File var1, String var2, String var3, File var4, String var5, DcmEncodeParam var6) throws IOException;

    public abstract DirWriter newDirWriter(File var1, FileMetaInfo var2, String var3, File var4, String var5, DcmEncodeParam var6) throws IOException;

    public abstract DirBuilderPref newDirBuilderPref();

    public abstract DirBuilder newDirBuilder(DirWriter var1, DirBuilderPref var2);

    static {
        REC_TYPE_MAP.put("1.2.840.10008.5.1.1.27", "STORED PRINT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.1.29", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.1.29", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.1.30", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.1.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.2.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.1.3.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.3.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.4", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.5", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.6", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.6.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.7.4", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.8", "OVERLAY");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9", "CURVE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.1.1", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.1.2", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.1.3", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.2.1", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.3.1", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.9.4.1", "WAVEFORM");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.10", "MODALITY LUT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.11", "VOI LUT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.11.1", "PRESENTATION");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.11.2", "PRESENTATION");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.11.3", "PRESENTATION");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.11.4", "PRESENTATION");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.12.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.12.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.12.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.20", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1.2", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1.3", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1.4", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.11", "SR DOCUMENT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.22", "SR DOCUMENT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.33", "SR DOCUMENT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.50", "SR DOCUMENT");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.88.59", "KEY OBJECT DOC");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.4.2", "SPECTROSCOPY");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.128", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.129", "CURVE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.1", "IMAGE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.2", "RT DOSE");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.3", "RT STRUCTURE SET");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.4", "RT TREAT RECORD");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.9", "RT TREAT RECORD");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.5", "RT PLAN");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.8", "RT PLAN");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.6", "RT TREAT RECORD");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.481.7", "RT TREAT RECORD");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.66", "RAW DATA");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.66.1", "REGISTRATION");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.66.3", "REGISTRATION");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.66.2", "FIDUCIAL");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.104.1", "ENCAP DOC");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.67", "VALUE MAP");
        REC_TYPE_MAP.put("1.2.840.10008.5.1.4.1.1.77.1.5.3", "STEREOMETRIC");
    }
}

