/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.plugin.physicalpanel;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.CalendarCardPanel;
import open.dolphin.infomodel.PhysicalModel;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.log.LogWriter;
import open.dolphin.plugin.physicalpanel.PhysicalPanel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.utils.StringTool;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;

public class PhysicalEditorPanel
extends JPanel {
    private PhysicalPanel inspector;
    private JDialog dialog;
    private JButton addBtn;
    private JButton clearBtn;
    private JTextField heightFld;
    private JTextField identifiedDateFld;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JButton updateButton;
    private JTextField weightFld;

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.heightFld = new JTextField();
        this.weightFld = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.identifiedDateFld = new JTextField();
        this.updateButton = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(PhysicalEditorPanel.class);
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.setName("Form");
        this.heightFld.setName("heightFld");
        this.weightFld.setName("weightFld");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setName("jLabel3");
        this.identifiedDateFld.setEditable(false);
        this.identifiedDateFld.setName("identifiedDateFld");
        this.updateButton.setName("updateButton");
        this.updateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PhysicalEditorPanel.this.updateButtonMouseClicked(evt);
            }
        });
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).add(63, 63, 63)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.heightFld, -2, 53, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.weightFld, -2, 62, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.identifiedDateFld, -2, 124, -2).addPreferredGap(0).add((Component)this.updateButton, -1, 93, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.updateButton, -2, 19, -2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.jLabel3).add((Component)this.jLabel4).add((Component)this.heightFld, -2, -1, -2).add((Component)this.jLabel6).add((Component)this.weightFld, -2, -1, -2).add((Component)this.identifiedDateFld, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void updateButtonMouseClicked(MouseEvent evt) {
        this.popupCalendar(evt);
    }

    public PhysicalEditorPanel(PhysicalPanel inspector) {
        this.initComponents();
        this.updateButton.setText("\u5909\u66f4...");
        this.inspector = inspector;
        this.addBtn = new JButton("\u8ffd\u52a0");
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhysicalEditorPanel.this.add();
            }
        });
        this.addBtn.setEnabled(false);
        this.clearBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhysicalEditorPanel.this.clear();
            }
        });
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PhysicalEditorPanel.this.checkBtn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PhysicalEditorPanel.this.checkBtn();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PhysicalEditorPanel.this.checkBtn();
            }
        };
        this.heightFld.getDocument().addDocumentListener(dl);
        this.weightFld.getDocument().addDocumentListener(dl);
        this.identifiedDateFld.getDocument().addDocumentListener(dl);
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String todayString = sdf.format(date);
        this.identifiedDateFld.setText(todayString);
        this.heightFld.addFocusListener(AutoRomanListener.getInstance());
        this.weightFld.addFocusListener(AutoRomanListener.getInstance());
        this.identifiedDateFld.addFocusListener(AutoRomanListener.getInstance());
        Object[] options = new Object[]{this.addBtn, this.clearBtn};
        JOptionPane pane = new JOptionPane(this, -1, -1, null, options, this.addBtn);
        this.dialog = pane.createDialog(inspector.getParentContext().getFrame(), GlobalConstants.getFrameTitle("\u8eab\u9577\u4f53\u91cd\u767b\u9332"));
        this.dialog.setVisible(true);
    }

    private void checkBtn() {
        String height = this.heightFld.getText().trim();
        String weight = this.weightFld.getText().trim();
        if (!height.equals("") && !weight.equals("")) {
            try {
                this.addBtn.setEnabled(true);
            }
            catch (Exception e) {
                this.addBtn.setEnabled(false);
            }
        }
    }

    private void add() {
        double _height;
        String h = this.heightFld.getText().trim();
        String w = this.weightFld.getText().trim();
        PhysicalModel model = new PhysicalModel();
        try {
            if (!h.equals("")) {
                _height = Double.valueOf(h);
                model.setHeight(StringTool.zenkakuNumToHankaku(h));
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
        try {
            if (!w.equals("")) {
                _height = Double.valueOf(w);
                model.setWeight(StringTool.zenkakuNumToHankaku(w));
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
        String confirmedStr = this.identifiedDateFld.getText().trim();
        model.setIdentifiedDate(confirmedStr);
        this.addBtn.setEnabled(false);
        this.clearBtn.setEnabled(false);
        this.inspector.add(model);
        this.dialog.setVisible(false);
    }

    private void clear() {
        this.dialog.setVisible(false);
    }

    public void popupCalendar(MouseEvent e) {
        final JPopupMenu popup = new JPopupMenu();
        CalendarCardPanel cc = new CalendarCardPanel(GlobalConstants.getEventColorTable());
        cc.addPropertyChangeListener("pickedDate", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("pickedDate")) {
                    SimpleDate sd = (SimpleDate)e.getNewValue();
                    PhysicalEditorPanel.this.identifiedDateFld.setText(SimpleDate.simpleDateToMmldate(sd));
                    popup.setVisible(false);
                }
            }
        });
        cc.setCalendarRange(new int[]{-12, 0});
        popup.insert(cc, 0);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }
}

