/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.log.LogWriter;

public class SchemaSupport
extends PlugInMenuSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySchemas(File source, File dist) throws Exception {
        File[] sourceDirs = source.listFiles();
        for (int i = 0; i < sourceDirs.length; ++i) {
            File sourceDir = sourceDirs[i];
            if (!sourceDir.isDirectory()) continue;
            File distDir = new File(dist.getAbsolutePath() + File.separator + sourceDir.getName());
            distDir.mkdir();
            File[] sourceFiles = sourceDir.listFiles();
            for (int files_index = 0; files_index < sourceFiles.length; ++files_index) {
                File sourceFile = sourceFiles[files_index];
                if (!sourceFile.isFile()) continue;
                FileInputStream sourceStream = null;
                FileOutputStream distStream = null;
                AbstractInterruptibleChannel sourceChannel = null;
                AbstractInterruptibleChannel distChannel = null;
                try {
                    sourceStream = new FileInputStream(sourceFile);
                    distStream = new FileOutputStream(dist.getAbsolutePath() + File.separator + sourceDir.getName() + File.separator + sourceFile.getName());
                    sourceChannel = sourceStream.getChannel();
                    distChannel = distStream.getChannel();
                    ((FileChannel)sourceChannel).transferTo(0L, ((FileChannel)sourceChannel).size(), (WritableByteChannel)((Object)distChannel));
                    continue;
                }
                catch (IOException ex) {
                    LogWriter.error(this.getClass(), ex);
                    continue;
                }
                finally {
                    sourceStream.close();
                    distStream.close();
                    sourceChannel.close();
                    distChannel.close();
                }
            }
        }
    }

    private void moveSchemas(File source, File dist) {
        try {
            this.copySchemas(source, dist);
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
        }
    }

    public boolean installSchemas(String sourcePath, String distPaht) {
        File sourceDir = new File(sourcePath);
        File distDir = new File(distPaht);
        if (sourceDir.exists()) {
            if (!distDir.exists()) {
                distDir.mkdir();
            }
            this.moveSchemas(sourceDir, distDir);
            return true;
        }
        return false;
    }
}

