/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.waitinglist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.Dolphin;
import open.dolphin.client.IChart;
import open.dolphin.client.IMainComponent;
import open.dolphin.client.IMainWindow;
import open.dolphin.client.waitinglist.RowTipsTable;
import open.dolphin.container.NameValuePair;
import open.dolphin.delegater.remote.RemotePVTDelegater;
import open.dolphin.helper.FixedLengthFormat.FileWriter;
import open.dolphin.helper.FutureNetII.Patient;
import open.dolphin.helper.IMainCommandAccepter;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.table.ObjectReflectTableModel;
import org.jdesktop.layout.GroupLayout;

public class WaitingListView
extends JPanel
implements IMainComponent {
    private String name;
    private String icon;
    private IMainWindow context;
    private static final String NAME = "\u53d7\u4ed8\u30ea\u30b9\u30c8";
    private static final ImageIcon FLAG_ICON = GlobalConstants.getImageIcon("flag_16.gif");
    private static final ImageIcon OPEN_ICON = GlobalConstants.getImageIcon("open_16.gif");
    private static final Color FLAG_COLOR = GlobalConstants.getColor("waitingList.color.flag");
    private static final Color OPEN_COLOR = GlobalConstants.getColor("waitingList.color.open");
    private static final Color MALE_COLOR = GlobalConstants.getColor("waitingList.color.male");
    private static final Color FEMALE_COLOR = GlobalConstants.getColor("waitingList.color.female");
    private static final Color ODD_COLOR = GlobalConstants.getColor("color.odd");
    private static final Color EVEN_COLOR = GlobalConstants.getColor("color.even");
    private static final Color CANCEL_PVT_COLOR = GlobalConstants.getColor("waitingList.color.pvtCancel");
    private NameValuePair[] intervalObjects = GlobalConstants.getNameValuePair("waitingList.interval");
    private int CHECK_INTERVAL = 30;
    private int STATE_COLUMN = 7;
    private final int AGE_COLUMN = 4;
    private final String[] AGE_METHOD = new String[]{"getPatientAgeBirthday", "getPatientBirthday"};
    private ObjectReflectTableModel<PatientVisitModel> pvtTableModel;
    private Preferences preferences;
    private boolean sexRenderer;
    private boolean ageDisplay;
    private Date operationDate;
    private Date checkedTime;
    private int pvtCount;
    private int checkInterval;
    private PatientVisitModel selectedPvt;
    private int saveSelectedIndex;
    private ScheduledFuture timerHandler;
    private RunnablePvtChecker pvtChecker;
    private final JComboBox categoryComboBox = new JComboBox();
    private JLabel checkedTimeLbl;
    private JLabel countLbl;
    private JLabel dateLbl;
    private JLabel intervalLbl;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JButton kutuBtn;
    private final JComboBox subjectComboBox = new JComboBox();
    private JTable table;

    public WaitingListView() {
        this.initComponents();
        this.jScrollPane1.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.name = NAME;
        this.pvtChecker = new RunnablePvtChecker();
    }

    private synchronized void addPvtList(PatientVisitModel item) {
        this.pvtTableModel.addRow(item);
    }

    private List<PatientVisitModel> getWaitingList() {
        return new RemotePVTDelegater().getPvt(this.getSearchDateAsString(new Date()), 0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new RowTipsTable();
        this.kutuBtn = new JButton();
        this.jPanel1 = new JPanel();
        this.checkedTimeLbl = new JLabel();
        this.jPanel2 = new JPanel();
        this.countLbl = new JLabel();
        this.jPanel3 = new JPanel();
        this.intervalLbl = new JLabel();
        this.jPanel4 = new JPanel();
        this.dateLbl = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.table);
        this.kutuBtn.setText("\u53d7\u4ed8\u30ea\u30b9\u30c8\u306e\u66f4\u65b0");
        this.kutuBtn.setToolTipText("\u6765\u9662\u8005\u306e\u30c1\u30a7\u30c3\u30af\u3092\u884c\u3044\u307e\u3059\u3002");
        this.jPanel1.setLayout(new FlowLayout(1, 5, 0));
        this.checkedTimeLbl.setFont(new Font("Lucida Grande", 0, 10));
        this.checkedTimeLbl.setText("jLabel3");
        this.jPanel1.add(this.checkedTimeLbl);
        this.jPanel2.setBorder(new SoftBevelBorder(0));
        this.jPanel2.setMaximumSize(new Dimension(2, 10));
        this.jPanel2.setMinimumSize(new Dimension(2, 10));
        this.jPanel2.setPreferredSize(new Dimension(2, 10));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 4, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel2);
        this.countLbl.setFont(new Font("Lucida Grande", 0, 10));
        this.countLbl.setText("jLabel5");
        this.jPanel1.add(this.countLbl);
        this.jPanel3.setLayout(new FlowLayout(1, 5, 0));
        this.intervalLbl.setFont(new Font("Lucida Grande", 0, 10));
        this.intervalLbl.setText("jLabel3");
        this.jPanel3.add(this.intervalLbl);
        this.jPanel4.setBorder(new SoftBevelBorder(0));
        this.jPanel4.setMaximumSize(new Dimension(2, 10));
        this.jPanel4.setMinimumSize(new Dimension(2, 10));
        this.jPanel4.setPreferredSize(new Dimension(2, 10));
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(0, 4, Short.MAX_VALUE));
        this.jPanel3.add(this.jPanel4);
        this.dateLbl.setFont(new Font("Lucida Grande", 0, 10));
        this.dateLbl.setText("jLabel5");
        this.jPanel3.add(this.dateLbl);
        this.categoryComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"\u5168\u3066"}));
        this.categoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitingListView.this.categoryComboBoxActionPerformed(evt);
            }
        });
        this.subjectComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"\u5168\u3066"}));
        this.subjectComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitingListView.this.subjectComboBoxActionPerformed(evt);
            }
        });
        this.jLabel3.setText("\u8a3a\u7642\u79d1");
        this.jLabel4.setText("\u5185\u5bb9");
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/flag_16.gif")));
        this.jLabel2.setText("\u8a3a\u5bdf\u7d42\u4e86");
        this.jLabel2.setFocusable(false);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/open_16.gif")));
        this.jLabel1.setText("\u8a3a\u7642\u4e2d");
        this.jLabel1.setFocusable(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.kutuBtn, -2, 195, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0, 214, Short.MAX_VALUE).add((Component)this.jPanel3, -2, -1, -2)).add((Component)this.jScrollPane1, -1, 604, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.categoryComboBox, -2, 147, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.subjectComboBox, -2, 140, -2).addPreferredGap(0, 111, Short.MAX_VALUE).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jLabel2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.categoryComboBox, -2, -1, -2).add((Component)this.jLabel4).add((Component)this.subjectComboBox, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 284, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel3, -2, -1, -2).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.kutuBtn, -2, 30, -2)).addContainerGap()));
    }

    private boolean checkItems(JComboBox control, String item) {
        for (int index = 0; index < control.getItemCount(); ++index) {
            if (!control.getItemAt(index).equals(item)) continue;
            return true;
        }
        return false;
    }

    private synchronized void clearPvtList() {
        this.pvtTableModel.clear();
    }

    private void filterWaitingList() {
        String medicalSchool = (String)this.categoryComboBox.getSelectedItem();
        String subject = (String)this.subjectComboBox.getSelectedItem();
        if (medicalSchool != null && subject != null) {
            this.clearPvtList();
            List<PatientVisitModel> waitingList = this.getWaitingList();
            for (PatientVisitModel item : waitingList) {
                String _subject;
                String _medicalSchool;
                if ((item.getDepartmentName().equals(medicalSchool) || medicalSchool.equals("\u5168\u3066")) && (item.getCategory().equals(subject) || subject.equals("\u5168\u3066"))) {
                    this.addPvtList(item);
                }
                if (!this.checkItems(this.categoryComboBox, _medicalSchool = item.getDepartmentName())) {
                    this.categoryComboBox.addItem(_medicalSchool);
                }
                if (this.checkItems(this.subjectComboBox, _subject = item.getCategory())) continue;
                this.subjectComboBox.addItem(_subject);
            }
        }
    }

    private void categoryComboBoxActionPerformed(ActionEvent evt) {
        this.filterWaitingList();
        String selected = (String)this.categoryComboBox.getSelectedItem();
        this.preferences.put("WaitingListView_medicalSchoolComboBox_Initial", selected);
    }

    private void subjectComboBoxActionPerformed(ActionEvent evt) {
        this.filterWaitingList();
        String selected = (String)this.categoryComboBox.getSelectedItem();
        this.preferences.put("WaitingListView_subjectComboBox_Initial", selected);
    }

    private int getSelectedRow(JTable table) {
        int result = table.getSelectedRow();
        if (result >= 0 && result < table.getRowCount()) {
            result = table.convertRowIndexToModel(result);
        }
        return result;
    }

    private void setup() {
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.sexRenderer = this.preferences.getBoolean("sexRenderer", false);
        this.ageDisplay = this.preferences.getBoolean("ageDisplay", true);
        this.checkInterval = this.preferences.getInt("checkInterval", this.CHECK_INTERVAL);
    }

    @Override
    public void start() {
        this.setup();
        this.initCustomComponents();
        this.connect();
        this.restartCheckTimer();
    }

    @Override
    public void enter() {
        this.controlMenu();
    }

    @Override
    public void stop() {
    }

    public PatientModel getPatinet() {
        return this.selectedPvt != null ? this.selectedPvt.getPatient() : null;
    }

    public boolean isSexRenderer() {
        return this.sexRenderer;
    }

    private synchronized void pvtTableModelFireTableDataChanged() {
        this.pvtTableModel.fireTableDataChanged();
    }

    public synchronized void switchRenderere() {
        this.sexRenderer = !this.sexRenderer;
        this.preferences.putBoolean("sexRenderer", this.sexRenderer);
        if (this.table != null) {
            this.pvtTableModelFireTableDataChanged();
        }
    }

    public synchronized void switchAgeDisplay() {
        this.ageDisplay = !this.ageDisplay;
        this.preferences.putBoolean("ageDisplay", this.ageDisplay);
        if (this.table != null) {
            String method = this.ageDisplay ? this.AGE_METHOD[0] : this.AGE_METHOD[1];
            this.pvtTableModel.setMethodName(method, 4);
        }
    }

    public void setOperationDate(Date date) {
        this.operationDate = date;
        String formatStr = "yyyy-MM-dd (EE)";
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        this.dateLbl.setText(sdf.format(this.operationDate));
    }

    public void setCheckedTime(Date date) {
        this.checkedTime = date;
        String formatStr = "HH:mm";
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        this.checkedTimeLbl.setText(sdf.format(this.checkedTime));
    }

    public void setCheckInterval(int interval) {
        this.checkInterval = interval;
        String intervalSt = String.valueOf(this.checkInterval);
        for (NameValuePair pair : this.intervalObjects) {
            if (!intervalSt.equals(pair.getValue())) continue;
            String text = "\u30c1\u30a7\u30c3\u30af\u9593\u9694:";
            text = text + pair.getName();
            this.intervalLbl.setText(text);
            break;
        }
    }

    public void setPvtCount(int cnt) {
        this.pvtCount = cnt;
        String text = "\u6765\u9662\u6570:";
        text = text + String.valueOf(this.pvtCount);
        this.countLbl.setText(text);
    }

    public void setBusy(boolean busy) {
        this.kutuBtn.setEnabled(!busy);
        this.categoryComboBox.setEnabled(!busy);
        this.subjectComboBox.setEnabled(!busy);
        if (busy) {
            this.getContext().block();
            this.saveSelectedIndex = this.getSelectedRow(this.table);
        } else {
            this.getContext().unblock();
            this.table.getSelectionModel().addSelectionInterval(this.saveSelectedIndex, this.saveSelectedIndex);
        }
    }

    public PatientVisitModel getSelectedPvt() {
        return this.selectedPvt;
    }

    public void setSelectedPvt(PatientVisitModel selectedPvt) {
        PatientVisitModel old = this.selectedPvt;
        this.selectedPvt = selectedPvt;
        this.controlMenu();
    }

    public void restartCheckTimer() {
        if (this.timerHandler != null) {
            this.timerHandler.cancel(false);
        }
        ScheduledExecutorService schedule = Executors.newSingleThreadScheduledExecutor();
        this.timerHandler = schedule.scheduleWithFixedDelay(this.pvtChecker, 0L, this.checkInterval, TimeUnit.SECONDS);
    }

    private void controlMenu() {
        PatientVisitModel pvt = this.getSelectedPvt();
        boolean enabled = this.canOpen(pvt);
        this.getContext().enabledAction("openKarte", enabled);
    }

    private void initCustomComponents() {
        String _subject;
        String[] columnNames = new String[]{"\u60a3\u8005ID", "\u6765\u9662\u6642\u9593", "\u6c0f   \u540d", "\u6027\u5225", "\u751f\u5e74\u6708\u65e5", "\u8a3a\u7642\u79d1", "\u4e88\u7d04", "\u72b6\u614b", "\u5185\u5bb9"};
        String[] methodNames = new String[]{"getPatientId", "getPvtDateTrimDate", "getPatientName", "getPatientGenderDesc", "getPatientAgeBirthday", "getDepartmentName", "getAppointment", "getState", "getCategory"};
        Class[] classes = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class};
        int[] columnWidth = new int[]{80, 60, 140, 40, 140, 50, 40, 30, 80};
        int startNumRows = 0;
        int rowHeight = 18;
        if (!this.ageDisplay) {
            methodNames[4] = this.AGE_METHOD[1];
        }
        this.pvtTableModel = new ObjectReflectTableModel(columnNames, startNumRows, methodNames, classes);
        this.table.setModel(this.pvtTableModel);
        this.table.setAutoCreateRowSorter(true);
        this.table.addMouseListener(new ContextListener());
        this.table.setRowHeight(rowHeight);
        this.table.setSelectionMode(0);
        for (int i = 0; i < columnWidth.length; ++i) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(columnWidth[i]);
        }
        MaleFemaleRenderer sRenderer = new MaleFemaleRenderer();
        this.table.getColumnModel().getColumn(0).setCellRenderer(sRenderer);
        this.table.getColumnModel().getColumn(2).setCellRenderer(sRenderer);
        this.table.getColumnModel().getColumn(4).setCellRenderer(sRenderer);
        this.table.getColumnModel().getColumn(5).setCellRenderer(sRenderer);
        this.table.getColumnModel().getColumn(6).setCellRenderer(sRenderer);
        this.table.getColumnModel().getColumn(8).setCellRenderer(sRenderer);
        CenterRenderer centerRenderer = new CenterRenderer();
        this.table.getColumnModel().getColumn(1).setCellRenderer(centerRenderer);
        this.table.getColumnModel().getColumn(3).setCellRenderer(centerRenderer);
        KarteStateRenderer renderer = new KarteStateRenderer();
        renderer.setHorizontalAlignment(0);
        this.table.getColumnModel().getColumn(this.STATE_COLUMN).setCellRenderer(renderer);
        this.setOperationDate(new Date());
        this.setCheckInterval(this.checkInterval);
        this.setPvtCount(0);
        String _medicalSchool = this.preferences.get("WaitingListView_medicalSchoolComboBox_Initial", "\u5168\u3066");
        if (!this.checkItems(this.categoryComboBox, _medicalSchool)) {
            this.categoryComboBox.addItem(_medicalSchool);
            this.categoryComboBox.setSelectedIndex(1);
        }
        if (!this.checkItems(this.subjectComboBox, _subject = this.preferences.get("WaitingListView_subjectComboBox_Initial", "\u5168\u3066"))) {
            this.subjectComboBox.addItem(_subject);
            this.subjectComboBox.setSelectedIndex(1);
        }
    }

    private void connect() {
        ChartWindow._addPropertyChangeListener("chartStateProp", EventHandler.create(PropertyChangeListener.class, this, "updateState", "newValue"));
        new EventAdapter(this.table);
        this.kutuBtn.addActionListener(EventHandler.create(ActionListener.class, this, "checkFullPvt"));
    }

    @Override
    public boolean dispatchMainCommand(IMainCommandAccepter.MainCommand command) {
        switch (command) {
            case openKarte: {
                return this.openKarte();
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    @Override
    public Callable<Boolean> getStartingTask() {
        return null;
    }

    @Override
    public Callable<Boolean> getStoppingTask() {
        return null;
    }

    public synchronized void openKarte(PatientVisitModel pvtModel) {
        if (pvtModel != null && this.canOpen(pvtModel)) {
            this.context.openKarte(pvtModel, "");
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public synchronized void updateState(PatientVisitModel updated) {
        List<PatientVisitModel> pvtList = this.pvtTableModel.getObjectList();
        int cnt = pvtList.size();
        boolean found = false;
        for (int i = 0; i < cnt; ++i) {
            PatientVisitModel test = pvtList.get(i);
            if (updated.getId() != test.getId()) continue;
            test.setState(updated.getState());
            this.pvtTableModel.fireTableRowsUpdated(i, i);
            found = true;
            break;
        }
        if (found && updated.getState() == IChart.state.CLOSE_SAVE) {
            RemotePVTDelegater pdl = new RemotePVTDelegater();
            pdl.updatePvtState(updated.getId(), updated.getState());
        }
    }

    public void checkFullPvt() {
        if (this.timerHandler != null) {
            this.timerHandler.cancel(false);
        }
        try {
            FutureTask<Integer> task = new FutureTask<Integer>(new CallablePvtChecker());
            new Thread(task).start();
            Integer n = task.get(120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), "", (Throwable)e);
        }
        ScheduledExecutorService schedule = Executors.newSingleThreadScheduledExecutor();
        this.timerHandler = schedule.scheduleWithFixedDelay(this.pvtChecker, this.checkInterval, this.checkInterval, TimeUnit.SECONDS);
    }

    private boolean canOpen(PatientVisitModel pvt) {
        if (pvt == null) {
            return false;
        }
        if (this.isKarteOpened(pvt)) {
            return false;
        }
        return !this.isKarteCanceled(pvt);
    }

    private boolean isKarteOpened(PatientVisitModel pvtModel) {
        return this.context.isKarteOpened(pvtModel.getId());
    }

    private boolean isKarteCanceled(PatientVisitModel pvtModel) {
        return pvtModel != null && pvtModel.getState() == IChart.state.CANCEL_PVT;
    }

    @Override
    public void setMenu(Dolphin.MenuMediator midiator) {
        midiator.setLast(this);
    }

    private boolean openKarte() {
        PatientVisitModel pvtModel = this.getSelectedPvt();
        if (this.canOpen(pvtModel)) {
            this.openKarte(pvtModel);
        }
        return true;
    }

    public synchronized void cancelVisit() {
        int selected = this.getSelectedRow(this.table);
        PatientVisitModel pvtModel = this.pvtTableModel.getObject(selected);
        Object[] cstOptions = new Object[]{"\u306f\u3044", "\u3044\u3044\u3048"};
        StringBuilder sb = new StringBuilder(pvtModel.getPatientName());
        sb.append("\u69d8\u306e\u53d7\u4ed8\u3092\u53d6\u308a\u6d88\u3057\u307e\u3059\u304b?");
        int select = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.table), sb.toString(), GlobalConstants.getFrameTitle(this.getName()), 1, 3, GlobalConstants.getImageIcon("cancl_32.gif"), cstOptions, "\u306f\u3044");
        if (select == 0) {
            pvtModel.setState(IChart.state.CANCEL_PVT);
            RemotePVTDelegater pdl = new RemotePVTDelegater();
            pdl.updatePvtState(pvtModel.getId(), pvtModel.getState());
            this.pvtTableModel.fireTableRowsUpdated(selected, selected);
        }
    }

    public void sendNewPatient() {
        PatientModel model = this.getPatinet();
        Patient patient = new Patient(model);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String date = sdf.format(calendar.getTime());
        try {
            FileWriter writer = new FileWriter("kan." + date, "MS932");
            writer.write(patient);
            writer.close();
            JOptionPane.showMessageDialog(null, "FutureNetII\u3078\u65b0\u60a3\u60c5\u5831\u3092\u9001\u308a\u307e\u3057\u305f\u3002" + System.getProperty("line.separator") + "FutureNetII\u306b\u53cd\u6620\u3055\u308c\u308b\u307e\u3067\u6700\u592710\u5206\u304b\u304b\u308a\u307e\u3059\u3002");
        }
        catch (UnsupportedEncodingException uee) {
            LogWriter.error(this.getClass(), "", (Throwable)uee);
        }
        catch (IOException ioe) {
            LogWriter.error(this.getClass(), "", (Throwable)ioe);
        }
    }

    private synchronized String[] getSearchDateAsString(Date date) {
        String[] ret = new String[3];
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ret[0] = sdf.format(date);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(5, -2);
        date = gc.getTime();
        ret[1] = sdf.format(date);
        gc.add(5, 2);
        date = gc.getTime();
        ret[2] = sdf.format(date);
        return ret;
    }

    protected class CenterRenderer
    extends MaleFemaleRenderer {
        public CenterRenderer() {
            this.setHorizontalAlignment(0);
        }
    }

    protected class MaleFemaleRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            PatientVisitModel pvt = (PatientVisitModel)WaitingListView.this.pvtTableModel.getObject(table.convertRowIndexToModel(row));
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                if (WaitingListView.this.isSexRenderer()) {
                    if (pvt != null && pvt.getPatient().getGender().equals("male")) {
                        this.setBackground(MALE_COLOR);
                    } else if (pvt != null && pvt.getPatient().getGender().equals("female")) {
                        this.setBackground(FEMALE_COLOR);
                    } else {
                        this.setBackground(Color.WHITE);
                    }
                } else if (row % 2 == 0) {
                    this.setBackground(EVEN_COLOR);
                } else {
                    this.setBackground(ODD_COLOR);
                }
                Color fore = pvt != null && pvt.getState() == IChart.state.CANCEL_PVT ? CANCEL_PVT_COLOR : table.getForeground();
                this.setForeground(fore);
            }
            if (value != null && value instanceof String) {
                this.setText((String)value);
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            return this;
        }
    }

    protected class KarteStateRenderer
    extends DefaultTableCellRenderer {
        public KarteStateRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            PatientVisitModel pvt = (PatientVisitModel)WaitingListView.this.pvtTableModel.getObject(table.convertRowIndexToModel(row));
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                if (WaitingListView.this.isSexRenderer()) {
                    if (pvt != null && pvt.getPatient().getGender().equals("male")) {
                        this.setBackground(MALE_COLOR);
                    } else if (pvt != null && pvt.getPatient().getGender().equals("female")) {
                        this.setBackground(FEMALE_COLOR);
                    } else {
                        this.setBackground(Color.WHITE);
                    }
                } else if (row % 2 == 0) {
                    this.setBackground(EVEN_COLOR);
                } else {
                    this.setBackground(ODD_COLOR);
                }
                Color fore = pvt != null && pvt.getState() == IChart.state.CANCEL_PVT ? CANCEL_PVT_COLOR : table.getForeground();
                this.setForeground(fore);
            }
            if (value != null && value instanceof IChart.state) {
                IChart.state state2 = (IChart.state)((Object)value);
                switch (state2) {
                    case CLOSE_NONE: {
                        this.setIcon(null);
                        break;
                    }
                    case CLOSE_SAVE: {
                        this.setIcon(FLAG_ICON);
                        break;
                    }
                    case OPEN_NONE: 
                    case OPEN_SAVE: {
                        this.setIcon(OPEN_ICON);
                        break;
                    }
                    default: {
                        this.setIcon(null);
                    }
                }
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            return this;
        }
    }

    protected class CallablePvtChecker
    implements Callable<Integer> {
        RemotePVTDelegater delegater = new RemotePVTDelegater();

        private synchronized boolean checkItems(JComboBox control, String item) {
            for (int index = 0; index < control.getItemCount(); ++index) {
                if (!control.getItemAt(index).equals(item)) continue;
                return true;
            }
            return false;
        }

        private synchronized void clearPvtList() {
            WaitingListView.this.pvtTableModel.clear();
        }

        private synchronized List getPvt(String[] dateToSerach, int firstResult) {
            List<PatientVisitModel> result = this.delegater.getPvt(dateToSerach, firstResult);
            return result;
        }

        private synchronized List getPvtTableModelObjectList() {
            return WaitingListView.this.pvtTableModel.getObjectList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() {
            int checkCount;
            Runnable awt1 = new Runnable(){

                @Override
                public void run() {
                    WaitingListView.this.setBusy(true);
                }
            };
            EventQueue.invokeLater(awt1);
            Date date = new Date();
            String[] dateToSerach = WaitingListView.this.getSearchDateAsString(date);
            try {
                List dataList = this.getPvtTableModelObjectList();
                int firstResult = 0;
                List result = this.getPvt(dateToSerach, firstResult);
                int n = checkCount = result != null ? result.size() : 0;
                if (checkCount > 0) {
                    String category = (String)WaitingListView.this.categoryComboBox.getSelectedItem();
                    String subject = (String)WaitingListView.this.subjectComboBox.getSelectedItem();
                    this.clearPvtList();
                    for (int i = 0; i < checkCount; ++i) {
                        if ((((PatientVisitModel)result.get(i)).getDepartmentName().equals(category) || category.equals("\u5168\u3066")) && (((PatientVisitModel)result.get(i)).getCategory().equals(subject) || subject.equals("\u5168\u3066"))) {
                            dataList.add(result.get(i));
                        }
                        PatientVisitModel model = (PatientVisitModel)result.get(i);
                        String _medicalSchool = model.getDepartmentName();
                        if (!this.checkItems(WaitingListView.this.categoryComboBox, _medicalSchool)) {
                            WaitingListView.this.categoryComboBox.addItem(_medicalSchool);
                        }
                        String _subject = model.getCategory();
                        if (this.checkItems(WaitingListView.this.subjectComboBox, _subject)) continue;
                        WaitingListView.this.subjectComboBox.addItem(_subject);
                    }
                    this.pvtTableModelFireTableDataChanged();
                }
            }
            catch (Throwable throwable) {
                Runnable awt2 = new Runnable(date){
                    final /* synthetic */ Date val$date;
                    {
                        this.val$date = date;
                    }

                    @Override
                    public void run() {
                        WaitingListView.this.setCheckedTime(this.val$date);
                        WaitingListView.this.setPvtCount(this.getPvtCount());
                        WaitingListView.this.setBusy(false);
                    }

                    private synchronized int getPvtCount() {
                        return WaitingListView.this.pvtTableModel.getObjectCount();
                    }
                };
                EventQueue.invokeLater(awt2);
                throw throwable;
            }
            Runnable awt2 = new /* invalid duplicate definition of identical inner class */;
            EventQueue.invokeLater(awt2);
            return new Integer(checkCount);
        }

        private synchronized void pvtTableModelFireTableDataChanged() {
            WaitingListView.this.pvtTableModel.fireTableDataChanged();
        }
    }

    protected class RunnablePvtChecker
    implements Runnable {
        private synchronized void clearPvtList() {
            WaitingListView.this.pvtTableModel.clear();
        }

        private synchronized List getPvtTableModelObjectList() {
            return WaitingListView.this.pvtTableModel.getObjectList();
        }

        private boolean checkItems(JComboBox control, String item) {
            for (int index = 0; index < control.getItemCount(); ++index) {
                if (!control.getItemAt(index).equals(item)) continue;
                return true;
            }
            return false;
        }

        private RemotePVTDelegater getDelegater() {
            return new RemotePVTDelegater();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable awt1 = new Runnable(){

                @Override
                public void run() {
                    WaitingListView.this.setBusy(true);
                }
            };
            EventQueue.invokeLater(awt1);
            Date date = new Date();
            try {
                String[] dateToSerach = WaitingListView.this.getSearchDateAsString(date);
                List dataList = this.getPvtTableModelObjectList();
                List<PatientVisitModel> result = this.getDelegater().getPvt(dateToSerach, 0);
                String medicalSchool = (String)WaitingListView.this.categoryComboBox.getSelectedItem();
                String subject = (String)WaitingListView.this.subjectComboBox.getSelectedItem();
                this.clearPvtList();
                if (result.size() > 0) {
                    for (int i = 0; i < result.size(); ++i) {
                        if ((result.get(i).getDepartmentName().equals(medicalSchool) || medicalSchool.equals("\u5168\u3066")) && (result.get(i).getCategory().equals(subject) || subject.equals("\u5168\u3066"))) {
                            dataList.add(result.get(i));
                        }
                        PatientVisitModel model = result.get(i);
                        String _medicalSchool = model.getDepartmentName();
                        if (!this.checkItems(WaitingListView.this.categoryComboBox, _medicalSchool)) {
                            WaitingListView.this.categoryComboBox.addItem(_medicalSchool);
                        }
                        String _subject = model.getCategory();
                        if (this.checkItems(WaitingListView.this.subjectComboBox, _subject)) continue;
                        WaitingListView.this.subjectComboBox.addItem(_subject);
                    }
                    this.pvtTableModelfireTableRowsInserted(dataList);
                }
            }
            catch (Throwable throwable) {
                Runnable awt2 = new Runnable(date){
                    final /* synthetic */ Date val$date;
                    {
                        this.val$date = date;
                    }

                    @Override
                    public void run() {
                        WaitingListView.this.setCheckedTime(this.val$date);
                        WaitingListView.this.setPvtCount(this.getPvtCount());
                        WaitingListView.this.setBusy(false);
                    }

                    private synchronized int getPvtCount() {
                        return WaitingListView.this.pvtTableModel.getObjectCount();
                    }
                };
                EventQueue.invokeLater(awt2);
                throw throwable;
            }
            Runnable awt2 = new /* invalid duplicate definition of identical inner class */;
            EventQueue.invokeLater(awt2);
        }

        private synchronized void pvtTableModelfireTableRowsInserted(List dataList) {
            WaitingListView.this.pvtTableModel.fireTableRowsInserted(0, dataList.size() - 1);
        }
    }

    class ContextListener
    extends MouseAdapter {
        ContextListener() {
        }

        private synchronized Object getPvtTableModelObject(int row) {
            Object obj = WaitingListView.this.pvtTableModel.getObject(row);
            return obj;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mabeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mabeShowPopup(e);
        }

        public void mabeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu contextMenu = new JPopupMenu();
                String pop3 = "\u5076\u6570\u5947\u6570\u30ec\u30f3\u30c0\u30e9\u3092\u4f7f\u7528\u3059\u308b";
                String pop4 = "\u6027\u5225\u30ec\u30f3\u30c0\u30e9\u3092\u4f7f\u7528\u3059\u308b";
                String pop5 = "\u5e74\u9f62\u8868\u793a";
                int row = WaitingListView.this.table.rowAtPoint(e.getPoint());
                Object obj = this.getPvtTableModelObject(row);
                int selected = WaitingListView.this.getSelectedRow(WaitingListView.this.table);
                if (obj != null) {
                    PatientVisitModel pvt = WaitingListView.this.getSelectedPvt();
                    if (WaitingListView.this.canOpen(pvt)) {
                        String pop1 = "\u30ab\u30eb\u30c6\u3092\u958b\u304f";
                        contextMenu.add(new JMenuItem(new AbstractAction(pop1){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                WaitingListView.this.openKarte();
                            }
                        }));
                        String pop2 = "\u53d7\u4ed8\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3059\u308b";
                        contextMenu.add(new JMenuItem(new AbstractAction(pop2){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                WaitingListView.this.cancelVisit();
                            }
                        }));
                    }
                    contextMenu.addSeparator();
                }
                JRadioButtonMenuItem oddEven = new JRadioButtonMenuItem(new AbstractAction(pop3){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WaitingListView.this.switchRenderere();
                    }
                });
                JRadioButtonMenuItem sex = new JRadioButtonMenuItem(new AbstractAction(pop4){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WaitingListView.this.switchRenderere();
                    }
                });
                ButtonGroup bg = new ButtonGroup();
                bg.add(oddEven);
                bg.add(sex);
                contextMenu.add(oddEven);
                contextMenu.add(sex);
                if (WaitingListView.this.sexRenderer) {
                    sex.setSelected(true);
                } else {
                    oddEven.setSelected(true);
                }
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(pop5);
                contextMenu.add(item);
                item.setSelected(WaitingListView.this.ageDisplay);
                item.addActionListener(EventHandler.create(ActionListener.class, WaitingListView.this, "switchAgeDisplay"));
                contextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class EventAdapter
    implements ListSelectionListener,
    MouseListener {
        public EventAdapter(JTable tbl) {
            tbl.getSelectionModel().addListSelectionListener(this);
            tbl.addMouseListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ObjectReflectTableModel tableModel = (ObjectReflectTableModel)WaitingListView.this.table.getModel();
                int row = WaitingListView.this.getSelectedRow(WaitingListView.this.table);
                PatientVisitModel patient = (PatientVisitModel)tableModel.getObject(row);
                WaitingListView.this.setSelectedPvt(patient);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                JTable table = (JTable)e.getSource();
                ObjectReflectTableModel tableModel = (ObjectReflectTableModel)table.getModel();
                PatientVisitModel value = (PatientVisitModel)tableModel.getObject(WaitingListView.this.getSelectedRow(table));
                WaitingListView.this.openKarte(value);
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }
    }
}

