/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.karte;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.EventHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.karte.BasicInfoPanel;
import open.dolphin.client.karte.DocumentHistoryPanel;
import open.dolphin.component.DnDTabbedPane;
import open.dolphin.component.TabTransferHandler;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.log.LogWriter;
import open.dolphin.plugin.IPlugin;
import open.dolphin.plugin.PluginWrapper;
import open.dolphin.utils.Persistent;

public class PatientInspector
extends JPanel
implements IChartDocument {
    public static final String TITLE = "\u30a4\u30f3\u30b9\u30da\u30af\u30bf";
    private BasicInfoPanel basicInfoInspector;
    private DocumentHistoryPanel docHistory;
    private List<JTabbedPane> tabbedPanels;
    private String keyword;
    private IChart parent;
    private String title = "\u30a4\u30f3\u30b9\u30da\u30af\u30bf";
    private static int panelCount = 3;
    private static int maxTabs = 10;
    private JPanel inspector;
    private JScrollPane jScrollPane1;

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.PatientInspector;
    }

    public PatientInspector(IChart parent, String keyword) {
        this.keyword = keyword;
        this.parent = parent;
        this.tabbedPanels = new ArrayList<JTabbedPane>();
        this.initComponents();
        this.initCustomComponents();
        this.setBounds((Rectangle)Persistent.loadLayout(this.getClass().getName(), "layout", this.getBounds()));
        this.applyTabLocations((Properties)Persistent.loadLayout(this.getClass().getName(), "tabLocation", this.initialTabLocations()));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.inspector = new JPanel();
        this.setName(TITLE);
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setName("jScrollPane1");
        this.inspector.setName("inspector");
        this.inspector.setLayout(new BoxLayout(this.inspector, 1));
        this.jScrollPane1.setViewportView(this.inspector);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void release() {
        Persistent.saveLayout(this.getClass().getName(), "tabLocation", this.getTabLocations());
    }

    public void dispose() {
        this.docHistory.clear();
    }

    private Serializable initialTabLocations() {
        Properties result = new Properties();
        result.setProperty("\u6587\u66f8\u5c65\u6b74", "0 0");
        int index = 0;
        int tabLocation = 1;
        for (IPlugin plugin : this.parent.getPlugins().values()) {
            PluginWrapper pluginWrapper = new PluginWrapper(plugin);
            if (pluginWrapper.getType() != IPlugin.Type.panel) continue;
            result.setProperty(pluginWrapper.getName(), Integer.toString(index % panelCount) + " " + Integer.toString(tabLocation));
            ++tabLocation;
            ++index;
        }
        return result;
    }

    private void applyTabLocations(Properties layout) {
        String[][] panels = new String[panelCount][maxTabs];
        Enumeration<?> e = layout.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] location = layout.getProperty(key).split(" ");
            int panelIndex = Integer.parseInt(location[0]);
            int tabLocation = Integer.parseInt(location[1]);
            panels[panelIndex][tabLocation] = key;
        }
        for (int panelIndex = 0; panelIndex < panelCount; ++panelIndex) {
            for (int tabIndex = 0; tabIndex < maxTabs; ++tabIndex) {
                try {
                    Component plugin = (Component)((Object)this.parent.getChartDocument(panels[panelIndex][tabIndex]));
                    if (plugin == null) continue;
                    this.tabbedPanels.get(panelIndex).addTab(panels[panelIndex][tabIndex], plugin);
                    continue;
                }
                catch (Exception ex) {
                    LogWriter.error(this.getClass(), ex);
                }
            }
        }
        panels = null;
    }

    private Properties getTabLocations() {
        Properties result = new Properties();
        int panel_index = 0;
        for (JTabbedPane pane : this.tabbedPanels) {
            int components = 0;
            for (int index = 0; index < pane.getComponentCount(); ++index) {
                try {
                    if (!((IChartDocument)((Object)pane.getComponentAt(index))).itLayoutSaved()) continue;
                    result.setProperty(pane.getTitleAt(index), Integer.toString(panel_index) + " " + Integer.toString(components));
                    ++components;
                    continue;
                }
                catch (Exception e) {
                    LogWriter.error(this.getClass(), e);
                }
            }
            ++panel_index;
        }
        return result;
    }

    private void initCustomComponents() {
        this.basicInfoInspector = new BasicInfoPanel(this.getParentContext());
        DnDTabbedPane tabbedPane = null;
        for (int index = 0; index < panelCount; ++index) {
            tabbedPane = new DnDTabbedPane();
            tabbedPane.addChangeListener(EventHandler.create(ChangeListener.class, this, "tabChanged", ""));
            tabbedPane.setTransferHandler(new TabTransferHandler());
            this.tabbedPanels.add(tabbedPane);
        }
        for (JTabbedPane pane : this.tabbedPanels) {
            this.inspector.add(pane);
        }
    }

    public void tabChanged(ChangeEvent e) {
        DnDTabbedPane tabbedPane = (DnDTabbedPane)e.getSource();
        int index = tabbedPane.getSelectedIndex();
        String title = tabbedPane.getTitleAt(index);
        Component component = (Component)((Object)this.parent.getChartDocument(title));
        IChartDocument documentPanel = null;
        documentPanel = (IChartDocument)((Object)component);
        documentPanel.enter();
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    public KarteBean getKarte() {
        return this.getParentContext().getKarte();
    }

    public PatientModel getPatient() {
        return this.getParentContext().getKarte().getPatient();
    }

    public BasicInfoPanel getBasicInfoInspector() {
        return this.basicInfoInspector;
    }

    public DocumentHistoryPanel getDocumentHistory() {
        return this.docHistory;
    }

    public void setDocumentHistory(DocumentHistoryPanel docHistory) {
        this.docHistory = docHistory;
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        for (JTabbedPane tabbedPane : this.tabbedPanels) {
            for (Component component : tabbedPane.getComponents()) {
                if (!((IChartDocument)((Object)component)).isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return this.tabbedPanels;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }
}

