/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.diagnosis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.editor.diagnosis.DiseaseMasterRenderer;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.infomodel.DiseaseEntry;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.log.LogWriter;
import open.dolphin.order.AbstractMasterPanel;
import open.dolphin.order.ClaimConst;
import open.dolphin.table.ObjectTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class DiagnosisMasterPanel
extends AbstractMasterPanel {
    private static final long serialVersionUID = -8731279062992813732L;
    private static final String[] diseaseColumns = new String[]{"\u30b3\u30fc\u30c9", "\u540d  \u79f0", "\u30ab \u30ca", "ICD10", "\u6709\u52b9\u671f\u9650"};
    private static final String codeSystem = "ICD10_2001-10-03MEDIS";
    private static final String[] sortButtonNames = new String[]{"\u30b3\u30fc\u30c9", "\u540d\u79f0", "ICD10"};
    private static final String[] sortColumnNames = new String[]{"byomeicd", "byomei", "byomeikana", "icd10", "haisiymd"};
    private boolean sortable = false;
    private ButtonGroup bg;
    private JPanel combinedSearchPanel;
    private JButton diseaseButton;
    private JTextField findField;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel keyPanel;
    private JButton postfixButton;
    private JButton prefixButton;
    private JScrollPane scroller;
    private JPanel searchButtonPanel;
    private JTextField searchField;
    private JTable table;
    private JPanel topPanel;
    private JButton typeButton;

    public DiagnosisMasterPanel(String master) {
        super(master);
    }

    @Override
    protected void initialize() {
        this.initComponents();
        this.sortButtons = new JRadioButton[sortButtonNames.length];
        for (int i = 0; i < sortButtonNames.length; ++i) {
            JRadioButton radio;
            this.sortButtons[i] = radio = new JRadioButton(sortButtonNames[i]);
            this.bg.add(radio);
            radio.addActionListener(new AbstractMasterPanel.SortActionListener(this, this, sortColumnNames[i], i));
        }
        int index = this.prefs.getInt("masterSearch.disease.sort", 0);
        this.sortButtons[index].setSelected(true);
        this.setSortBy(sortColumnNames[index]);
        this.tableModel = new ObjectTableModel(diseaseColumns, 20){

            public Class getColumnClass(int col) {
                return DiseaseEntry.class;
            }
        };
        this.table.setModel(this.tableModel);
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DiagnosisMasterPanel.this.sortable) {
                    DiagnosisMasterPanel.this.doSort(e);
                }
            }
        });
        ListSelectionModel m = this.table.getSelectionModel();
        this.table.setRowSelectionAllowed(true);
        TableColumn column = null;
        int[] width = new int[]{50, 200, 200, 40, 50};
        int len = width.length;
        for (int i = 0; i < len; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(width[i]);
        }
        DiseaseMasterRenderer dr = new DiseaseMasterRenderer();
        this.table.setDefaultRenderer(DiseaseEntry.class, dr);
        this.searchField.addFocusListener(AutoKanjiListener.getInstance());
        this.findField.addFocusListener(AutoKanjiListener.getInstance());
        this.keyPanel.setLayout(new FlowLayout(0, 3, 2));
        this.keyPanel.setBorder(BorderFactory.createTitledBorder("\u30ad\u30fc\u30ef\u30fc\u30c9\u691c\u7d22"));
        this.searchButtonPanel.setLayout(new BoxLayout(this.searchButtonPanel, 0));
        this.combinedSearchPanel.setLayout(new BoxLayout(this.combinedSearchPanel, 0));
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
        this.setLayout(new BorderLayout(0, 11));
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.scroller, "Center");
    }

    private void doSearch(JTextComponent keyField, String searchClass, JScrollPane scrollPane) {
        try {
            this.searchClass = searchClass;
            this.search(keyField.getText().trim(), true);
            this.setFocus(keyField);
            this.scrollToTop(scrollPane);
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    private void doSort(MouseEvent e) {
        int viewColumn = this.table.getTableHeader().columnAtPoint(e.getPoint());
        int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
        this.setSortBy(sortColumnNames[modelColumn]);
        String key = this.findField.getText().trim();
        this.search(key, true);
    }

    private void setFocus(final JComponent component) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                component.requestFocusInWindow();
            }
        });
    }

    private void scrollToTop(JScrollPane scrollPane) {
        JScrollBar bar = scrollPane.getVerticalScrollBar();
        bar.setValue(bar.getMinimum());
    }

    private void initComponents() {
        this.bg = new ButtonGroup();
        this.topPanel = new JPanel();
        this.keyPanel = new JPanel();
        this.combinedSearchPanel = new JPanel();
        this.searchField = new JTextField();
        this.jLabel2 = new JLabel();
        this.searchButtonPanel = new JPanel();
        this.prefixButton = new JButton();
        this.typeButton = new JButton();
        this.diseaseButton = new JButton();
        this.postfixButton = new JButton();
        this.findField = new JTextField();
        this.jLabel3 = new JLabel();
        this.scroller = new JScrollPane();
        this.table = new JTable();
        this.topPanel.setName("topPanel");
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(DiagnosisMasterPanel.class);
        this.keyPanel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("masterSearch.text.keywordBorderTitle", new Object[0])));
        this.keyPanel.setName("keyPanel");
        this.combinedSearchPanel.setName("combinedSearchPanel");
        this.searchField.setColumns(10);
        this.searchField.setName("searchField");
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisMasterPanel.this.searchFieldActionPerformed(evt);
            }
        });
        this.searchField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DiagnosisMasterPanel.this.searchFieldPropertyChange(evt);
            }
        });
        this.jLabel2.setText("\u50b7\u75c5\u540d\u5165\u529b:");
        this.jLabel2.setName("jLabel2");
        GroupLayout combinedSearchPanelLayout = new GroupLayout(this.combinedSearchPanel);
        this.combinedSearchPanel.setLayout(combinedSearchPanelLayout);
        combinedSearchPanelLayout.setHorizontalGroup(combinedSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(combinedSearchPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchField, -2, 60, -2).addContainerGap(-1, Short.MAX_VALUE)));
        combinedSearchPanelLayout.setVerticalGroup(combinedSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(combinedSearchPanelLayout.createSequentialGroup().addContainerGap().addGroup(combinedSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.searchField, -2, -1, -2)).addContainerGap(12, Short.MAX_VALUE)));
        this.searchButtonPanel.setName("searchButtonPanel");
        this.prefixButton.setText("\u90e8\u4f4d");
        this.prefixButton.setName("prefixButton");
        this.prefixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisMasterPanel.this.prefixButtonActionPerformed(evt);
            }
        });
        this.typeButton.setText("\u6027\u8cea");
        this.typeButton.setName("typeButton");
        this.typeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisMasterPanel.this.typeButtonActionPerformed(evt);
            }
        });
        this.diseaseButton.setText("\u75c5\u540d");
        this.diseaseButton.setName("diseaseButton");
        this.diseaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisMasterPanel.this.diseaseButtonActionPerformed(evt);
            }
        });
        this.postfixButton.setText("\u63a5\u5c3e");
        this.postfixButton.setName("postfixButton");
        this.postfixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisMasterPanel.this.postfixButtonActionPerformed(evt);
            }
        });
        this.findField.setColumns(10);
        this.findField.setName("findField");
        this.findField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisMasterPanel.this.findFieldActionPerformed(evt);
            }
        });
        this.findField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DiagnosisMasterPanel.this.findFieldPropertyChange(evt);
            }
        });
        this.jLabel3.setText("\u90e8\u5206\u691c\u7d22:");
        this.jLabel3.setName("jLabel3");
        GroupLayout searchButtonPanelLayout = new GroupLayout(this.searchButtonPanel);
        this.searchButtonPanel.setLayout(searchButtonPanelLayout);
        searchButtonPanelLayout.setHorizontalGroup(searchButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchButtonPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.findField, -1, 61, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.prefixButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.typeButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.diseaseButton, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.postfixButton).addContainerGap()));
        searchButtonPanelLayout.setVerticalGroup(searchButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchButtonPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchButtonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.findField, -2, -1, -2).addComponent(this.prefixButton).addComponent(this.typeButton).addComponent(this.diseaseButton).addComponent(this.postfixButton).addComponent(this.jLabel3, -2, 21, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout keyPanelLayout = new GroupLayout(this.keyPanel);
        this.keyPanel.setLayout(keyPanelLayout);
        keyPanelLayout.setHorizontalGroup(keyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(keyPanelLayout.createSequentialGroup().addComponent(this.combinedSearchPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButtonPanel, -1, -1, Short.MAX_VALUE)));
        keyPanelLayout.setVerticalGroup(keyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(keyPanelLayout.createSequentialGroup().addGroup(keyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.combinedSearchPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.searchButtonPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout topPanelLayout = new GroupLayout(this.topPanel);
        this.topPanel.setLayout(topPanelLayout);
        topPanelLayout.setHorizontalGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.keyPanel, -2, -1, -2).addContainerGap(16, Short.MAX_VALUE)));
        topPanelLayout.setVerticalGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.keyPanel, -1, 61, Short.MAX_VALUE).addContainerGap()));
        this.scroller.setName("scroller");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"\u30b3\u30fc\u30c9", "\u540d\u79f0", "\u30ab\u30ca", "ICD10", "\u6709\u52b9\u671f\u9650"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setName("table");
        this.table.setSelectionMode(1);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagnosisMasterPanel.this.tableMouseClicked(evt);
            }
        });
        this.scroller.setViewportView(this.table);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(50);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.topPanel, -1, -1, Short.MAX_VALUE).addComponent(this.scroller, -1, 632, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.topPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroller, -1, 271, Short.MAX_VALUE)));
    }

    private void searchFieldActionPerformed(ActionEvent evt) {
        this.sortable = false;
        this.doSearch(this.searchField, ClaimConst.SubTypeSet.NAMES.getName(), this.scroller);
    }

    private void prefixButtonActionPerformed(ActionEvent evt) {
        this.sortable = true;
        this.doSearch(this.findField, ClaimConst.SubTypeSet.PREFIX.getName(), this.scroller);
    }

    private void typeButtonActionPerformed(ActionEvent evt) {
        this.sortable = true;
        this.doSearch(this.findField, ClaimConst.SubTypeSet.TYPE.getName(), this.scroller);
    }

    private void diseaseButtonActionPerformed(ActionEvent evt) {
        this.sortable = true;
        String key = this.findField.getText().trim();
        if (!key.equals("")) {
            this.searchClass = "";
            this.search(key, true);
            this.setFocus(this.findField);
            this.scrollToTop(this.scroller);
        }
    }

    private void postfixButtonActionPerformed(ActionEvent evt) {
        this.sortable = true;
        this.doSearch(this.findField, ClaimConst.SubTypeSet.POSTFIX.getName(), this.scroller);
    }

    private void searchFieldPropertyChange(PropertyChangeEvent evt) {
        if (!this.searchField.getText().equals("")) {
            this.sortable = false;
            this.doSearch(this.searchField, ClaimConst.SubTypeSet.NAMES.getName(), this.scroller);
        }
    }

    private void tableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int[] rows;
            for (int row : rows = this.table.getSelectedRows()) {
                DiseaseEntry entry = (DiseaseEntry)this.tableModel.getObject(row);
                if (entry != null && entry.useState(new GregorianCalendar()) != 2) {
                    this.findField.setText("");
                    MasterItem mItem = new MasterItem(0, entry);
                    mItem.setClaimDiseaseCode(mItem.getCode());
                    mItem.setMasterTableId(codeSystem);
                    SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
                    switch (dao.IsAutoCulcFromOrca(mItem.getCode())) {
                        case NORMAL: {
                            this.setSelectedItem(mItem);
                            break;
                        }
                        case KENSA: {
                            this.setSelectedItem(mItem);
                            break;
                        }
                        case AUTO: {
                            if (JOptionPane.showConfirmDialog(null, "\u81ea\u52d5\u7b97\u5b9a\u9805\u76ee\u3067\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u78ba\u8a8d", 0) != 0) break;
                            this.setSelectedItem(mItem);
                            break;
                        }
                        default: {
                            this.setSelectedItem(mItem);
                        }
                    }
                }
                this.setFocus(this.findField);
            }
        }
    }

    private void findFieldActionPerformed(ActionEvent evt) {
        this.doSearch(this.findField, "", this.scroller);
    }

    private void findFieldPropertyChange(PropertyChangeEvent evt) {
    }
}

