/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.caremapdocument;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.ImageEntry;
import open.dolphin.client.caremapdocument.AppointColors;
import open.dolphin.client.caremapdocument.AppointEntryTransferable;
import open.dolphin.client.caremapdocument.CareMapDocumentPanel;
import open.dolphin.client.caremapdocument.MedicalEvent;
import open.dolphin.infomodel.AppointmentModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalSettings;
import open.dolphin.utils.MMLDate;

public final class SimpleCalendarPanel
extends JPanel
implements DragGestureListener,
DropTargetListener,
DragSourceListener {
    private static final long serialVersionUID = 3030024622746649784L;
    private String[] columnNames = new String[]{"\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};
    private int year;
    private int month;
    private int numRows;
    private int firstCol;
    private int lastCol;
    private GregorianCalendar firstDay;
    private GregorianCalendar lastDay;
    private GregorianCalendar today;
    private String birthday;
    private JTable table;
    private MedicalEvent[][] days;
    private int rowHeight = 18;
    private int columnWidth = 27;
    private int horizontalAlignment = 4;
    private int autoResizeMode = 4;
    private Color sundayColor = GlobalSettings.getColors(GlobalSettings.Parts.SUNDAY_FORE);
    private Color saturdayColor = GlobalSettings.getColors(GlobalSettings.Parts.SATURDAY_FORE);
    private Color todayBackground = GlobalSettings.getColors(GlobalSettings.Parts.TODAY_BACK);
    private Color calendarBackground = GlobalSettings.getColors(GlobalSettings.Parts.CALENDAR_BACK);
    private Color weekdayColor = GlobalSettings.getColors(GlobalSettings.Parts.WEEKDAY_FORE);
    private Color birthdayColor = GlobalSettings.getColors(GlobalSettings.Parts.BIRTHDAY_BACK);
    private Font outOfMonthFont = new Font("Dialog", 0, 9);
    private Font inMonthFont = new Font("Dialog", 0, 12);
    private DragSource dragSource;
    private int dragRow;
    private int dragCol;
    private int relativeMonth;
    private IChart context;
    private IChartDocument parent;
    private boolean dirty;
    private JPopupMenu appointMenu;
    private int popedRow;
    private int popedCol;
    private String markEvent = "-1";
    private PropertyChangeSupport boundSupport;

    public SimpleCalendarPanel() {
        this.initComponents();
        this.setLayout(new BorderLayout());
    }

    private SimpleCalendarPanel(int n) {
        this();
        this.relativeMonth = n;
        this.today = new GregorianCalendar();
        this.today.clear(14);
        this.today.clear(13);
        this.today.clear(12);
        this.today.clear(11);
        GregorianCalendar gc = (GregorianCalendar)this.today.clone();
        gc.add(2, n);
        this.year = gc.get(1);
        this.month = gc.get(2);
        this.table = this.createCalendarTable(gc);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 1) {
                    return;
                }
                Point p = e.getPoint();
                int row = SimpleCalendarPanel.this.table.rowAtPoint(p);
                int col = SimpleCalendarPanel.this.table.columnAtPoint(p);
                if (row != -1 && col != -1) {
                    MedicalEvent evt = SimpleCalendarPanel.this.days[row][col];
                    if (evt.getMedicalCode() != null) {
                        SimpleCalendarPanel.this.boundSupport.firePropertyChange("SELECTED_DATE_PROP", null, evt.getDisplayDate());
                    } else if (evt.getAppointmentName() != null) {
                        SimpleCalendarPanel.this.boundSupport.firePropertyChange("SELECTED_DATE_PROP", null, evt.getDisplayDate());
                    }
                }
            }
        });
        String title = this.getCalendarTitle();
        this.add((Component)this.table.getTableHeader(), "North");
        this.add((Component)this.table, "Center");
        this.setBorder(BorderFactory.createTitledBorder(title));
        Dimension dim = new Dimension(this.columnWidth * 7 + 10, this.rowHeight * 8 + 5);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.appointMenu = new JPopupMenu();
        this.appointMenu.add(new JMenuItem(new AbstractAction("\u53d6\u308a\u6d88\u3057"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleCalendarPanel.this.appointCancel();
            }
        }));
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.table, 3, this);
        new DropTarget(this.table, this);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void setChartContext(IChart context) {
        this.context = context;
        this.birthday = context.getPatient().getBirthday().substring(5);
    }

    public void setParent(CareMapDocumentPanel doc) {
        this.parent = doc;
    }

    public String getCalendarTitle() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.year);
        buf.append("\u5e74");
        buf.append(this.month + 1);
        buf.append("\u6708");
        return buf.toString();
    }

    public int getRelativeMonth() {
        return this.relativeMonth;
    }

    public boolean isThisMonth() {
        return this.relativeMonth == 0;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        if (this.boundSupport == null) {
            this.boundSupport = new PropertyChangeSupport(this);
        }
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener l) {
        if (this.boundSupport == null) {
            this.boundSupport = new PropertyChangeSupport(this);
        }
        this.boundSupport.removePropertyChangeListener(propName, l);
    }

    public String getFirstDate() {
        return MMLDate.getDate(this.firstDay);
    }

    public String getLastDate() {
        return MMLDate.getDate(this.lastDay);
    }

    public List<AppointmentModel> getAppointDays() {
        int col;
        ArrayList<AppointmentModel> results = new ArrayList<AppointmentModel>();
        MedicalEvent event = null;
        AppointmentModel appoint = null;
        for (col = this.firstCol; col < 7; ++col) {
            event = this.days[0][col];
            appoint = event.getAppointEntry();
            if (appoint == null || appoint.getName() == null) continue;
            results.add(appoint);
        }
        for (int row = 1; row < this.numRows - 1; ++row) {
            for (int col2 = 0; col2 < 7; ++col2) {
                event = this.days[row][col2];
                appoint = event.getAppointEntry();
                if (appoint == null || appoint.getName() == null) continue;
                results.add(appoint);
            }
        }
        for (col = 0; col < this.lastCol + 1; ++col) {
            event = this.days[this.numRows - 1][col];
            appoint = event.getAppointEntry();
            if (appoint == null || appoint.getName() == null) continue;
            results.add(appoint);
        }
        return results;
    }

    public List<AppointmentModel> getUpdatedAppoints() {
        int col;
        ArrayList<AppointmentModel> results = new ArrayList<AppointmentModel>();
        MedicalEvent event = null;
        AppointmentModel appoint = null;
        for (col = this.firstCol; col < 7; ++col) {
            event = this.days[0][col];
            appoint = event.getAppointEntry();
            if (appoint == null || appoint.getState() == 0) continue;
            results.add(appoint);
        }
        for (int row = 1; row < this.numRows - 1; ++row) {
            for (int col2 = 0; col2 < 7; ++col2) {
                event = this.days[row][col2];
                appoint = event.getAppointEntry();
                if (appoint == null || appoint.getState() == 0) continue;
                results.add(appoint);
            }
        }
        for (col = 0; col < this.lastCol + 1; ++col) {
            event = this.days[this.numRows - 1][col];
            appoint = event.getAppointEntry();
            if (appoint == null || appoint.getState() == 0) continue;
            results.add(appoint);
        }
        return results;
    }

    public void setModuleList(String event, List list) {
        this.markEvent = event;
        this.clearMark();
        if (list == null || list.size() == 0) {
            return;
        }
        int size = list.size();
        String mkDate = null;
        MedicalEvent me = null;
        int index = 0;
        int[] ymd = null;
        int row = 0;
        int col = 0;
        ModuleModel module = null;
        for (int i = 0; i < size; ++i) {
            module = (ModuleModel)list.get(i);
            mkDate = ModelUtils.getDateAsString(module.getFirstConfirmed());
            index = mkDate.indexOf(84);
            if (index > 0) {
                mkDate = mkDate.substring(0, index);
            }
            ymd = MMLDate.getCalendarYMD(mkDate);
            int shiftDay = ymd[2] + (this.firstCol - 1);
            row = shiftDay / 7;
            col = shiftDay % 7;
            me = this.days[row][col];
            me.setMedicalCode(this.markEvent);
            ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(row, col);
        }
    }

    public void setImageList(String event, List list) {
        this.markEvent = event;
        this.clearMark();
        if (list == null || list.isEmpty()) {
            return;
        }
        int size = list.size();
        String mkDate = null;
        MedicalEvent me = null;
        int index = 0;
        int[] ymd = null;
        int row = 0;
        int col = 0;
        ImageEntry image = null;
        for (int i = 0; i < size; ++i) {
            image = (ImageEntry)list.get(i);
            mkDate = image.getConfirmDate();
            index = mkDate.indexOf(84);
            if (index > 0) {
                mkDate = mkDate.substring(0, index);
            }
            ymd = MMLDate.getCalendarYMD(mkDate);
            int shiftDay = ymd[2] + (this.firstCol - 1);
            row = shiftDay / 7;
            col = shiftDay % 7;
            me = this.days[row][col];
            me.setMedicalCode(this.markEvent);
            ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(row, col);
        }
    }

    public void setAppointmentList(List list) {
        if (this.relativeMonth < 0) {
            return;
        }
        if (list == null || list.size() == 0) {
            return;
        }
        String startDate = this.isThisMonth() ? MMLDate.getDayFromToday(-3) : MMLDate.getDate(this.firstDay);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            AppointmentModel ae = (AppointmentModel)list.get(i);
            ae.setState(2);
            String date = ModelUtils.getDateAsString(ae.getDate());
            int index = date.indexOf(84);
            if (index > 0) {
                date = date.substring(0, index);
            }
            if (date.compareTo(startDate) < 0) continue;
            int[] ymd = MMLDate.getCalendarYMD(date);
            int shiftDay = ymd[2] + (this.firstCol - 1);
            int row = shiftDay / 7;
            int col = shiftDay % 7;
            MedicalEvent me = this.days[row][col];
            me.setAppointEntry(ae);
            ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(row, col);
        }
    }

    private void clearMark() {
        MedicalEvent me = null;
        boolean exit = false;
        for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < 7; ++col) {
                me = this.days[row][col];
                if (me.isToday()) {
                    exit = true;
                    break;
                }
                if (me.getMedicalCode() == null) continue;
                me.setMedicalCode(null);
                ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(row, col);
            }
            if (exit) break;
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row == -1 || col == -1) {
            return;
        }
        this.dragRow = row;
        this.dragCol = col;
        MedicalEvent me = this.days[row][col];
        AppointmentModel appo = me.getAppointEntry();
        if (appo == null) {
            return;
        }
        AppointEntryTransferable t = new AppointEntryTransferable(appo);
        Cursor cursor = DragSource.DefaultCopyDrop;
        int action = event.getDragAction();
        if (action == 2) {
            cursor = DragSource.DefaultMoveDrop;
        }
        this.dragSource.startDrag(event, cursor, t, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        if (!event.getDropSuccess() || event.getDropAction() == 1) {
            return;
        }
        this.processCancel(this.dragRow, this.dragCol);
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        if (!this.isDropAcceptable(e)) {
            e.rejectDrop();
            this.setDropTargetBorder(false);
            return;
        }
        Transferable tr = e.getTransferable();
        Point loc = e.getLocation();
        int action = e.getDropAction();
        e.acceptDrop(action);
        this.setDropTargetBorder(false);
        int row = this.table.rowAtPoint(loc);
        int col = this.table.columnAtPoint(loc);
        if (row == -1 || col == -1) {
            e.getDropTargetContext().dropComplete(false);
            return;
        }
        MedicalEvent evt = this.days[row][col];
        if (evt.isOutOfMonth()) {
            e.getDropTargetContext().dropComplete(false);
            return;
        }
        if (evt.before(this.today)) {
            e.getDropTargetContext().dropComplete(false);
            return;
        }
        AppointmentModel source = null;
        try {
            source = (AppointmentModel)tr.getTransferData(AppointEntryTransferable.appointFlavor);
        }
        catch (Exception ue) {
            source = null;
        }
        if (source == null) {
            e.getDropTargetContext().dropComplete(false);
            return;
        }
        this.processAppoint(row, col, source.getName(), source.getMemo());
        e.getDropTargetContext().dropComplete(true);
    }

    public boolean isDragAcceptable(DropTargetDragEvent evt) {
        return (evt.getDropAction() & 3) != 0;
    }

    public boolean isDropAcceptable(DropTargetDropEvent evt) {
        return (evt.getDropAction() & 3) != 0;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (!this.isDragAcceptable(e)) {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.setDropTargetBorder(false);
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (this.isDragAcceptable(e)) {
            this.setDropTargetBorder(true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        if (!this.isDragAcceptable(e)) {
            e.rejectDrag();
        }
    }

    private void setDropTargetBorder(boolean b) {
        Color c = b ? new Color(0, 12, 156) : this.getBackground();
        this.table.setBorder(BorderFactory.createLineBorder(c, 2));
    }

    private JTable createCalendarTable(GregorianCalendar gc) {
        this.days = this.createDays(gc);
        AbstractTableModel model = new AbstractTableModel(){
            private static final long serialVersionUID = -6437119956252935580L;

            @Override
            public int getRowCount() {
                return SimpleCalendarPanel.this.days.length;
            }

            @Override
            public int getColumnCount() {
                return SimpleCalendarPanel.this.days[0].length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return SimpleCalendarPanel.this.days[row][col];
            }

            @Override
            public String getColumnName(int col) {
                return SimpleCalendarPanel.this.columnNames[col];
            }

            public Class getColumnClass(int col) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        JTable tbl = new JTable(model);
        tbl.setSelectionMode(0);
        tbl.setCellSelectionEnabled(true);
        tbl.setAutoResizeMode(this.autoResizeMode);
        tbl.setBackground(this.calendarBackground);
        DateRenderer dateRenderer = new DateRenderer();
        dateRenderer.setHorizontalAlignment(this.horizontalAlignment);
        tbl.setDefaultRenderer(Object.class, dateRenderer);
        TableColumn column = null;
        for (int i = 0; i < 7; ++i) {
            column = tbl.getColumnModel().getColumn(i);
            column.setMinWidth(this.columnWidth);
            column.setPreferredWidth(this.columnWidth);
            column.setMaxWidth(this.columnWidth);
        }
        tbl.setRowHeight(this.rowHeight);
        tbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SimpleCalendarPanel.this.appointMenu.isPopupTrigger(e)) {
                    SimpleCalendarPanel.this.doPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SimpleCalendarPanel.this.appointMenu.isPopupTrigger(e)) {
                    SimpleCalendarPanel.this.doPopup(e);
                }
            }
        });
        return tbl;
    }

    private void doPopup(MouseEvent e) {
        if (this.context.isReadOnly()) {
            return;
        }
        this.popedRow = this.table.rowAtPoint(e.getPoint());
        this.popedCol = this.table.columnAtPoint(e.getPoint());
        if (this.popedRow == -1 || this.popedCol == -1) {
            return;
        }
        MedicalEvent me = this.days[this.popedRow][this.popedCol];
        if (me.getAppointmentName() == null) {
            return;
        }
        if (me.before(this.today)) {
            return;
        }
        this.appointMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void appointInspect(ActionEvent e) {
    }

    public void appointTest(ActionEvent e) {
        this.processAppoint(this.popedRow, this.popedCol, "\u691c\u4f53\u691c\u67fb", null);
    }

    public void appointImage(ActionEvent e) {
        this.processAppoint(this.popedRow, this.popedCol, "\u753b\u50cf\u8a3a\u65ad", null);
    }

    public void appointOther(ActionEvent e) {
        this.processAppoint(this.popedRow, this.popedCol, "\u305d\u306e\u4ed6", null);
    }

    public void appointCancel() {
        this.processCancel(this.popedRow, this.popedCol);
    }

    private void processAppoint(int row, int col, String appointName, String memo) {
        MedicalEvent entry = this.days[row][col];
        AppointmentModel appoint = entry.getAppointEntry();
        if (appoint == null) {
            appoint = new AppointmentModel();
            appoint.setDate(ModelUtils.getDateAsObject(entry.getDisplayDate()));
            entry.setAppointEntry(appoint);
        }
        int oldState = appoint.getState();
        int next = 0;
        switch (oldState) {
            case 0: {
                next = 1;
                break;
            }
            case 1: {
                next = 1;
                break;
            }
            case 2: {
                next = 3;
                break;
            }
            case 3: {
                next = 3;
                break;
            }
            default: {
                LogWriter.fatal(this.getClass(), "case default");
            }
        }
        appoint.setState(next);
        appoint.setName(appointName);
        appoint.setMemo(memo);
        ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(this.popedRow, this.popedCol);
        this.boundSupport.firePropertyChange("APPOINT_PROP", null, appoint);
        if (!this.dirty) {
            this.dirty = true;
            this.parent.setDirty(this.dirty);
        }
    }

    private void processCancel(int row, int col) {
        MedicalEvent entry = this.days[row][col];
        AppointmentModel appoint = entry.getAppointEntry();
        if (appoint == null) {
            return;
        }
        int oldState = appoint.getState();
        int nextState = 0;
        switch (oldState) {
            case 0: {
                break;
            }
            case 1: {
                nextState = 0;
                break;
            }
            case 2: {
                nextState = 3;
                break;
            }
            case 3: {
                nextState = 3;
                break;
            }
            default: {
                LogWriter.fatal(this.getClass(), "case default");
            }
        }
        appoint.setState(nextState);
        appoint.setName(null);
        ((AbstractTableModel)this.table.getModel()).fireTableCellUpdated(this.popedRow, this.popedCol);
        this.boundSupport.firePropertyChange("APPOINT_PROP", null, appoint);
        if (!this.dirty) {
            this.dirty = true;
            this.parent.setDirty(this.dirty);
        }
    }

    private MedicalEvent[][] createDays(GregorianCalendar gc) {
        MedicalEvent[][] data = null;
        int dayOfMonth = gc.get(5);
        int numDaysOfMonth = gc.getActualMaximum(5);
        gc.add(5, numDaysOfMonth - dayOfMonth);
        this.lastDay = (GregorianCalendar)gc.clone();
        this.numRows = gc.get(4);
        this.lastCol = gc.get(7);
        --this.lastCol;
        gc.add(5, -(--numDaysOfMonth));
        this.firstDay = (GregorianCalendar)gc.clone();
        this.firstCol = gc.get(7);
        --this.firstCol;
        gc.add(5, -this.firstCol);
        data = new MedicalEvent[this.numRows][7];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < 7; ++j) {
                MedicalEvent me = new MedicalEvent(gc.get(1), gc.get(2), gc.get(5), gc.get(7));
                boolean b = this.month == gc.get(2);
                me.setOutOfMonth(!b);
                b = this.today.equals(gc);
                me.setToday(b);
                data[i][j] = me;
                gc.add(5, 1);
            }
        }
        return data;
    }

    public static class SimpleCalendarPool {
        private static SimpleCalendarPool instance = new SimpleCalendarPool();
        private Map<String, List> poolDictionary = new HashMap<String, List>(12, 0.75f);

        private SimpleCalendarPool() {
        }

        public static SimpleCalendarPool getInstance() {
            return instance;
        }

        public synchronized SimpleCalendarPanel acquireSimpleCalendar(int n) {
            List pool = this.poolDictionary.get(String.valueOf(n));
            if (pool != null) {
                int size = pool.size();
                return (SimpleCalendarPanel)pool.remove(--size);
            }
            return new SimpleCalendarPanel(n);
        }

        public synchronized void releaseSimpleCalendar(SimpleCalendarPanel c) {
            int n = c.getRelativeMonth();
            String key = String.valueOf(n);
            ArrayList<SimpleCalendarPanel> pool = this.poolDictionary.get(key);
            if (pool == null) {
                pool = new ArrayList<SimpleCalendarPanel>(5);
                this.poolDictionary.put(key, pool);
            }
            pool.add(c);
        }
    }

    class DateRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -5061911803358533448L;

        public DateRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            Component compo = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
            if (value != null) {
                MedicalEvent me = (MedicalEvent)value;
                String eventCode = me.getMedicalCode();
                int dayOfWeek = me.getDayOfWeek();
                if (dayOfWeek == 1) {
                    this.setForeground(SimpleCalendarPanel.this.sundayColor);
                } else if (dayOfWeek == 7) {
                    this.setForeground(SimpleCalendarPanel.this.saturdayColor);
                } else {
                    this.setForeground(SimpleCalendarPanel.this.weekdayColor);
                }
                if (me.isOutOfMonth()) {
                    this.setFont(SimpleCalendarPanel.this.outOfMonthFont);
                } else {
                    this.setFont(SimpleCalendarPanel.this.inMonthFont);
                }
                if (me.getDisplayDate().endsWith(SimpleCalendarPanel.this.birthday)) {
                    this.setBackground(SimpleCalendarPanel.this.birthdayColor);
                } else if (me.isToday() && !me.isOutOfMonth()) {
                    this.setBackground(SimpleCalendarPanel.this.todayBackground);
                } else if (eventCode != null) {
                    Color c = AppointColors.getOrderColor(eventCode);
                    this.setBackground(c);
                } else if (me.getAppointEntry() != null) {
                    String appoName = me.getAppointmentName();
                    if (appoName == null) {
                        this.setBackground(SimpleCalendarPanel.this.calendarBackground);
                    } else {
                        Color c = AppointColors.getAppointColor(appoName);
                        if (me.before(SimpleCalendarPanel.this.today)) {
                            this.setBackground(SimpleCalendarPanel.this.calendarBackground);
                            this.setBorder(BorderFactory.createLineBorder(c));
                        } else {
                            this.setBackground(c);
                        }
                    }
                } else {
                    this.setBackground(SimpleCalendarPanel.this.calendarBackground);
                }
                ((JLabel)compo).setText(me.toString());
            }
            return compo;
        }
    }
}

