/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.pvtclientserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import open.dolphin.client.IMainWindow;
import open.dolphin.log.LogWriter;
import open.dolphin.pvtclientserver.AcceptHandler;
import open.dolphin.pvtclientserver.IHandler;
import open.dolphin.server.IPVTServer;

public class PVTClientServer
implements IPVTServer,
Runnable {
    public static final int EOT = 4;
    public static final int ACK = 6;
    public static final int NAK = 21;
    public static final String UTF8 = "UTF8";
    public static final String SJIS = "SHIFT_JIS";
    public static final String EUC = "EUC_JIS";
    private static final int DEFAULT_PORT = 5002;
    private int port = 5002;
    private String encoding = "UTF8";
    private Selector selector;
    private ServerSocketChannel serverSocketChannel;
    private ExecutorService service;
    private IMainWindow context;
    private String name;

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    private void setup() {
        try {
            this.selector = SelectorProvider.provider().openSelector();
            this.serverSocketChannel = SelectorProvider.provider().openServerSocketChannel();
            this.serverSocketChannel.configureBlocking(false);
            InetAddress wildcard = null;
            InetSocketAddress address = new InetSocketAddress(wildcard, this.port);
            this.serverSocketChannel.socket().bind(address);
            this.serverSocketChannel.register(this.selector, 16, new AcceptHandler());
        }
        catch (IOException e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    public void startService() {
        try {
            this.setup();
            this.service = Executors.newSingleThreadExecutor();
            this.service.execute(this);
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    public void stopService() {
        try {
            this.service.shutdownNow();
            this.serverSocketChannel.close();
            this.selector.close();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    @Override
    public void run() {
        try {
            while (this.selector.select() > 0) {
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> it = keys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    IHandler handler = (IHandler)key.attachment();
                    handler.handle(key);
                }
            }
        }
        catch (ClosedSelectorException cse) {
        }
        catch (IOException e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    @Override
    public void start() {
        this.startService();
    }

    @Override
    public void stop() {
        this.stopService();
    }
}

