/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.project;

import com.sun.net.ssl.internal.ssl.Provider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import open.dolphin.container.NameValuePair;
import open.dolphin.infomodel.DepartmentModel;
import open.dolphin.infomodel.DiagnosisCategoryModel;
import open.dolphin.infomodel.DiagnosisOutcomeModel;
import open.dolphin.infomodel.LicenseModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalSettings;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SessionStorage;

public class GlobalConstantsImplement {
    private final String RESOURCE_LOCATION = "/open/dolphin/resources/";
    private final String TEMPLATE_LOCATION = "/open/dolphin/resources/templates/";
    private final String IMAGE_LOCATION = "/open/dolphin/resources/images/";
    private final String SCHEMA_LOCATION = "/open/dolphin/resources/schema/";
    private final String RESOURCE = "open.dolphin.resources.Dolphin_ja";
    private ResourceBundle resBundle;
    private Map<String, Color> eventColorTable;
    private ApplicationContext applicationContext;
    private boolean SSL = true;

    public GlobalConstantsImplement(ApplicationContext context) {
        try {
            this.resBundle = ResourceBundle.getBundle("open.dolphin.resources.Dolphin_ja");
            StringBuilder logConfig = new StringBuilder();
            logConfig.append(this.getLocation("setting"));
            logConfig.append(File.separator);
            logConfig.append(this.getString("log.config.file"));
            StringBuilder velocityLog = new StringBuilder();
            velocityLog.append(context.getLocalStorage().getDirectory());
            velocityLog.append(File.separator);
            velocityLog.append(this.getString("log.dir"));
            velocityLog.append(File.separator);
            velocityLog.append(this.getString("application.velocity.log.file"));
            Velocity.setProperty((String)"runtime.log", (Object)velocityLog.toString());
            Velocity.init();
            this.setUIFonts();
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("mac")) {
                System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(GlobalSettings.useScreenMenuBarOnMac()));
            }
            StringBuilder loginConfigPath = new StringBuilder();
            loginConfigPath.append(context.getLocalStorage().getDirectory());
            loginConfigPath.append(File.separator);
            loginConfigPath.append(this.getString("security.dir"));
            loginConfigPath.append(File.separator);
            loginConfigPath.append(this.getString("application.security.login.config"));
            String loginConfig = loginConfigPath.toString();
            System.setProperty("java.security.auth.login.config", loginConfig);
            if (this.SSL) {
                Security.addProvider((java.security.Provider)new Provider());
                StringBuilder trustStorePath = new StringBuilder();
                trustStorePath.append(context.getLocalStorage().getDirectory());
                trustStorePath.append(File.separator);
                trustStorePath.append(this.getString("security.dir"));
                trustStorePath.append(File.separator);
                trustStorePath.append(this.getString("application.security.ssl.trustStore"));
                String trustStore = trustStorePath.toString();
                System.setProperty("javax.net.ssl.trustStore", trustStore);
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ResourceMap getResourceMap(Class clazz) {
        return this.applicationContext.getResourceMap(clazz);
    }

    public ActionMap getActionMap(Object obj) {
        return this.applicationContext.getActionMap(obj);
    }

    public SessionStorage getSessionStorage() {
        return this.applicationContext.getSessionStorage();
    }

    public LocalStorage getLocalStorage() {
        return this.applicationContext.getLocalStorage();
    }

    public VelocityContext getVelocityContext() {
        return new VelocityContext();
    }

    public boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public boolean isWin() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public String getLocation(String dir) {
        String ret = null;
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty(this.getString("base.dir")));
        if (dir.equals("base")) {
            ret = sb.toString();
        } else if (dir.equals("lib")) {
            sb.append(File.separator);
            if (this.isMac()) {
                sb.append(this.getString("lib.mac.dir"));
            } else {
                sb.append(this.getString("lib.dir"));
            }
            ret = sb.toString();
        } else if (dir.equals("dolphin.jar")) {
            if (this.isMac()) {
                sb.append(File.separator);
                sb.append(this.getString("dolphin.jar.mac.dir"));
            }
            ret = sb.toString();
        } else if (dir.equals("security")) {
            sb.append(File.separator);
            sb.append(this.getString("security.dir"));
            ret = sb.toString();
        } else if (dir.equals("log")) {
            sb.append(File.separator);
            sb.append(this.getString("log.dir"));
            ret = sb.toString();
        } else if (dir.equals("setting")) {
            sb.append(File.separator);
            sb.append(this.getString("setting.dir"));
            ret = sb.toString();
        } else if (dir.equals("schema")) {
            File localStorage = this.getApplicationContext().getLocalStorage().getDirectory();
            File directory = new File(localStorage, this.getString("schema.dir"));
            ret = directory.toString();
        } else if (dir.equals("plugins")) {
            sb.append(File.separator);
            sb.append(this.getString("plugins.dir"));
            ret = sb.toString();
        } else if (dir.equals("pdf")) {
            sb.append(File.separator);
            sb.append(this.getString("pdf.dir"));
            ret = sb.toString();
        }
        return ret;
    }

    public String getBaseDirectory() {
        return this.getLocation("base");
    }

    public String getSettingDirectory() {
        return this.getLocation("setting");
    }

    public String getSecurityDirectory() {
        return this.getLocation("security");
    }

    public String getLogDirectory() {
        return this.getLocation("log");
    }

    public String getPDFDirectory() {
        return this.getLocation("pdf");
    }

    public String getVersion() {
        return this.getString("version");
    }

    public String getUpdateURL() {
        if (this.isMac()) {
            return this.getString("updater.url.mac");
        }
        if (this.isWin()) {
            return this.getString("updater.url.win");
        }
        if (this.isLinux()) {
            return this.getString("updater.url.linux");
        }
        return this.getString("updater.url.linux");
    }

    public String getFrameTitle(String title) {
        try {
            String resTitle = this.getString(title);
            if (resTitle != null) {
                title = resTitle;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder();
        buf.append(title);
        buf.append("-");
        buf.append(this.getString("application.title"));
        return buf.toString();
    }

    public URL getResource(String name) {
        if (!name.startsWith("/")) {
            name = "/open/dolphin/resources/" + name;
        }
        return this.getClass().getResource(name);
    }

    public URL getMenuBarResource() {
        return this.getResource("MainMenuBar.xml");
    }

    public URL getImageResource(String name) {
        if (!name.startsWith("/")) {
            name = "/open/dolphin/resources/images/" + name;
        }
        return this.getClass().getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        if (!name.startsWith("/")) {
            name = "/open/dolphin/resources/" + name;
        }
        return this.getClass().getResourceAsStream(name);
    }

    public InputStream getTemplateAsStream(String name) {
        if (!name.startsWith("/")) {
            name = "/open/dolphin/resources/templates/" + name;
        }
        return this.getClass().getResourceAsStream(name);
    }

    public ImageIcon getImageIcon(String name) {
        return new ImageIcon(this.getImageResource(name));
    }

    public ImageIcon getSchemaIcon(String name) {
        if (!name.startsWith("/")) {
            name = "/open/dolphin/resources/schema/" + name;
        }
        return new ImageIcon(this.getClass().getResource(name));
    }

    public LicenseModel[] getLicenseModel() {
        String[] desc = this.getStringArray("licenseDesc");
        String[] code = this.getStringArray("license");
        String codeSys = this.getString("licenseCodeSys");
        LicenseModel[] ret = new LicenseModel[desc.length];
        LicenseModel model = null;
        for (int i = 0; i < desc.length; ++i) {
            model = new LicenseModel();
            model.setLicense(code[i]);
            model.setLicenseDesc(desc[i]);
            model.setLicenseCodeSys(codeSys);
            ret[i] = model;
        }
        return ret;
    }

    public DepartmentModel[] getDepartmentModel() {
        String[] desc = this.getStringArray("departmentDesc");
        String[] code = this.getStringArray("department");
        String codeSys = this.getString("departmentCodeSys");
        DepartmentModel[] ret = new DepartmentModel[desc.length];
        DepartmentModel model = null;
        for (int i = 0; i < desc.length; ++i) {
            model = new DepartmentModel();
            model.setDepartment(code[i]);
            model.setDepartmentDesc(desc[i]);
            model.setDepartmentCodeSys(codeSys);
            ret[i] = model;
        }
        return ret;
    }

    public DiagnosisOutcomeModel[] getDiagnosisOutcomeModel() {
        String[] desc = new String[]{"\u56de\u5fa9", "\u5168\u6cbb", "\u7d9a\u767a\u75c7(\u306e\u767a\u751f)", "\u7d42\u4e86", "\u4e2d\u6b62", "\u7d99\u7d9a", "\u6b7b\u4ea1", "\u60aa\u5316", "\u4e0d\u5909", "\u8ee2\u533b", "\u8ee2\u533b(\u6025\u6027\u75c5\u9662\u3078)", "\u8ee2\u533b(\u6162\u6027\u75c5\u9662\u3078)", "\u81ea\u5b85\u3078\u9000\u9662", "\u4e0d\u660e"};
        String[] code = new String[]{"recovering", "fullyRecovered", "sequelae", "end", "pause", "continued", "died", "worsening", "unchanged", "transfer", "transferAcute", "transferChronic", "home", "unknown"};
        String codeSys = "MML0016";
        DiagnosisOutcomeModel[] ret = new DiagnosisOutcomeModel[desc.length];
        DiagnosisOutcomeModel model = null;
        for (int i = 0; i < desc.length; ++i) {
            model = new DiagnosisOutcomeModel();
            model.setOutcome(code[i]);
            model.setOutcomeDesc(desc[i]);
            model.setOutcomeCodeSys(codeSys);
            ret[i] = model;
        }
        return ret;
    }

    public DiagnosisCategoryModel[] getDiagnosisCategoryModel() {
        String[] desc = new String[]{"\u56de\u5fa9", "\u5168\u6cbb", "\u7d9a\u767a\u75c7(\u306e\u767a\u751f)", "\u7d42\u4e86", "\u4e2d\u6b62", "\u7d99\u7d9a", "\u6b7b\u4ea1", "\u60aa\u5316", "\u4e0d\u5909", "\u8ee2\u533b", "\u8ee2\u533b(\u6025\u6027\u75c5\u9662\u3078)", "\u8ee2\u533b(\u6162\u6027\u75c5\u9662\u3078)", "\u81ea\u5b85\u3078\u9000\u9662", "\u4e0d\u660e"};
        String[] code = new String[]{"recovering", "fullyRecovered", "sequelae", "end", "pause", "continued", "died", "worsening", "unchanged", "transfer", "transferAcute", "transferChronic", "home", "unknown"};
        String[] codeSys = new String[]{"MML0016"};
        DiagnosisCategoryModel[] ret = new DiagnosisCategoryModel[desc.length];
        DiagnosisCategoryModel model = null;
        for (int i = 0; i < desc.length; ++i) {
            model = new DiagnosisCategoryModel();
            model.setDiagnosisCategory(code[i]);
            model.setDiagnosisCategoryDesc(desc[i]);
            model.setDiagnosisCategoryCodeSys(codeSys[i]);
            ret[i] = model;
        }
        return ret;
    }

    public NameValuePair[] getNameValuePair(String key) {
        NameValuePair[] ret = null;
        String[] code = this.getStringArray(key + ".value");
        String[] name = this.getStringArray(key + ".name");
        int len = code.length;
        ret = new NameValuePair[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = new NameValuePair(name[i], code[i]);
        }
        return ret;
    }

    public Map<String, Color> getEventColorTable() {
        if (this.eventColorTable == null) {
            this.setupEventColorTable();
        }
        return this.eventColorTable;
    }

    private void setupEventColorTable() {
        this.eventColorTable = new HashMap<String, Color>(10, 0.75f);
        this.eventColorTable.put("TODAY", this.getColor("color.TODAY_BACK"));
        this.eventColorTable.put("BIRTHDAY", this.getColor("color.BIRTHDAY_BACK"));
        this.eventColorTable.put("PVT", this.getColor("color.PVT"));
        this.eventColorTable.put("DOC_HISTORY", this.getColor("color.PVT"));
    }

    public String getString(String key) {
        return this.resBundle.getString(key);
    }

    public String[] getStringArray(String key) {
        String line = this.getString(key);
        return line.split(",");
    }

    public int getInt(String key) {
        return Integer.parseInt(this.getString(key));
    }

    public int[] getIntArray(String key) {
        String[] obj = this.getStringArray(key);
        int[] ret = new int[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ret[i] = Integer.parseInt(obj[i]);
        }
        return ret;
    }

    public long getLong(String key) {
        return Long.parseLong(this.getString(key));
    }

    public long[] getLongArray(String key) {
        String[] obj = this.getStringArray(key);
        long[] ret = new long[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ret[i] = Long.parseLong(obj[i]);
        }
        return ret;
    }

    public float getFloat(String key) {
        return Float.parseFloat(this.getString(key));
    }

    public float[] getFloatArray(String key) {
        String[] obj = this.getStringArray(key);
        float[] ret = new float[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ret[i] = Float.parseFloat(obj[i]);
        }
        return ret;
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.getString(key));
    }

    public double[] getDoubleArray(String key) {
        String[] obj = this.getStringArray(key);
        double[] ret = new double[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ret[i] = Double.parseDouble(obj[i]);
        }
        return ret;
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getString(key));
    }

    public boolean[] getBooleanArray(String key) {
        String[] obj = this.getStringArray(key);
        boolean[] ret = new boolean[obj.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Boolean.valueOf(obj[i]);
        }
        return ret;
    }

    public Point lgetPoint(String name) {
        int[] data = this.getIntArray(name);
        return new Point(data[0], data[1]);
    }

    public Dimension getDimension(String name) {
        int[] data = this.getIntArray(name);
        return new Dimension(data[0], data[1]);
    }

    public Insets getInsets(String name) {
        int[] data = this.getIntArray(name);
        return new Insets(data[0], data[1], data[2], data[3]);
    }

    public Color getColor(String key) {
        int[] data = this.getIntArray(key);
        return new Color(data[0], data[1], data[2]);
    }

    public Color[] getColorArray(String key) {
        int[] data = this.getIntArray(key);
        int cnt = data.length / 3;
        Color[] ret = new Color[cnt];
        for (int i = 0; i < cnt; ++i) {
            int bias = i * 3;
            ret[i] = new Color(data[bias], data[bias + 1], data[bias + 2]);
        }
        return ret;
    }

    public Class[] getClassArray(String name) {
        String[] clsStr = this.getStringArray(name);
        Class[] ret = new Class[clsStr.length];
        try {
            for (int i = 0; i < clsStr.length; ++i) {
                ret[i] = Class.forName(clsStr[i]);
            }
            return ret;
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
            return null;
        }
    }

    private void setUIFonts() {
        if (this.isWin() || this.isLinux()) {
            int size = 12;
            if (this.isLinux()) {
                size = 13;
            }
            Font font = new Font("SansSerif", 0, size);
            UIManager.put("Label.font", font);
            UIManager.put("Button.font", font);
            UIManager.put("ToggleButton.font", font);
            UIManager.put("Menu.font", font);
            UIManager.put("MenuItem.font", font);
            UIManager.put("CheckBox.font", font);
            UIManager.put("CheckBoxMenuItem.font", font);
            UIManager.put("RadioButton.font", font);
            UIManager.put("RadioButtonMenuItem.font", font);
            UIManager.put("ToolBar.font", font);
            UIManager.put("ComboBox.font", font);
            UIManager.put("TabbedPane.font", font);
            UIManager.put("TitledBorder.font", font);
            UIManager.put("List.font", font);
        }
    }
}

